/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.Box;
import com.sun.perseus.j2d.PaintServer;
import com.sun.perseus.j2d.RenderGraphics;
import com.sun.perseus.j2d.Transform;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.GlyphLayout;
import com.sun.perseus.model.StructureNodeProxy;
import com.sun.perseus.model.Text;
import org.w3c.dom.svg.SVGRect;

public class TextProxy
extends StructureNodeProxy {
    protected GlyphLayout firstChunk;
    protected GlyphLayout lastChunk;

    public TextProxy(Text proxiedText) {
        super(proxiedText);
    }

    public SVGRect getBBox() {
        return this.addNodeBBox(null, null);
    }

    Box addNodeBBox(Box bbox, Transform t) {
        this.checkLayout();
        return ((Text)this.proxied).addNodeBBox(bbox, t, this.firstChunk);
    }

    public boolean hasNodeRendering() {
        return true;
    }

    public void paint(RenderGraphics rg) {
        this.checkLayout();
        if (this.canRenderState != 0) {
            return;
        }
        ((Text)this.proxied).paintRendered(rg, this, this.txf, this.firstChunk);
    }

    void checkLayout() {
        if (this.firstChunk == null) {
            GlyphLayout cur = this.firstChunk = ((Text)this.proxied).layoutText(this);
            while (cur.nextSibling != null) {
                cur = cur.nextSibling;
            }
            this.lastChunk = cur;
        }
    }

    protected void setProxied(ElementNode newProxied) {
        if (newProxied != null && !(newProxied instanceof Text)) {
            throw new IllegalArgumentException();
        }
        super.setProxied(newProxied);
        this.clearLayoutsQuiet();
    }

    public void clearLayouts() {
        this.modifyingNode();
        this.clearLayoutsQuiet();
        super.clearLayouts();
        this.modifiedNode();
    }

    public void clearLayoutsQuiet() {
        this.firstChunk = null;
        this.lastChunk = null;
    }

    public void setDisplay(boolean newDisplay) {
        super.setDisplay(newDisplay);
    }

    public void setVisibility(boolean newVisibility) {
        super.setVisibility(newVisibility);
    }

    public void setFill(PaintServer newFill) {
        this.fill = newFill;
    }

    public void setStroke(PaintServer newStroke) {
        this.stroke = newStroke;
    }

    public void setStrokeWidth(float newStrokeWidth) {
        this.strokeWidth = newStrokeWidth;
    }

    public void setStrokeLineJoin(int newStrokeLineJoin) {
        super.setStrokeLineJoin(newStrokeLineJoin);
    }

    public void setStrokeLineCap(int newStrokeLineCap) {
        super.setStrokeLineCap(newStrokeLineCap);
    }

    public void setStrokeMiterLimit(float newStrokeMiterLimit) {
        this.strokeMiterLimit = newStrokeMiterLimit;
    }

    public void setStrokeDashArray(float[] newStrokeDashArray) {
        this.strokeDashArray = newStrokeDashArray;
    }

    public void setStrokeDashOffset(float newStrokeDashOffset) {
        this.strokeDashOffset = newStrokeDashOffset;
    }

    public void setFillOpacity(float newFillOpacity) {
        super.setFillOpacity(newFillOpacity);
    }

    public void setStrokeOpacity(float newStrokeOpacity) {
        super.setStrokeOpacity(newStrokeOpacity);
    }

    public void setFontSize(float newFontSize) {
        this.fontSize = newFontSize;
        this.computeCanRenderFontSizeBit(newFontSize);
    }

    public void setFontFamily(String[] newFontFamily) {
        this.fontFamily = newFontFamily;
        this.clearLayoutsQuiet();
    }

    public void setTextAnchor(int newTextAnchor) {
        super.setTextAnchor(newTextAnchor);
    }

    public void setFontWeight(int newFontWeight) {
        super.setFontWeight(newFontWeight);
        this.clearLayoutsQuiet();
    }

    public void setFontStyle(int newFontStyle) {
        super.setFontStyle(newFontStyle);
        this.clearLayoutsQuiet();
    }
}

