/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.system.shortcut;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.installer.utils.system.shortcut.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileShortcut
extends Shortcut {
    private File target;
    private boolean modifyPath;
    private List<String> arguments;

    public FileShortcut(String name, File target) {
        super(name);
        this.setTarget(target);
        this.setArguments(new ArrayList<String>());
    }

    public boolean canModifyPath() {
        return this.modifyPath;
    }

    public void setModifyPath(boolean modifyPath) {
        this.modifyPath = modifyPath;
    }

    @Override
    public String getTargetPath() {
        return this.target.getPath();
    }

    public File getTarget() {
        return this.target;
    }

    public void setTarget(File target) {
        this.target = target;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public String getArgumentsString() {
        if (this.arguments.size() != 0) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.arguments.size(); ++i) {
                builder.append(this.arguments.get(i));
                if (i == this.arguments.size() - 1) continue;
                builder.append(" ");
            }
            return builder.toString();
        }
        return null;
    }

    public void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }

    public void addArgument(String argument) {
        this.arguments.add(argument);
    }

    public void removeArgument(String argument) {
        this.arguments.remove(argument);
    }

    @Deprecated
    public File getExecutable() {
        return this.getTarget();
    }

    @Deprecated
    public String getExecutablePath() {
        return this.getTargetPath();
    }

    @Deprecated
    public void setExecutable(File executable) {
        this.setTarget(executable);
    }

    @Deprecated
    public boolean canModifyExecutablePath() {
        return this.canModifyPath();
    }

    @Deprecated
    public void setModifyExecutablePath(boolean modifyExecutablePath) {
        this.setModifyPath(modifyExecutablePath);
    }
}

