/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.editor.hints;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.mobility.antext.preprocessor.PPBlockInfo;
import org.netbeans.mobility.antext.preprocessor.PPLine;
import org.netbeans.mobility.antext.preprocessor.PPToken;
import org.netbeans.modules.mobility.editor.actions.RecommentAction;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.ErrorManager;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

public class ReplaceOldSyntaxHint
implements Fix {
    protected final Document doc;
    protected final List<PPLine> lineList;
    protected PPBlockInfo block;

    public ReplaceOldSyntaxHint(Document doc, List<PPLine> lineList, PPBlockInfo block) {
        this.doc = doc;
        this.lineList = lineList;
        this.block = block;
    }

    protected boolean isNegative(List<PPToken> tokens) {
        return tokens.size() > 1 && tokens.get(1).getType() == 289;
    }

    protected List<String> extractAbilities(List<PPToken> tokens) {
        ArrayList<String> abilities = new ArrayList<String>();
        for (PPToken tok : tokens) {
            if (tok.getType() != 279) continue;
            abilities.add(tok.getText());
        }
        return abilities;
    }

    public synchronized ChangeInfo implement() {
        NbDocument.runAtomic((StyledDocument)((StyledDocument)this.doc), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    PPLine startLine = ReplaceOldSyntaxHint.this.lineList.get(ReplaceOldSyntaxHint.this.block.getStartLine() - 1);
                    List tokens = startLine.getTokens();
                    boolean negative = ReplaceOldSyntaxHint.this.isNegative(tokens);
                    List<String> abilities = ReplaceOldSyntaxHint.this.extractAbilities(tokens);
                    PPBlockInfo elseBlock = ReplaceOldSyntaxHint.this.findContraryBlock(negative, abilities);
                    if (elseBlock != null && elseBlock.getStartLine() < ReplaceOldSyntaxHint.this.block.getStartLine()) {
                        PPBlockInfo x = elseBlock;
                        elseBlock = ReplaceOldSyntaxHint.this.block;
                        ReplaceOldSyntaxHint.this.block = x;
                        negative ^= true;
                    }
                    if (elseBlock != null) {
                        ReplaceOldSyntaxHint.this.doc.insertString(ReplaceOldSyntaxHint.this.removeLine(ReplaceOldSyntaxHint.this.doc, elseBlock.getEndLine()), "//#endif", null);
                        ReplaceOldSyntaxHint.this.doc.insertString(ReplaceOldSyntaxHint.this.removeLine(ReplaceOldSyntaxHint.this.doc, elseBlock.getStartLine()), "//#else", null);
                        ReplaceOldSyntaxHint.this.doc.remove(ReplaceOldSyntaxHint.this.removeLine(ReplaceOldSyntaxHint.this.doc, ReplaceOldSyntaxHint.this.block.getEndLine()), 1);
                    } else {
                        ReplaceOldSyntaxHint.this.doc.insertString(ReplaceOldSyntaxHint.this.removeLine(ReplaceOldSyntaxHint.this.doc, ReplaceOldSyntaxHint.this.block.getEndLine()), "//#endif", null);
                    }
                    ReplaceOldSyntaxHint.this.doc.insertString(ReplaceOldSyntaxHint.this.removeLine(ReplaceOldSyntaxHint.this.doc, ReplaceOldSyntaxHint.this.block.getStartLine()), "//#if " + ReplaceOldSyntaxHint.this.constructCondition(negative, abilities), null);
                }
                catch (BadLocationException ble) {
                    ErrorManager.getDefault().notify((Throwable)ble);
                }
                RecommentAction.actionPerformed(ReplaceOldSyntaxHint.this.doc);
            }
        });
        return null;
    }

    protected String constructCondition(boolean negative, List<String> abilities) {
        StringBuffer sb = new StringBuffer();
        for (String str : abilities) {
            if (sb.length() > 0) {
                sb.append(" || ");
            }
            sb.append(str);
        }
        return negative ? "!(" + sb.toString() + ")" : sb.toString();
    }

    protected int removeLine(Document doc, int line) throws BadLocationException {
        int i = Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)doc), (int)(line - 1));
        doc.remove(i, Utilities.getRowEnd((BaseDocument)((BaseDocument)doc), (int)i) - i);
        return i;
    }

    private PPBlockInfo checkContraryBlock(PPBlockInfo b, boolean negative, List<String> abilities) {
        List<String> abs;
        PPLine startLine;
        List tokens;
        while (b != null && b.getType() != 13) {
            b = b.getParent();
        }
        if (b != null && b.getType() == 13 && negative != this.isNegative(tokens = (startLine = this.lineList.get(b.getStartLine() - 1)).getTokens()) && (abs = this.extractAbilities(tokens)).size() == abilities.size() && abs.containsAll(abilities)) {
            return b;
        }
        return null;
    }

    protected PPBlockInfo findContraryBlock(boolean negative, List<String> abilities) {
        PPBlockInfo b;
        if (this.block.getStartLine() > 1 && (b = this.checkContraryBlock(this.lineList.get(this.block.getStartLine() - 2).getBlock(), negative, abilities)) != null) {
            return b;
        }
        if (this.block.getEndLine() < this.lineList.size() && (b = this.checkContraryBlock(this.lineList.get(this.block.getEndLine()).getBlock(), negative, abilities)) != null) {
            return b;
        }
        return null;
    }

    public String getText() {
        return NbBundle.getMessage(ReplaceOldSyntaxHint.class, (String)"HintReplaceOldSyntax");
    }
}

