/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.actions.scm;

import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractAction;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Scm;
import org.netbeans.modules.maven.actions.ActionsUtil;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class OpenScmURLAction
extends AbstractAction {
    private Artifact artifact;
    private List<ArtifactRepository> repos;

    public OpenScmURLAction(Artifact artifact, List<ArtifactRepository> repos) {
        this.putValue("Name", NbBundle.getMessage(OpenScmURLAction.class, (String)"LBL_OpenURL"));
        this.artifact = artifact;
        this.repos = repos;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                Scm scm = ActionsUtil.readMavenProject(OpenScmURLAction.this.artifact, OpenScmURLAction.this.repos).getScm();
                if (scm != null && scm.getUrl() != null) {
                    try {
                        HtmlBrowser.URLDisplayer.getDefault().showURL(new URL(scm.getUrl()));
                    }
                    catch (MalformedURLException ex) {
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(OpenScmURLAction.class, (String)"ERR_Url", (Object)scm.getUrl()), 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    }
                }
            }
        });
    }
}

