/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import org.netbeans.lib.editor.util.PriorityMutex;
import org.netbeans.lib.editor.util.swing.DocumentListenerPriority;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib2.view.DocumentView;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.EditorViewFactory;
import org.netbeans.modules.editor.lib2.view.EditorViewFactoryEvent;
import org.netbeans.modules.editor.lib2.view.EditorViewFactoryListener;
import org.netbeans.modules.editor.lib2.view.ParagraphView;
import org.netbeans.modules.editor.lib2.view.TextLayoutView;
import org.netbeans.modules.editor.lib2.view.ViewBuilder;

public final class ViewUpdates
implements DocumentListener {
    private static final Logger LOG = Logger.getLogger(ViewUpdates.class.getName());
    private final DocumentView documentView;
    private EditorViewFactory[] viewFactories;
    private FactoriesListener factoriesListener;
    private DocumentListener incomingModificationListener;
    int rebuildStartOffset;
    int rebuildEndOffset;

    public ViewUpdates(DocumentView documentView) {
        this.documentView = documentView;
        this.factoriesListener = new FactoriesListener();
        this.incomingModificationListener = new IncomingModificationListener();
        Document doc = documentView.getDocument();
        DocumentUtilities.addDocumentListener((Document)doc, (DocumentListener)this.incomingModificationListener, (DocumentListenerPriority)DocumentListenerPriority.FIRST);
        DocumentUtilities.addDocumentListener((Document)doc, (DocumentListener)this, (DocumentListenerPriority)DocumentListenerPriority.VIEW);
    }

    private void reinitFactories() {
        if (this.viewFactories != null) {
            for (int i = 0; i < this.viewFactories.length; ++i) {
                this.viewFactories[i].removeEditorViewFactoryListener(this.factoriesListener);
            }
            this.viewFactories = null;
        }
        this.initFactories();
    }

    private void initFactories() {
        assert (this.viewFactories == null);
        JTextComponent component = this.documentView.getTextComponent();
        assert (component != null) : "Null component; doc=" + this.documentView.getDocument();
        List<EditorViewFactory.Factory> factoryFactories = EditorViewFactory.factories();
        this.viewFactories = new EditorViewFactory[factoryFactories.size()];
        for (int i = 0; i < factoryFactories.size(); ++i) {
            this.viewFactories[i] = factoryFactories.get(i).createEditorViewFactory(component);
            this.viewFactories[i].addEditorViewFactoryListener(this.factoriesListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reinitViews() {
        Document doc = this.documentView.getDocument();
        this.checkFactoriesComponentInited();
        ViewBuilder viewBuilder = new ViewBuilder(null, this.documentView, 0, this.viewFactories, 0, doc.getLength() + 1, doc.getLength() + 1, 0, false);
        try {
            viewBuilder.createViews();
            viewBuilder.repaintAndReplaceViews();
        }
        finally {
            viewBuilder.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initChildren(int startIndex, int endIndex, int lazyChildrenBatch) {
        int endIndexBatch = Math.min(Math.max(endIndex, startIndex + lazyChildrenBatch), this.documentView.getViewCount());
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Lazy-children init: [" + startIndex + "," + endIndex + "=>" + endIndexBatch + "] batch=" + lazyChildrenBatch + "\n");
        }
        assert (endIndexBatch > startIndex) : "endIndexBatch=" + endIndexBatch + " > startIndex=" + startIndex;
        ParagraphView startChild = (ParagraphView)this.documentView.getEditorView(startIndex);
        ParagraphView lastChild = (ParagraphView)this.documentView.getEditorView(endIndexBatch - 1);
        int docTextLength = this.documentView.getDocument().getLength() + 1;
        int startOffset = startChild.getStartOffset();
        int endOffset = lastChild.getEndOffset();
        assert (startOffset <= endOffset) : "startOffset=" + startOffset + " > endOffset=" + endOffset + "\n" + this.documentView.toStringDetail();
        assert (endOffset <= docTextLength) : "endOffset=" + endOffset + " > docTextLength=" + docTextLength + "\n" + this.documentView.toStringDetail();
        ViewBuilder viewBuilder = new ViewBuilder(null, this.documentView, startIndex, this.viewFactories, startOffset, endOffset, endOffset, 0, true);
        try {
            viewBuilder.createViews();
            viewBuilder.repaintAndReplaceViews();
        }
        finally {
            viewBuilder.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertUpdate(DocumentEvent evt) {
        PriorityMutex mutex = this.documentView.getMutex();
        if (mutex != null) {
            mutex.lock();
            this.documentView.checkDocumentLocked();
            try {
                ParagraphView paragraphView;
                int paragraphViewIndex;
                if (!this.documentView.isUpdatable()) {
                    return;
                }
                this.checkFactoriesComponentInited();
                for (int i = 0; i < this.viewFactories.length; ++i) {
                    EditorViewFactory editorViewFactory = this.viewFactories[i];
                    editorViewFactory.insertUpdate(evt);
                }
                int rStartOffset = this.rebuildStartOffset;
                int rEndOffset = this.rebuildEndOffset;
                boolean rebuildNecessary = this.isRebuildNecessary();
                int insertOffset = evt.getOffset();
                int insertLength = evt.getLength();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("\nDOCUMENT-INSERT-evt: offset=" + insertOffset + ", length=" + insertLength + ", docLen=" + evt.getDocument().getLength() + '\n');
                }
                rStartOffset = Math.min(rStartOffset, insertOffset);
                rEndOffset = Math.max(rEndOffset, insertOffset + insertLength);
                Document doc = evt.getDocument();
                DocumentEvent.ElementChange lineElementChange = evt.getChange(doc.getDefaultRootElement());
                if (lineElementChange != null) {
                    Element[] addedLines;
                    Element[] removedLines = lineElementChange.getChildrenRemoved();
                    if (removedLines.length > 0) {
                        rebuildNecessary = true;
                        int firstRemovedLineStartOffset = removedLines[0].getStartOffset();
                        int lastRemovedLineEndOffset = removedLines[removedLines.length - 1].getEndOffset();
                        assert (insertOffset >= firstRemovedLineStartOffset && insertOffset <= lastRemovedLineEndOffset);
                        if (firstRemovedLineStartOffset < rStartOffset) {
                            rStartOffset = firstRemovedLineStartOffset;
                        }
                        if (lastRemovedLineEndOffset > rEndOffset) {
                            rEndOffset = lastRemovedLineEndOffset;
                        }
                    }
                    if ((addedLines = lineElementChange.getChildrenAdded()).length > 0) {
                        rebuildNecessary = true;
                        int firstAddedLineStartOffset = addedLines[0].getStartOffset();
                        int lastAddedLineEndOffset = addedLines[addedLines.length - 1].getEndOffset();
                        if (firstAddedLineStartOffset < rStartOffset) {
                            rStartOffset = firstAddedLineStartOffset;
                        }
                        if (lastAddedLineEndOffset > rEndOffset) {
                            rEndOffset = lastAddedLineEndOffset;
                        }
                    }
                    rebuildNecessary |= addedLines.length > 0;
                }
                if (insertOffset == 0) {
                    paragraphViewIndex = 0;
                    paragraphView = null;
                    rebuildNecessary = true;
                } else {
                    paragraphViewIndex = this.documentView.getViewIndex(rStartOffset);
                    assert (paragraphViewIndex >= 0) : "paragraphViewIndex=" + paragraphViewIndex + ", docLen=" + evt.getDocument().getLength();
                    paragraphView = (ParagraphView)this.documentView.getEditorView(paragraphViewIndex);
                }
                boolean createLocalViews = true;
                if (paragraphView != null) {
                    if (paragraphView.children == null) {
                        rebuildNecessary = true;
                        int paragraphStartOffset = paragraphView.getStartOffset();
                        assert (paragraphStartOffset <= rStartOffset) : "paragraphStartOffset=" + paragraphStartOffset + " > rStartOffset=" + rStartOffset;
                        rStartOffset = paragraphStartOffset;
                        rEndOffset = Math.max(rEndOffset, paragraphStartOffset + paragraphView.getLength());
                        paragraphView = null;
                        createLocalViews = false;
                    }
                    if (!rebuildNecessary) {
                        int childViewIndex = paragraphView.getViewIndex(rEndOffset);
                        Object childView = paragraphView.getEditorView(childViewIndex);
                        if (insertOffset == ((View)childView).getStartOffset()) {
                            if (--childViewIndex < 0) {
                                rebuildNecessary = true;
                            } else {
                                childView = paragraphView.getEditorView(childViewIndex);
                            }
                        }
                        if (!rebuildNecessary) {
                            if (childView instanceof TextLayoutView) {
                                this.documentView.getTextLayoutCache().put(paragraphView, (TextLayoutView)childView, null);
                            }
                            boolean bl = rebuildNecessary = !((EditorView)childView).setLength(((EditorView)childView).getLength() + insertLength);
                            if (!rebuildNecessary) {
                                paragraphView.setLength(paragraphView.getLength() + insertLength);
                                double visualDelta = (double)((View)childView).getPreferredSpan(paragraphView.getMajorAxis()) - paragraphView.getViewMajorAxisSpan(childViewIndex);
                                paragraphView.fixSpans(childViewIndex + 1, insertLength, visualDelta);
                                this.documentView.checkIntegrity();
                            }
                        }
                    }
                }
                if (rebuildNecessary) {
                    ViewBuilder viewBuilder = new ViewBuilder(paragraphView, this.documentView, paragraphViewIndex, this.viewFactories, rStartOffset, rEndOffset, insertOffset + insertLength, insertLength, true);
                    try {
                        viewBuilder.createViews();
                        viewBuilder.repaintAndReplaceViews();
                    }
                    finally {
                        viewBuilder.finish();
                    }
                }
                this.resetRebuildInfo();
            }
            finally {
                this.documentView.setIncomingModification(false);
                mutex.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUpdate(DocumentEvent evt) {
        PriorityMutex mutex = this.documentView.getMutex();
        if (mutex != null) {
            mutex.lock();
            this.documentView.checkDocumentLocked();
            try {
                if (!this.documentView.isUpdatable()) {
                    return;
                }
                this.checkFactoriesComponentInited();
                for (int i = 0; i < this.viewFactories.length; ++i) {
                    EditorViewFactory editorViewFactory = this.viewFactories[i];
                    editorViewFactory.removeUpdate(evt);
                }
                int rStartOffset = this.rebuildStartOffset;
                int rEndOffset = this.rebuildEndOffset;
                boolean rebuildNecessary = this.isRebuildNecessary();
                int removeOffset = evt.getOffset();
                int removeLength = evt.getLength();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("\nDOCUMENT-REMOVE-evt: offset=" + removeOffset + ", length=" + removeLength + ", docLen=" + evt.getDocument().getLength() + '\n');
                }
                rStartOffset = Math.min(rStartOffset, removeOffset);
                rEndOffset = Math.max(rEndOffset, removeOffset + removeLength);
                Document doc = evt.getDocument();
                DocumentEvent.ElementChange lineElementChange = evt.getChange(doc.getDefaultRootElement());
                Element[] removedLines = null;
                if (lineElementChange != null) {
                    Element[] addedLines;
                    removedLines = lineElementChange.getChildrenRemoved();
                    if (removedLines.length > 0) {
                        rebuildNecessary = true;
                        int firstRemovedLineStartOffset = removedLines[0].getStartOffset();
                        int lastRemovedLineEndOffset = removedLines[removedLines.length - 1].getEndOffset();
                        if (firstRemovedLineStartOffset < rStartOffset) {
                            rStartOffset = firstRemovedLineStartOffset;
                        }
                        if (lastRemovedLineEndOffset > rEndOffset) {
                            rEndOffset = lastRemovedLineEndOffset;
                        }
                    }
                    if ((addedLines = lineElementChange.getChildrenAdded()).length > 0) {
                        rebuildNecessary = true;
                        int firstAddedLineStartOffset = addedLines[0].getStartOffset();
                        int lastAddedLineEndOffset = addedLines[addedLines.length - 1].getEndOffset();
                        if (firstAddedLineStartOffset < rStartOffset) {
                            rStartOffset = firstAddedLineStartOffset;
                        }
                        if (lastAddedLineEndOffset > rEndOffset) {
                            rEndOffset = lastAddedLineEndOffset;
                        }
                    }
                    rebuildNecessary |= addedLines.length > 0;
                }
                int paragraphViewIndex = this.documentView.getViewIndexFirst(rStartOffset);
                assert (paragraphViewIndex >= 0) : "Line view index is " + paragraphViewIndex;
                ParagraphView paragraphView = (ParagraphView)this.documentView.getEditorView(paragraphViewIndex);
                boolean createLocalViews = true;
                if (paragraphView.children == null) {
                    rebuildNecessary = true;
                    int paragraphStartOffset = paragraphView.getStartOffset();
                    assert (paragraphStartOffset <= rStartOffset) : "paragraphStartOffset=" + paragraphStartOffset + " > rStartOffset=" + rStartOffset;
                    rStartOffset = paragraphStartOffset;
                    rEndOffset = Math.max(rEndOffset, paragraphStartOffset + paragraphView.getLength());
                    paragraphView = null;
                    createLocalViews = false;
                }
                if (!rebuildNecessary) {
                    int childViewIndex = paragraphView.getViewIndex(rEndOffset);
                    Object childView = paragraphView.getEditorView(childViewIndex);
                    int childStartOffset = ((View)childView).getStartOffset();
                    int childEndOffset = ((View)childView).getEndOffset();
                    boolean localEdit = removeOffset == childStartOffset && removeOffset + removeLength < childEndOffset || removeOffset > childStartOffset && removeOffset + removeLength <= childEndOffset;
                    boolean bl = rebuildNecessary = !localEdit;
                    if (!rebuildNecessary) {
                        if (childView instanceof TextLayoutView) {
                            this.documentView.getTextLayoutCache().put(paragraphView, (TextLayoutView)childView, null);
                        }
                        boolean bl2 = rebuildNecessary = !((EditorView)childView).setLength(((EditorView)childView).getLength() - removeLength);
                        if (!rebuildNecessary) {
                            paragraphView.setLength(paragraphView.getLength() - removeLength);
                            double visualDelta = (double)((View)childView).getPreferredSpan(paragraphView.getMajorAxis()) - paragraphView.getViewMajorAxisSpan(childViewIndex);
                            paragraphView.fixSpans(childViewIndex + 1, -removeLength, visualDelta);
                            this.documentView.checkIntegrity();
                        }
                    }
                }
                if (rebuildNecessary) {
                    ViewBuilder viewBuilder = new ViewBuilder(paragraphView, this.documentView, paragraphViewIndex, this.viewFactories, rStartOffset, rEndOffset, removeOffset + removeLength, -removeLength, createLocalViews);
                    try {
                        viewBuilder.createViews();
                        viewBuilder.repaintAndReplaceViews();
                    }
                    finally {
                        viewBuilder.finish();
                    }
                }
                this.resetRebuildInfo();
            }
            finally {
                this.documentView.setIncomingModification(false);
                mutex.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changedUpdate(DocumentEvent evt) {
        PriorityMutex mutex = this.documentView.getMutex();
        if (mutex != null) {
            mutex.lock();
            this.documentView.checkDocumentLocked();
            try {
                if (!this.documentView.isUpdatable()) {
                    return;
                }
                this.checkFactoriesComponentInited();
                for (int i = 0; i < this.viewFactories.length; ++i) {
                    EditorViewFactory editorViewFactory = this.viewFactories[i];
                    editorViewFactory.changedUpdate(evt);
                }
                this.resetRebuildInfo();
                this.documentView.checkIntegrity();
            }
            finally {
                this.documentView.setIncomingModification(false);
                mutex.unlock();
            }
        }
    }

    boolean isRebuildNecessary() {
        return this.rebuildStartOffset != Integer.MAX_VALUE;
    }

    void resetRebuildInfo() {
        this.rebuildStartOffset = Integer.MAX_VALUE;
        this.rebuildEndOffset = Integer.MIN_VALUE;
    }

    void extendRebuildInfo(int startOffset, int endOffset) {
        if (startOffset == Integer.MAX_VALUE) {
            this.rebuildStartOffset = startOffset;
            this.rebuildEndOffset = endOffset;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("ViewUpdates.Change set to <" + this.rebuildStartOffset + "," + this.rebuildEndOffset + ">\n");
            }
        } else {
            boolean change = false;
            if (startOffset < this.rebuildStartOffset) {
                this.rebuildStartOffset = startOffset;
                change = true;
            }
            if (endOffset > this.rebuildEndOffset) {
                this.rebuildEndOffset = endOffset;
                change = true;
            }
            if (change && LOG.isLoggable(Level.FINE)) {
                LOG.fine("ViewUpdates.Change extended to <" + this.rebuildStartOffset + "," + this.rebuildEndOffset + ">\n");
            }
        }
    }

    private void checkFactoriesComponentInited() {
        if (this.viewFactories == null) {
            this.initFactories();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkRebuild() {
        block11: {
            PriorityMutex mutex = this.documentView.getMutex();
            if (mutex != null) {
                mutex.lock();
                try {
                    int endParagraphIndex;
                    boolean createLocalViews;
                    this.documentView.checkDocumentLocked();
                    if (!this.documentView.isActive() || !this.isRebuildNecessary()) break block11;
                    int rStartOffset = this.rebuildStartOffset;
                    int rEndOffset = this.rebuildEndOffset;
                    this.documentView.checkIntegrity();
                    int paragraphViewIndex = this.documentView.getViewIndexFirst(rStartOffset);
                    assert (paragraphViewIndex >= 0) : "Paragraph view index is " + paragraphViewIndex;
                    ParagraphView paragraphView = (ParagraphView)this.documentView.getEditorView(paragraphViewIndex);
                    boolean bl = createLocalViews = paragraphView.children != null;
                    if (createLocalViews && (endParagraphIndex = paragraphViewIndex + 3) < this.documentView.getViewCount() && ((ParagraphView)this.documentView.getEditorView(endParagraphIndex)).getStartOffset() < this.rebuildEndOffset) {
                        createLocalViews = false;
                    }
                    if (!createLocalViews) {
                        int paragraphStartOffset = paragraphView.getStartOffset();
                        assert (paragraphStartOffset <= rStartOffset) : "paragraphStartOffset=" + paragraphStartOffset + " > rStartOffset=" + rStartOffset;
                        rStartOffset = paragraphView.getStartOffset();
                        rEndOffset = Math.max(rEndOffset, paragraphStartOffset + paragraphView.getLength());
                        paragraphView = null;
                    }
                    ViewBuilder viewBuilder = new ViewBuilder(paragraphView, this.documentView, paragraphViewIndex, this.viewFactories, rStartOffset, rEndOffset, rEndOffset, 0, createLocalViews);
                    try {
                        viewBuilder.createViews();
                        viewBuilder.repaintAndReplaceViews();
                    }
                    finally {
                        viewBuilder.finish();
                    }
                    this.resetRebuildInfo();
                }
                finally {
                    mutex.unlock();
                }
            }
        }
    }

    private final class IncomingModificationListener
    implements DocumentListener {
        private IncomingModificationListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ViewUpdates.this.documentView.setIncomingModification(true);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ViewUpdates.this.documentView.setIncomingModification(true);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ViewUpdates.this.documentView.setIncomingModification(true);
        }
    }

    private final class FactoriesListener
    implements EditorViewFactoryListener {
        private FactoriesListener() {
        }

        @Override
        public void viewFactoryChanged(EditorViewFactoryEvent evt) {
            List<EditorViewFactory.Change> changes = evt.getChanges();
            for (EditorViewFactory.Change change : changes) {
                if (change.getStartOffset() < ViewUpdates.this.rebuildStartOffset) {
                    ViewUpdates.this.rebuildStartOffset = change.getStartOffset();
                }
                if (change.getEndOffset() > ViewUpdates.this.rebuildEndOffset) {
                    ViewUpdates.this.rebuildEndOffset = change.getEndOffset();
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("ViewUpdates.Change <" + change.getStartOffset() + "," + change.getEndOffset() + ">");
                }
                ViewUpdates.this.checkRebuild();
            }
        }
    }
}

