/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen.display;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;

public class GaugeDisplayPresenterElement {
    private static final int BAR_WIDTH = 8;
    private static final int BAR_GAP = 5;
    private static final BasicStroke GAUGE_STROKE = new BasicStroke(1.0f, 2, 2, 0.0f, new float[]{3.0f, 2.0f}, 0.0f);
    private JPanel panel;
    private Dimension size;
    private int value;
    private int maxValue;
    private boolean interactive;

    public void setPanel(JPanel panel) {
        if (panel == null) {
            throw new IllegalArgumentException();
        }
        this.panel = panel;
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(Dimension size) {
        if (size == null) {
            throw new IllegalArgumentException();
        }
        this.size = size;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    public void paintGauge(Graphics g) {
        if (this.panel == null) {
            throw new IllegalArgumentException();
        }
        this.size = this.panel.getSize();
        if (this.size == null) {
            return;
        }
        int gaugeWidth = this.size.width;
        int gaugeHeight = this.size.height - 5;
        int barsCount = gaugeWidth / 13 + 1;
        int selectionBarCount = 0;
        if (this.value > 0) {
            selectionBarCount = barsCount * this.value / this.maxValue;
        }
        int px = 0;
        Graphics2D g2D = (Graphics2D)g;
        g2D.setColor(Color.GRAY);
        g2D.setStroke(GAUGE_STROKE);
        float barHeight = gaugeHeight;
        float heightStep = 0.0f;
        if (this.interactive) {
            barHeight = 1.0f;
            heightStep = (float)gaugeHeight / (float)barsCount;
        }
        for (int i = 0; i < barsCount; ++i) {
            if (i < selectionBarCount) {
                g2D.fillRect(px, (int)((float)gaugeHeight - barHeight), 8, (int)barHeight);
            } else {
                g2D.drawRect(px, (int)((float)gaugeHeight - barHeight), 8, (int)barHeight);
            }
            px += 13;
            if (!this.interactive || !(barHeight < (float)gaugeHeight) || !((barHeight += heightStep) > (float)gaugeHeight)) continue;
            barHeight = gaugeHeight;
        }
    }
}

