/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collections;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.propertyeditors.PropertyEditorNumber;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class PropertyEditorGaugeMaxValue
extends PropertyEditorUserCode
implements PropertyEditorElement {
    private static final String INDEFINITE_TEXT = NbBundle.getMessage(PropertyEditorGaugeMaxValue.class, (String)"LBL_MAX_VALUE_INDEFINITE_TXT");
    private static final String INDEFINITE_NUM_TEXT = String.valueOf(-1);
    private CustomEditor customEditor;
    private JRadioButton radioButton;

    private PropertyEditorGaugeMaxValue() {
        super(NbBundle.getMessage(PropertyEditorGaugeMaxValue.class, (String)"LBL_GAUGE_MAX_VALUE_UCLABEL"));
    }

    public static final PropertyEditorGaugeMaxValue createInstance() {
        return new PropertyEditorGaugeMaxValue();
    }

    @Override
    public void cleanUp(DesignComponent component) {
        super.cleanUp(component);
        if (this.customEditor != null) {
            this.customEditor.cleanUp();
            this.customEditor = null;
        }
        this.radioButton = null;
    }

    private void initComponents() {
        this.radioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)NbBundle.getMessage(PropertyEditorGaugeMaxValue.class, (String)"LBL_GAUGE_MAX_VALUE_STR"));
        this.customEditor = new CustomEditor();
    }

    @Override
    public JComponent getCustomEditorComponent() {
        return this.customEditor;
    }

    @Override
    public Component getCustomEditor() {
        if (this.customEditor == null) {
            this.initComponents();
            this.initElements(Collections.singleton(this));
        }
        return super.getCustomEditor();
    }

    @Override
    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    @Override
    public boolean isInitiallySelected() {
        return true;
    }

    @Override
    public boolean isVerticallyResizable() {
        return false;
    }

    @Override
    public String getAsText() {
        String superText = super.getAsText();
        if (superText != null) {
            return superText;
        }
        PropertyValue value = (PropertyValue)super.getValue();
        if (value == null) {
            return INDEFINITE_TEXT;
        }
        int intValue = MidpTypes.getInteger(value);
        if (intValue == -1) {
            return INDEFINITE_TEXT;
        }
        return String.valueOf(intValue);
    }

    @Override
    public void setTextForPropertyValue(String text) {
        this.saveValue(text);
    }

    @Override
    public String getTextForPropertyValue() {
        return null;
    }

    @Override
    public void updateState(PropertyValue value) {
        if (this.isCurrentValueANull() || value == null) {
            this.customEditor.unsetForever(true);
        } else if (MidpTypes.getInteger(value) == -1) {
            this.customEditor.setForever(true);
        } else {
            this.customEditor.unsetForever(true);
            this.customEditor.setText(String.valueOf(value.getPrimitiveValue()));
        }
        this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
    }

    private void saveValue(String text) {
        if (text.length() <= 0) {
            return;
        }
        if (INDEFINITE_TEXT.equals(text) || INDEFINITE_NUM_TEXT.equals(text)) {
            if (this.component != null && this.component.get() != null) {
                final DesignComponent _component = (DesignComponent)this.component.get();
                _component.getDocument().getTransactionManager().writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        _component.writeProperty("value", MidpTypes.createIntegerValue(0));
                    }
                });
            }
            super.setValue((Object)MidpTypes.createIntegerValue(-1));
        } else {
            int intValue = 0;
            try {
                text = text.replaceAll("[^0-9\\-]+", "");
                intValue = Integer.parseInt(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            super.setValue((Object)MidpTypes.createIntegerValue(intValue));
        }
    }

    @Override
    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.radioButton.isSelected()) {
            this.saveValue(this.customEditor.getText());
        }
    }

    @Override
    public Boolean canEditAsText() {
        if (!this.isCurrentValueAUserCodeType()) {
            PropertyValue value = (PropertyValue)super.getValue();
            if (value == null) {
                return false;
            }
            int intValue = MidpTypes.getInteger(value);
            return intValue != -1;
        }
        return false;
    }

    private class CustomEditor
    extends JPanel
    implements ActionListener,
    DocumentListener,
    FocusListener {
        private JTextField textField;
        private JCheckBox foreverCheckBox;

        public CustomEditor() {
            PropertyEditorGaugeMaxValue.this.radioButton.addFocusListener(this);
            this.initComponents();
        }

        void cleanUp() {
            PropertyEditorGaugeMaxValue.this.radioButton.removeActionListener(this);
            this.textField = null;
            this.foreverCheckBox = null;
            this.removeAll();
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            this.textField = new JTextField();
            this.textField.getDocument().addDocumentListener(this);
            this.textField.addFocusListener(this);
            this.textField.setPreferredSize(new Dimension(100, this.textField.getPreferredSize().height));
            this.add((Component)this.textField, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.foreverCheckBox = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.foreverCheckBox, (String)NbBundle.getMessage(PropertyEditorGaugeMaxValue.class, (String)"LBL_MAX_VALUE_INDEFINITE"));
            this.foreverCheckBox.addActionListener(this);
            this.foreverCheckBox.addFocusListener(this);
            this.add((Component)this.foreverCheckBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
            this.add((Component)new JPanel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        public void setText(String text) {
            this.textField.setText(text);
        }

        public String getText() {
            return this.textField.getText();
        }

        public void setForever(boolean changeCheckBox) {
            this.setText(INDEFINITE_NUM_TEXT);
            this.textField.setEditable(false);
            if (changeCheckBox) {
                this.foreverCheckBox.setSelected(true);
            }
        }

        public void unsetForever(boolean changeCheckBox) {
            this.setText(null);
            this.textField.setEditable(true);
            if (changeCheckBox) {
                this.foreverCheckBox.setSelected(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (this.foreverCheckBox.isSelected()) {
                this.setForever(false);
            } else {
                this.unsetForever(false);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            if (this.textField.hasFocus()) {
                PropertyEditorGaugeMaxValue.this.radioButton.setSelected(true);
                this.checkNumberStatus();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            if (this.textField.hasFocus()) {
                PropertyEditorGaugeMaxValue.this.radioButton.setSelected(true);
                this.checkNumberStatus();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
        }

        private void checkNumberStatus() {
            if (!Pattern.matches("[\\d\\-]+", this.textField.getText())) {
                PropertyEditorGaugeMaxValue.this.displayWarning(PropertyEditorNumber.NON_DIGITS_TEXT);
            } else {
                PropertyEditorGaugeMaxValue.this.clearErrorStatus();
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getSource() == PropertyEditorGaugeMaxValue.this.radioButton || e.getSource() == this.textField || e.getSource() == this.foreverCheckBox) {
                this.checkNumberStatus();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            PropertyEditorGaugeMaxValue.this.clearErrorStatus();
        }
    }
}

