/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components;

import java.awt.datatransfer.Transferable;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.AcceptPresenter;
import org.netbeans.modules.vmd.api.model.common.AcceptSuggestion;
import org.netbeans.modules.vmd.api.model.common.DesignComponentDataFlavorSupport;

public class MidpAcceptTrensferableKindPresenter
extends AcceptPresenter {
    protected Map<TypeID, String> typesMap = new HashMap<TypeID, String>();

    public MidpAcceptTrensferableKindPresenter() {
        super(AcceptPresenter.Kind.TRANSFERABLE);
    }

    public MidpAcceptTrensferableKindPresenter addType(TypeID typeID, String propertyName) {
        if (propertyName == null || typeID == null) {
            throw new IllegalArgumentException();
        }
        if (this.typesMap.containsKey(typeID)) {
            throw new IllegalArgumentException("TypeId : " + typeID + " is alredy registered in this presenter");
        }
        this.typesMap.put(typeID, propertyName);
        return this;
    }

    public boolean isAcceptable(Transferable transferable, AcceptSuggestion suggestion) {
        if (this.getComponent().getDocument().getSelectedComponents().size() > 1) {
            return false;
        }
        if (this.typesMap.values().isEmpty()) {
            throw new IllegalArgumentException("No types to check. Use addNewType method to add types to check");
        }
        if (!transferable.isDataFlavorSupported(DesignComponentDataFlavorSupport.DESIGN_COMPONENT_DATA_FLAVOR)) {
            return false;
        }
        DesignComponent component = DesignComponentDataFlavorSupport.getTransferableDesignComponent((Transferable)transferable);
        if (component == null) {
            return false;
        }
        return this.typesMap.containsKey(component.getType()) && this.typesMap.get(component.getType()) != null;
    }

    public ComponentProducer.Result accept(Transferable transferable, AcceptSuggestion suggestion) {
        DesignComponent component = DesignComponentDataFlavorSupport.getTransferableDesignComponent((Transferable)transferable);
        String propertyName = this.typesMap.get(component.getType());
        if (propertyName == null) {
            throw new IllegalStateException();
        }
        this.getComponent().writeProperty(propertyName, PropertyValue.createComponentReference((DesignComponent)component));
        return new ComponentProducer.Result(new DesignComponent[]{component});
    }
}

