/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.analyzer;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.vmd.api.analyzer.Analyzer;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.midp.analyzer.ResourcesAnalyzerPanel;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.categories.CommandsCategoryCD;
import org.netbeans.modules.vmd.midp.components.categories.ResourcesCategoryCD;
import org.openide.util.NbBundle;

public class ResourcesAnalyzer
implements Analyzer {
    public String getProjectType() {
        return "vmd-midp";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ResourcesAnalyzer.class, (String)"ResourcesAnalyzer.displayName");
    }

    public String getToolTip() {
        return NbBundle.getMessage(ResourcesAnalyzer.class, (String)"ResourcesAnalyzer.toolTip");
    }

    public Image getIcon() {
        return null;
    }

    public JComponent createVisualRepresentation() {
        return new ResourcesAnalyzerPanel();
    }

    public void update(JComponent visualRepresentation, final DesignDocument document) {
        if (visualRepresentation == null || document == null) {
            return;
        }
        final ResourcesAnalyzerPanel analyzerPanel = (ResourcesAnalyzerPanel)visualRepresentation;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                document.getTransactionManager().readAccess(new Runnable(){

                    @Override
                    public void run() {
                        ArrayList<DesignComponent> resources = new ArrayList<DesignComponent>();
                        DesignComponent rootComponent = document.getRootComponent();
                        if (rootComponent != null) {
                            DesignComponent resourcesCategory;
                            DesignComponent commandsCategory = MidpDocumentSupport.getCategoryComponent(document, CommandsCategoryCD.TYPEID);
                            if (commandsCategory != null) {
                                for (DesignComponent command : commandsCategory.getComponents()) {
                                    if (!MidpTypes.getBoolean(command.readProperty("ordinary"))) continue;
                                    resources.add(command);
                                }
                            }
                            if ((resourcesCategory = MidpDocumentSupport.getCategoryComponent(document, ResourcesCategoryCD.TYPEID)) != null) {
                                resources.addAll(resourcesCategory.getComponents());
                            }
                            ResourcesAnalyzer.this.filterResources(rootComponent, resources);
                        }
                        analyzerPanel.setUnusedResources(document, resources);
                    }
                });
            }
        });
    }

    private void filterResources(DesignComponent component, Collection<DesignComponent> resources) {
        for (DesignComponent child : component.getComponents()) {
            this.filterResources(child, resources);
        }
        ArrayList references = new ArrayList();
        for (PropertyDescriptor pd : component.getComponentDescriptor().getPropertyDescriptors()) {
            Debug.collectAllComponentReferences((PropertyValue)component.readProperty(pd.getName()), references);
            resources.removeAll(references);
            references.clear();
        }
    }
}

