/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.actions;

import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.api.model.presenters.actions.AddActionItem;
import org.netbeans.modules.vmd.api.model.presenters.actions.AddActionPresenter;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.openide.util.NbBundle;

abstract class UnusedCommandsAddActionPresenter
extends AddActionPresenter {
    public static final String DISPLAY_NAME_ADD = NbBundle.getMessage(UnusedCommandsAddActionPresenter.class, (String)"NAME_UnusedCommandsAddActionPresenter");
    private Integer order;
    private String displayName;
    private List<Action> newAddActions;

    public static Presenter createForDisplayable(String displayName, int order) {
        return new UnusedCommandsAddActionPresenter(displayName, order){
            private DesignComponent selectedCommandSource;

            @Override
            protected synchronized void insideActionPerformed(final DesignComponent unusedCommandComponent) {
                DesignDocument document = unusedCommandComponent.getDocument();
                document.getTransactionManager().writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        selectedCommandSource = MidpDocumentSupport.attachCommandToDisplayable(this.getComponent(), unusedCommandComponent);
                    }
                });
                UnusedCommandsAddActionPresenter.selectComponent(this.selectedCommandSource);
                this.selectedCommandSource = null;
            }
        };
    }

    public static Presenter createForItem(String displayName, int order) {
        return new UnusedCommandsAddActionPresenter(displayName, order){
            private DesignComponent selectedCommandSource;

            @Override
            protected synchronized void insideActionPerformed(final DesignComponent unusedCommandComponent) {
                DesignDocument document = unusedCommandComponent.getDocument();
                document.getTransactionManager().writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        selectedCommandSource = MidpDocumentSupport.attachCommandToItem(this.getComponent(), unusedCommandComponent);
                    }
                });
                UnusedCommandsAddActionPresenter.selectComponent(this.selectedCommandSource);
                this.selectedCommandSource = null;
            }
        };
    }

    private static void selectComponent(final DesignComponent selectedCommandSource) {
        final DesignDocument document = selectedCommandSource.getDocument();
        document.getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                document.setSelectedComponents(null, Collections.singleton(selectedCommandSource));
            }
        });
    }

    private UnusedCommandsAddActionPresenter(String displayName, int order) {
        this.order = order;
        this.displayName = displayName;
    }

    protected abstract void insideActionPerformed(DesignComponent var1);

    public String getName() {
        return this.displayName;
    }

    public Integer getOrder() {
        return this.order;
    }

    public AddActionItem[] getAddActionItems() {
        if (this.newAddActions == null) {
            this.newAddActions = new ArrayList<Action>();
        } else {
            this.newAddActions.clear();
        }
        Collection<DesignComponent> unusedCommands = MidpDocumentSupport.getAvailableCommandsForComponent(this.getComponent());
        if (unusedCommands == null) {
            return null;
        }
        for (DesignComponent unusedCommand : unusedCommands) {
            InfoPresenter infoPresenter = (InfoPresenter)unusedCommand.getPresenter(InfoPresenter.class);
            if (infoPresenter == null) {
                throw new IllegalStateException("No Info Presenter for component: " + unusedCommand);
            }
            AddActionItem item = UnusedCommandsAddActionPresenter.createUnusedCommandAction(new WeakReference<DesignComponent>(unusedCommand), new WeakReference<InfoPresenter>(infoPresenter), new WeakReference<UnusedCommandsAddActionPresenter>(this));
            item.resolveAction(this.getComponent());
            this.newAddActions.add((Action)item);
        }
        return this.newAddActions.toArray(new AddActionItem[this.newAddActions.size()]);
    }

    private static AddActionItem createUnusedCommandAction(final WeakReference<DesignComponent> unusedCommandComponent, final WeakReference<InfoPresenter> infoPresenter, final WeakReference<UnusedCommandsAddActionPresenter> presenter) {
        return new AddActionItem(((DesignComponent)unusedCommandComponent.get()).getType()){
            private ImageIcon icon;

            public void actionPerformed(ActionEvent event) {
                ((UnusedCommandsAddActionPresenter)((Object)presenter.get())).insideActionPerformed((DesignComponent)unusedCommandComponent.get());
            }

            public void resolveAction(DesignComponent component) {
                InfoPresenter presenter2 = (InfoPresenter)infoPresenter.get();
                this.icon = this.icon == null ? (this.icon = new ImageIcon(presenter2.getIcon(InfoPresenter.IconType.COLOR_16x16))) : this.icon;
                this.putValue("Name", presenter2.getDisplayName(InfoPresenter.NameType.PRIMARY));
                this.putValue("SmallIcon", this.icon);
            }
        };
    }
}

