/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.actions;

import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.actions.AbstractExecutorRunAction;
import org.netbeans.modules.cnd.api.remote.RemoteSyncSupport;
import org.netbeans.modules.cnd.api.remote.RemoteSyncWorker;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetUtils;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.builds.ImportUtils;
import org.netbeans.modules.cnd.execution.ShellExecSupport;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.ui.ModalMessageDlg;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionListener;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.LinkSupport;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.WindowManager;

public class ShellRunAction
extends AbstractExecutorRunAction {
    public String getName() {
        return ShellRunAction.getString("BTN_Run");
    }

    @Override
    protected boolean accept(DataObject object) {
        return object != null && object.getCookie(ShellExecSupport.class) != null;
    }

    protected void performAction(Node[] activatedNodes) {
        LifecycleManager.getDefault().saveAll();
        for (int i = 0; i < activatedNodes.length; ++i) {
            ShellRunAction.performAction(activatedNodes[i]);
        }
    }

    public static void performAction(Node node) {
        ShellRunAction.performAction(node, null, null, ShellRunAction.getProject(node), null);
    }

    public static Future<Integer> performAction(final Node node, final ExecutionListener listener, final Writer outputListener, final Project project, final InputOutput inputOutput) {
        if (SwingUtilities.isEventDispatchThread()) {
            ModalMessageDlg.LongWorker runner = new ModalMessageDlg.LongWorker(){
                private ExecutionService es;

                public void doWork() {
                    this.es = ShellRunAction.prepare(node, listener, outputListener, project, inputOutput);
                }

                public void doPostRunInEDT() {
                    if (this.es != null) {
                        this.es.run();
                    }
                }
            };
            Frame mainWindow = WindowManager.getDefault().getMainWindow();
            String title = ShellRunAction.getString("DLG_TITLE_Prepare", node.getName());
            String msg = ShellRunAction.getString("MSG_TITLE_Prepare", node.getName());
            ModalMessageDlg.runLongTask((Window)mainWindow, (String)title, (String)msg, (ModalMessageDlg.LongWorker)runner, null);
        } else {
            ExecutionService es = ShellRunAction.prepare(node, listener, outputListener, project, inputOutput);
            if (es != null) {
                return es.run();
            }
        }
        return null;
    }

    private static ExecutionService prepare(Node node, ExecutionListener listener, Writer outputListener, Project project, InputOutput inputOutput) {
        RemoteSyncWorker syncWorker;
        int i;
        ShellExecSupport bes = (ShellExecSupport)node.getCookie(ShellExecSupport.class);
        if (bes == null) {
            return null;
        }
        ShellRunAction.saveNode(node);
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        FileObject fileObject = dataObject.getPrimaryFile();
        File shellFile = FileUtil.toFile((FileObject)fileObject);
        String bdir = bes.getRunDirectory();
        String buildDir = ShellRunAction.getAbsoluteBuildDir(bdir, shellFile).getAbsolutePath();
        String[] shellCommandAndArgs = bes.getShellCommandAndArgs(fileObject);
        String shellCommand = shellCommandAndArgs[0];
        String shellFilePath = CndPathUtilitities.toRelativePath((String)buildDir, (String)shellFile.getPath());
        if (shellFilePath.equals(shellFile.getName())) {
            shellFilePath = "." + File.separatorChar + shellFilePath;
        }
        String[] args = bes.getArguments();
        ExecutionEnvironment execEnv = ShellRunAction.getExecutionEnvironment(fileObject, project);
        buildDir = ShellRunAction.convertToRemoteIfNeeded(execEnv, buildDir);
        if (buildDir == null) {
            return null;
        }
        shellFilePath = ShellRunAction.convertToRemoveSeparatorsIfNeeded(execEnv, shellFilePath);
        if (PlatformInfo.getDefault(execEnv).isWindows() && shellCommand.length() > 0) {
            shellCommand = ShellRunAction.findWindowsShell(shellCommand, execEnv, node);
            shellCommand = LinkSupport.resolveWindowsLink((String)shellCommand);
        }
        StringBuilder argsFlat = new StringBuilder();
        if (shellCommandAndArgs[0].length() > 0) {
            for (i = 1; i < shellCommandAndArgs.length; ++i) {
                argsFlat.append(" ");
                argsFlat.append(shellCommandAndArgs[i]);
            }
        }
        if (shellCommand.length() == 0) {
            shellCommand = shellFile.getAbsolutePath();
        } else {
            argsFlat.append(shellFilePath);
        }
        for (i = 0; i < args.length; ++i) {
            argsFlat.append(" ");
            argsFlat.append(args[i]);
        }
        Map<String, String> envMap = ShellRunAction.getEnv(execEnv, node, null);
        ShellRunAction.traceExecutable(shellCommand, buildDir, argsFlat, envMap);
        if (inputOutput == null) {
            String tabName = execEnv.isLocal() ? ShellRunAction.getString("RUN_LABEL", node.getName()) : ShellRunAction.getString("RUN_REMOTE_LABEL", node.getName(), execEnv.getDisplayName());
            InputOutput _tab = IOProvider.getDefault().getIO(tabName, false);
            _tab.closeInputOutput();
            InputOutput tab = IOProvider.getDefault().getIO(tabName, true);
            try {
                tab.getOut().reset();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            inputOutput = tab;
        }
        if ((syncWorker = RemoteSyncSupport.createSyncWorker((Project)project, (PrintWriter)inputOutput.getOut(), (PrintWriter)inputOutput.getErr())) != null && !syncWorker.startup(envMap)) {
            return null;
        }
        AbstractExecutorRunAction.ProcessChangeListener processChangeListener = new AbstractExecutorRunAction.ProcessChangeListener(listener, outputListener, null, inputOutput, "Run", syncWorker);
        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)execEnv).setWorkingDirectory(buildDir).unbufferOutput(false).addNativeProcessListener((ChangeListener)processChangeListener);
        npb.getEnvironment().putAll(envMap);
        npb.redirectError();
        List<String> list = ImportUtils.parseArgs(argsFlat.toString());
        list = ImportUtils.normalizeParameters(list);
        npb.setExecutable(shellCommand);
        npb.setArguments(list.toArray(new String[list.size()]));
        ExecutionDescriptor descr = new ExecutionDescriptor().controllable(true).frontWindow(true).inputVisible(true).inputOutput(inputOutput).outLineBased(true).showProgress(true).postExecution((Runnable)processChangeListener).errConvertorFactory((ExecutionDescriptor.LineConvertorFactory)processChangeListener).outConvertorFactory((ExecutionDescriptor.LineConvertorFactory)processChangeListener);
        return ExecutionService.newService((Callable)npb, (ExecutionDescriptor)descr, (String)"Run");
    }

    private static String findWindowsShell(String shellCommand, ExecutionEnvironment execEnv, Node node) {
        String folder;
        CompilerSetManager csm;
        File sc;
        int i = shellCommand.lastIndexOf(47);
        if (i >= 0) {
            shellCommand = shellCommand.substring(i + 1);
        }
        if ((sc = new File(shellCommand)).exists()) {
            return shellCommand;
        }
        PlatformInfo pi = PlatformInfo.getDefault(execEnv);
        String newShellCommand = pi.findCommand(shellCommand);
        if (newShellCommand != null) {
            return newShellCommand;
        }
        ArrayList<CompilerSet> list = new ArrayList<CompilerSet>();
        CompilerSet set = ShellRunAction.getCompilerSet(node);
        if (set != null) {
            list.add(set);
        }
        if ((csm = CompilerSetManager.get((ExecutionEnvironment)execEnv)) != null) {
            set = csm.getDefaultCompilerSet();
            if (set != null && !list.contains(set)) {
                list.add(set);
            }
            for (CompilerSet aSet : csm.getCompilerSets()) {
                if (aSet == null || list.contains(aSet)) continue;
                list.add(aSet);
            }
        }
        for (CompilerSet aSet : list) {
            folder = aSet.getCompilerFlavor().getCommandFolder(3);
            if (!(folder != null ? (newShellCommand = pi.findCommand(folder, shellCommand)) != null : (folder = aSet.getDirectory()) != null && (newShellCommand = pi.findCommand(folder, shellCommand)) != null)) continue;
            return newShellCommand;
        }
        folder = CompilerSetUtils.getCygwinBase();
        if (folder != null && (newShellCommand = pi.findCommand(folder + "/bin", shellCommand)) != null) {
            return newShellCommand;
        }
        folder = CompilerSetUtils.getCommandFolder(null);
        if (folder != null && (newShellCommand = pi.findCommand(folder, shellCommand)) != null) {
            return newShellCommand;
        }
        return shellCommand;
    }
}

