/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.debug;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public class DebugUtils {
    private static final Logger LOGGER = Logger.getLogger(DebugUtils.class.getName());

    public static FileObject getFileObjectFromUrl(String url) {
        FileObject fo = null;
        try {
            fo = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return fo;
    }

    public static String getClassFilter(String url) {
        FileObject fo = DebugUtils.getFileObjectFromUrl(url);
        String relativePath = url;
        if (fo != null) {
            ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
            if (cp == null) {
                LOGGER.log(Level.FINE, "No classpath for {0}", url);
                return null;
            }
            FileObject root = cp.findOwnerRoot(fo);
            if (root == null) {
                return null;
            }
            relativePath = FileUtil.getRelativePath((FileObject)root, (FileObject)fo);
        }
        if (relativePath.endsWith(".groovy")) {
            relativePath = relativePath.substring(0, relativePath.length() - 7);
        }
        return relativePath.replace('/', '.') + "*";
    }

    public static String getJspName(String url) {
        FileObject fo = DebugUtils.getFileObjectFromUrl(url);
        if (fo != null) {
            return fo.getNameExt();
        }
        return url == null ? null : url.toString();
    }

    public static String getJspPath(String url) {
        FileObject fo = DebugUtils.getFileObjectFromUrl(url);
        String relativePath = url;
        if (fo != null) {
            FileObject root = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source").findOwnerRoot(fo);
            relativePath = FileUtil.getRelativePath((FileObject)root, (FileObject)fo);
        }
        return relativePath;
    }
}

