/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.overrides;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.navigation.overrides.BaseAnnotation;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;

public class AnnotationsHolder
implements PropertyChangeListener {
    private static final Map<DataObject, AnnotationsHolder> file2holders = new HashMap<DataObject, AnnotationsHolder>();
    private final DataObject file;
    private final EditorCookie.Observable ec;
    private final List<BaseAnnotation> attachedAnnotations = new ArrayList<BaseAnnotation>();
    private Collection<BaseAnnotation> pendingAnnotations = null;
    private final Object pendingAnnotationsLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AnnotationsHolder get(DataObject dao) {
        Map<DataObject, AnnotationsHolder> map = file2holders;
        synchronized (map) {
            AnnotationsHolder holder = file2holders.get(dao);
            if (holder != null) {
                return holder;
            }
            EditorCookie.Observable ec = (EditorCookie.Observable)dao.getLookup().lookup(EditorCookie.Observable.class);
            if (ec == null) {
                return null;
            }
            holder = new AnnotationsHolder(dao, ec);
            file2holders.put(dao, holder);
            return holder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearIfNeed(DataObject dao) {
        AnnotationsHolder holder;
        Map<DataObject, AnnotationsHolder> map = file2holders;
        synchronized (map) {
            holder = file2holders.remove(dao);
        }
        if (holder != null) {
            holder.setNewAnnotations(Collections.<BaseAnnotation>emptyList());
        }
    }

    private AnnotationsHolder(DataObject file, EditorCookie.Observable ec) {
        this.file = file;
        this.ec = ec;
        ec.addPropertyChangeListener((PropertyChangeListener)this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AnnotationsHolder.this.checkForReset();
            }
        });
        Logger.getLogger("TIMER").log(Level.FINE, "Overridden AnnotationsHolder", new Object[]{file.getPrimaryFile(), this});
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("openedPanes".endsWith(evt.getPropertyName()) || evt.getPropertyName() == null) {
            this.checkForReset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForReset() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.ec.getOpenedPanes() == null) {
            Map<DataObject, AnnotationsHolder> map = file2holders;
            synchronized (map) {
                file2holders.remove(this.file);
            }
            this.setNewAnnotations(Collections.<BaseAnnotation>emptyList());
            this.ec.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNewAnnotations(Collection<BaseAnnotation> annotations2set) {
        Object object = this.pendingAnnotationsLock;
        synchronized (object) {
            this.pendingAnnotations = new ArrayList<BaseAnnotation>(annotations2set);
        }
        Runnable doAttachDetach = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Collection toAdd;
                Object a2;
                CndUtils.assertUiThread();
                for (Object a2 : AnnotationsHolder.this.attachedAnnotations) {
                    a2.detachImpl();
                }
                AnnotationsHolder.this.attachedAnnotations.clear();
                a2 = AnnotationsHolder.this.pendingAnnotationsLock;
                synchronized (a2) {
                    toAdd = AnnotationsHolder.this.pendingAnnotations;
                    AnnotationsHolder.this.pendingAnnotations = null;
                }
                if (toAdd == null) {
                    return;
                }
                for (BaseAnnotation a3 : toAdd) {
                    a3.attach();
                    AnnotationsHolder.this.attachedAnnotations.add(a3);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            doAttachDetach.run();
        } else {
            SwingUtilities.invokeLater(doAttachDetach);
        }
    }

    public List<BaseAnnotation> getAttachedAnnotations() {
        CndUtils.assertUiThread();
        return new ArrayList<BaseAnnotation>(this.attachedAnnotations);
    }
}

