/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.hyperlink;

import java.util.HashMap;
import java.util.Map;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider;
import org.netbeans.modules.hibernate.hyperlink.HyperlinkEnv;
import org.netbeans.modules.hibernate.hyperlink.HyperlinkProcessor;
import org.netbeans.modules.hibernate.hyperlink.JavaClassHyperlinkProcessor;
import org.netbeans.modules.hibernate.hyperlink.PropertyHyperlinkProcessor;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;

public class HibernateMappingHyperlinkProvider
implements HyperlinkProvider {
    private BaseDocument lastDocument = null;
    private HyperlinkProcessor currentProcessor;
    private Map<String, HyperlinkProcessor> attribValueProcessors = new HashMap<String, HyperlinkProcessor>();

    public HibernateMappingHyperlinkProvider() {
        JavaClassHyperlinkProcessor javaClassHyperlinkProcessor = new JavaClassHyperlinkProcessor();
        this.registerAttribValueHyperlinkPoint("class", "name", javaClassHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("subclass", "name", javaClassHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("subclass", "extends", javaClassHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("joined-subclass", "name", javaClassHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("joined-subclass", "extends", javaClassHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("joined-subclass", "persister", javaClassHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("union-subclass", "name", javaClassHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("union-subclass", "extends", javaClassHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("union-subclass", "persister", javaClassHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("one-to-many", "class", javaClassHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("composite-id", "class", javaClassHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("key-many-to-one", "class", javaClassHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("many-to-one", "class", javaClassHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("one-to-one", "class", javaClassHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("component", "class", javaClassHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("import", "class", javaClassHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("many-to-many", "class", javaClassHyperlinkProcessor);
        PropertyHyperlinkProcessor propertyHyperlinkProcessor = new PropertyHyperlinkProcessor();
        this.registerAttribValueHyperlinkPoint("property", "name", propertyHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("id", "name", propertyHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("set", "name", propertyHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("composite-id", "name", propertyHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("key-property", "name", propertyHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("key-many-to-one", "name", propertyHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("version", "name", propertyHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("timestamp", "name", propertyHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("many-to-one", "name", propertyHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("one-to-one", "name", propertyHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("component", "name", propertyHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("any", "name", propertyHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("map", "name", propertyHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("list", "name", propertyHyperlinkProcessor);
    }

    private void registerAttribValueHyperlinkPoint(String string, String string2, HyperlinkProcessor hyperlinkProcessor) {
        this.attribValueProcessors.put(this.createRegisteredName(string, string2), hyperlinkProcessor);
    }

    public boolean isHyperlinkPoint(Document document, int n) {
        if (!(document instanceof BaseDocument)) {
            return false;
        }
        BaseDocument baseDocument = (BaseDocument)document;
        if (!(baseDocument.getSyntaxSupport() instanceof XMLSyntaxSupport)) {
            return false;
        }
        HyperlinkEnv hyperlinkEnv = new HyperlinkEnv(document, n);
        this.currentProcessor = hyperlinkEnv.getType().isValueHyperlink() ? this.locateHyperlinkProcessor(hyperlinkEnv.getTagName(), hyperlinkEnv.getAttribName(), this.attribValueProcessors) : null;
        return this.currentProcessor != null;
    }

    public int[] getHyperlinkSpan(Document document, int n) {
        if (!(document instanceof BaseDocument)) {
            return null;
        }
        if (this.currentProcessor == null) {
            return null;
        }
        HyperlinkEnv hyperlinkEnv = new HyperlinkEnv(document, n);
        return this.currentProcessor.getSpan(hyperlinkEnv);
    }

    public void performClickAction(Document document, int n) {
        HyperlinkEnv hyperlinkEnv = new HyperlinkEnv(document, n);
        if (this.currentProcessor != null) {
            this.currentProcessor.process(hyperlinkEnv);
        }
    }

    protected String createRegisteredName(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null && string.trim().length() > 0) {
            stringBuilder.append("/nodeName=");
            stringBuilder.append(string);
        } else {
            stringBuilder.append("/nodeName=");
            stringBuilder.append("*");
        }
        if (string2 != null && string2.trim().length() > 0) {
            stringBuilder.append("/attribute=");
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private HyperlinkProcessor locateHyperlinkProcessor(String string, String string2, Map<String, HyperlinkProcessor> map) {
        String string3 = this.createRegisteredName(string, string2);
        if (map.containsKey(string3)) {
            return map.get(string3);
        }
        string3 = this.createRegisteredName("*", string2);
        if (map.containsKey(string3)) {
            return map.get(string3);
        }
        return null;
    }
}

