/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.ui.KenaiCombo;
import org.netbeans.modules.kenai.ui.URLDisplayerAction;
import org.netbeans.modules.kenai.ui.Utilities;
import org.netbeans.modules.kenai.ui.dashboard.LinkButton;
import org.netbeans.modules.kenai.ui.nodes.AddInstanceAction;
import org.netbeans.modules.kenai.ui.spi.UIUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class LoginPanel
extends JPanel {
    private Credentials credentials;
    private RequestProcessor.Task chkOnlineTask;
    RequestProcessor rp = new RequestProcessor(LoginPanel.class.getName(), 5);
    private Kenai kenai;
    JCheckBox chkIsOnline;
    JCheckBox chkRememberMe;
    JLabel error;
    JButton forgotPassword;
    JComboBox kenaiCombo;
    JLabel kenaiLabel;
    JLabel lblNoAccount;
    JLabel lblPassword;
    JLabel lblUserName;
    JPasswordField password;
    JProgressBar progressBar;
    JButton signUp;
    JTextField username;

    private URL getForgetPasswordUrl() {
        try {
            if (this.kenai != null) {
                return new URL(this.kenai.getUrl().toString() + "/people/forgot_password");
            }
            return new URL("https://netbeans.org/people/forgot_password");
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private URL getRegisterUrl() {
        try {
            if (this.kenai != null) {
                return new URL(this.kenai.getUrl().toString() + "/people/signup");
            }
            return new URL("https://netbeans.org/people/signup");
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public LoginPanel(Kenai kenai, Credentials credentials) {
        this.kenai = kenai;
        this.credentials = credentials;
        this.initComponents();
        this.kenaiCombo.setSelectedItem(kenai);
        if (kenai != null) {
            this.setUsername(credentials.getUsername(kenai));
            this.setPassword(credentials.getPassword(kenai));
            this.setChkOnline();
        } else {
            this.setChildrenEnabled(false);
        }
    }

    public boolean isStorePassword() {
        return this.chkRememberMe.isSelected();
    }

    public void showError(KenaiException ex) {
        String msg;
        this.kenaiCombo.setEnabled(true);
        this.progressBar.setVisible(false);
        String errorMessage = ex.getMessage();
        if (errorMessage == null || "".equals(errorMessage.trim())) {
            errorMessage = NbBundle.getMessage(LoginPanel.class, (String)"LBL_AuthenticationFailed");
            Logger.getLogger(LoginPanel.class.getName()).log(Level.INFO, errorMessage, ex);
        }
        this.error.setText(errorMessage);
        Map errors = ex.getErrors();
        if (errors != null && (msg = (String)errors.get("message")) != null) {
            this.error.setToolTipText(msg);
        }
        this.error.setVisible(true);
        this.password.requestFocus();
        this.setLoginButtonEnabled(true);
    }

    public void showProgress() {
        this.error.setVisible(false);
        this.progressBar.setVisible(true);
        this.progressBar.setIndeterminate(true);
        this.kenaiCombo.setEnabled(false);
        this.setLoginButtonEnabled(false);
    }

    private void setChildrenEnabled(boolean enabled) {
        for (Component c : this.getComponents()) {
            if (c == this.kenaiCombo || c == this.kenaiLabel) continue;
            c.setEnabled(enabled);
        }
    }

    public void clearStatus() {
        this.error.setVisible(false);
        this.progressBar.setVisible(false);
        this.setLoginButtonEnabled(true);
        this.kenaiCombo.setEnabled(true);
    }

    private void setChkOnline() {
        this.chkIsOnline.setSelected(false);
        this.chkIsOnline.setEnabled(false);
        if (this.chkOnlineTask != null) {
            this.chkOnlineTask.schedule(0);
        } else {
            this.chkOnlineTask = this.rp.post(new Runnable(){

                @Override
                public void run() {
                    if (LoginPanel.this.kenai == null) {
                        return;
                    }
                    boolean is = Utilities.isChatSupported(LoginPanel.this.kenai);
                    if (is) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Preferences preferences = NbPreferences.forModule(LoginPanel.class);
                                LoginPanel.this.chkIsOnline.setEnabled(true);
                                LoginPanel.this.chkIsOnline.setSelected(Boolean.parseBoolean(preferences.get(UIUtils.getPrefName(LoginPanel.this.kenai, ".online_chat"), "true")));
                            }
                        });
                    }
                }
            });
        }
    }

    private void setLoginButtonEnabled(boolean enabled) {
        try {
            ((Container)this.getParent().getComponents()[1]).getComponents()[0].setEnabled(enabled);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.lblUserName = new JLabel();
        this.username = new JTextField();
        this.lblPassword = new JLabel();
        this.chkRememberMe = new JCheckBox();
        this.lblNoAccount = new JLabel();
        this.password = new JPasswordField();
        this.forgotPassword = new LinkButton(NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.forgotPassword.text"), (Action)new URLDisplayerAction("", this.getForgetPasswordUrl()));
        this.signUp = new LinkButton(NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.register.text"), (Action)new URLDisplayerAction("", this.getRegisterUrl()));
        this.error = new JLabel();
        this.progressBar = new JProgressBar();
        this.chkIsOnline = new JCheckBox();
        this.kenaiLabel = new JLabel();
        this.kenaiCombo = new KenaiCombo(true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.lblUserName.setLabelFor(this.username);
        Mnemonics.setLocalizedText((JLabel)this.lblUserName, (String)NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.lblUserName.text"));
        this.lblPassword.setLabelFor(this.password);
        Mnemonics.setLocalizedText((JLabel)this.lblPassword, (String)NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.lblPassword.text"));
        this.chkRememberMe.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.chkRememberMe, (String)NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.chkRememberMe.text"));
        this.chkRememberMe.setToolTipText(NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.chkRememberMe.toolTipText"));
        this.chkRememberMe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginPanel.this.chkRememberMeActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lblNoAccount, (String)NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.lblNoAccount.text"));
        this.password.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                LoginPanel.this.passwordFocusGained(evt);
            }
        });
        this.error.setForeground(Color.red);
        this.error.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/kenai/ui/resources/error.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.chkIsOnline, (String)NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.chkIsOnline.text"));
        this.chkIsOnline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginPanel.this.chkIsOnlineActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.kenaiLabel, (String)NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.kenaiLabel.text"));
        this.kenaiCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginPanel.this.kenaiComboActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.error).add((Component)this.progressBar, -1, 418, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.lblUserName).add((Component)this.lblPassword).add((Component)this.kenaiLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lblNoAccount).addPreferredGap(0).add((Component)this.signUp)).add((Component)this.chkRememberMe).add((Component)this.password, -1, 292, Short.MAX_VALUE).add((Component)this.username, -1, 292, Short.MAX_VALUE).add((Component)this.forgotPassword).add((Component)this.chkIsOnline).add((Component)this.kenaiCombo, 0, 292, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(4).add((Component)this.kenaiLabel).add((Component)this.kenaiCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblUserName).add((Component)this.username, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblPassword).add((Component)this.password, -2, -1, -2)).addPreferredGap(0).add((Component)this.chkRememberMe).addPreferredGap(0).add((Component)this.chkIsOnline).addPreferredGap(0).add((Component)this.forgotPassword).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblNoAccount).add((Component)this.signUp)).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.error).add(0, 0, 0).add((Component)this.progressBar, -2, -1, -2)));
        this.lblUserName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.lblUserName.AccessibleContext.accessibleDescription"));
        this.lblPassword.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.lblPassword.AccessibleContext.accessibleDescription"));
        this.chkRememberMe.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.chkRememberMe.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.AccessibleContext.accessibleDescription"));
    }

    private void passwordFocusGained(FocusEvent evt) {
        this.password.setSelectionStart(0);
        this.password.setSelectionEnd(this.password.getPassword().length);
    }

    private void chkRememberMeActionPerformed(ActionEvent evt) {
        if (this.chkRememberMe.isSelected()) {
            ToolTipManager tooltipManager = ToolTipManager.sharedInstance();
            int initialDelay = tooltipManager.getInitialDelay();
            tooltipManager.setInitialDelay(0);
            tooltipManager.mouseMoved(new MouseEvent(this.chkRememberMe, 0, 0L, 0, 0, 0, 0, false));
            tooltipManager.setInitialDelay(initialDelay);
        }
    }

    private void chkIsOnlineActionPerformed(ActionEvent evt) {
        NbPreferences.forModule(LoginPanel.class).put(UIUtils.getPrefName(this.kenai, ".online_chat"), Boolean.toString(this.isOnline()));
        System.out.println(this.chkIsOnline.isEnabled());
    }

    private void kenaiComboActionPerformed(ActionEvent evt) {
        if (this.kenaiCombo.getSelectedItem() instanceof Kenai) {
            this.kenai = (Kenai)this.kenaiCombo.getSelectedItem();
            for (ActionListener l : this.forgotPassword.getActionListeners()) {
                this.forgotPassword.removeActionListener(l);
            }
            this.forgotPassword.setAction(new URLDisplayerAction("", this.getForgetPasswordUrl()));
            for (ActionListener l : this.signUp.getActionListeners()) {
                this.signUp.removeActionListener(l);
            }
            this.signUp.setAction(new URLDisplayerAction("", this.getRegisterUrl()));
            this.forgotPassword.setText(NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.forgotPassword.text"));
            this.signUp.setText(NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.register.text"));
            this.setUsername(this.credentials.getUsername(this.kenai));
            this.setPassword(this.credentials.getPassword(this.kenai));
            this.setChildrenEnabled(true);
            this.setChkOnline();
        } else if (this.kenaiCombo.getSelectedItem() instanceof String) {
            final ActionEvent e = evt;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new AddInstanceAction().actionPerformed(e);
                    LoginPanel.this.kenai = (Kenai)LoginPanel.this.kenaiCombo.getSelectedItem();
                    if (LoginPanel.this.kenai == null) {
                        return;
                    }
                    for (ActionListener l : LoginPanel.this.forgotPassword.getActionListeners()) {
                        LoginPanel.this.forgotPassword.removeActionListener(l);
                    }
                    LoginPanel.this.forgotPassword.setAction(new URLDisplayerAction("", LoginPanel.this.getForgetPasswordUrl()));
                    for (ActionListener l : LoginPanel.this.signUp.getActionListeners()) {
                        LoginPanel.this.signUp.removeActionListener(l);
                    }
                    LoginPanel.this.signUp.setAction(new URLDisplayerAction("", LoginPanel.this.getRegisterUrl()));
                    LoginPanel.this.forgotPassword.setText(NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.forgotPassword.text"));
                    LoginPanel.this.signUp.setText(NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.register.text"));
                    LoginPanel.this.setChildrenEnabled(true);
                    LoginPanel.this.setChkOnline();
                }
            });
        }
    }

    public char[] getPassword() {
        return this.password.getPassword();
    }

    public String getUsername() {
        return this.username.getText();
    }

    private void setUsername(String uname) {
        this.username.setText(uname);
        this.chkRememberMe.setSelected(true);
    }

    private void setPassword(char[] pwd) {
        this.password.setText(new String(pwd));
    }

    public boolean isOnline() {
        return this.chkIsOnline.isSelected();
    }

    public Kenai getKenai() {
        return (Kenai)this.kenaiCombo.getSelectedItem();
    }

    public static interface Credentials {
        public String getUsername(Kenai var1);

        public char[] getPassword(Kenai var1);
    }
}

