/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.impl;

import com.sun.source.tree.Tree;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.jackpot.spi.ClassPathBasedHintProvider;
import org.netbeans.modules.java.hints.jackpot.spi.ElementBasedHintProvider;
import org.netbeans.modules.java.hints.jackpot.spi.HintDescription;
import org.netbeans.modules.java.hints.jackpot.spi.HintMetadata;
import org.netbeans.modules.java.hints.jackpot.spi.HintProvider;
import org.netbeans.modules.java.hints.options.HintsSettings;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public class RulesManager {
    private final Map<Tree.Kind, List<HintDescription>> kind2Hints = new HashMap<Tree.Kind, List<HintDescription>>();
    private final Map<HintDescription.PatternDescription, List<HintDescription>> pattern2Hint = new HashMap<HintDescription.PatternDescription, List<HintDescription>>();
    public final Map<HintMetadata, Collection<? extends HintDescription>> allHints = new HashMap<HintMetadata, Collection<? extends HintDescription>>();
    private static final RulesManager INSTANCE = new RulesManager();

    public static RulesManager getInstance() {
        return INSTANCE;
    }

    private RulesManager() {
        for (HintProvider hintProvider : Lookup.getDefault().lookupAll(HintProvider.class)) {
            Map<HintMetadata, ? extends Collection<? extends HintDescription>> map = hintProvider.computeHints();
            for (Collection<? extends HintDescription> collection : map.values()) {
                RulesManager.sortOut(collection, this.kind2Hints, this.pattern2Hint);
            }
            this.allHints.putAll(map);
        }
    }

    public Map<Tree.Kind, List<HintDescription>> getKindBasedHints() {
        return this.kind2Hints;
    }

    public Map<HintDescription.PatternDescription, List<HintDescription>> getPatternBasedHints() {
        return this.pattern2Hint;
    }

    public static void computeElementBasedHintsXXX(CompilationInfo compilationInfo, AtomicBoolean atomicBoolean, Map<Tree.Kind, List<HintDescription>> map, Map<HintDescription.PatternDescription, List<HintDescription>> map2) {
        RulesManager.computeElementBasedHintsXXX(compilationInfo, atomicBoolean, Lookup.getDefault().lookupAll(ElementBasedHintProvider.class), Lookup.getDefault().lookupAll(ClassPathBasedHintProvider.class), map, map2);
    }

    public static void computeElementBasedHintsXXX(CompilationInfo compilationInfo, AtomicBoolean atomicBoolean, Collection<? extends ElementBasedHintProvider> collection, Collection<? extends ClassPathBasedHintProvider> collection2, Map<Tree.Kind, List<HintDescription>> map, Map<HintDescription.PatternDescription, List<HintDescription>> map2) {
        for (ElementBasedHintProvider object2 : collection) {
            RulesManager.sortOut(object2.computeHints(compilationInfo), map, map2);
        }
        ClasspathInfo classpathInfo = compilationInfo.getClasspathInfo();
        LinkedList<ClassPath> linkedList = new LinkedList<ClassPath>();
        linkedList.add(classpathInfo.getClassPath(ClasspathInfo.PathKind.BOOT));
        linkedList.add(classpathInfo.getClassPath(ClasspathInfo.PathKind.COMPILE));
        linkedList.add(classpathInfo.getClassPath(ClasspathInfo.PathKind.SOURCE));
        ClassPath classPath = ClassPathSupport.createProxyClassPath((ClassPath[])linkedList.toArray(new ClassPath[0]));
        for (ClassPathBasedHintProvider classPathBasedHintProvider : collection2) {
            RulesManager.sortOut(classPathBasedHintProvider.computeHints(classPath), map, map2);
        }
    }

    public static void sortOut(Iterable<? extends HintDescription> iterable, Map<Tree.Kind, List<HintDescription>> map, Map<HintDescription.PatternDescription, List<HintDescription>> map2) {
        for (HintDescription hintDescription : iterable) {
            List<HintDescription> list;
            if (hintDescription.getTriggerKind() != null) {
                list = map.get((Object)hintDescription.getTriggerKind());
                if (list == null) {
                    list = new LinkedList<HintDescription>();
                    map.put(hintDescription.getTriggerKind(), list);
                }
                list.add(hintDescription);
            }
            if (hintDescription.getTriggerPattern() == null) continue;
            list = map2.get(hintDescription.getTriggerPattern());
            if (list == null) {
                list = new LinkedList<HintDescription>();
                map2.put(hintDescription.getTriggerPattern(), list);
            }
            list.add(hintDescription);
        }
    }

    public static Preferences getPreferences(String string, String string2) {
        Preferences preferences;
        Map<String, Preferences> map = HintsSettings.getPreferencesOverride();
        if (map != null && (preferences = map.get(string)) != null) {
            return preferences;
        }
        string2 = string2 == null ? HintsSettings.getCurrentProfileId() : string2;
        return NbPreferences.forModule(RulesManager.class).node(string2).node(string);
    }
}

