/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.ri.platform;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.Profile;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.javacard.common.ListenerProxy;
import org.netbeans.modules.javacard.common.Utils;
import org.netbeans.modules.javacard.ri.platform.installer.PlatformInfo;
import org.netbeans.modules.javacard.ri.spi.CardsFactory;
import org.netbeans.modules.javacard.spi.Cards;
import org.netbeans.modules.javacard.spi.JavacardPlatform;
import org.netbeans.modules.javacard.spi.ProjectKind;
import org.netbeans.modules.propdos.ObservableProperties;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class RIPlatform
extends JavacardPlatform {
    private final Properties props;
    private final Map<Boolean, ClassPath> processorCps = new HashMap<Boolean, ClassPath>();
    private final Map<Boolean, ClassPath> bootCps = new HashMap<Boolean, ClassPath>();
    private final Object cpLock = new Object();
    private ClassPath stdLibs;
    private ClassPath src;
    private final Set<ProjectKind> suppKinds = new HashSet<ProjectKind>(5);
    static boolean inFindDefaultPlatform;
    private Cards cards = new CardsImpl();
    private final Map<String, String> FAKE_SYSPROPS = new HashMap<String, String>();

    public RIPlatform(Properties props) {
        this.FAKE_SYSPROPS.put("java.specification.vendor", "Sun Microsystems Inc.");
        this.FAKE_SYSPROPS.put("java.specification.version", "1.6");
        this.FAKE_SYSPROPS.put("java.vm.specification.vendor", "Sun Microsystems Inc.");
        this.FAKE_SYSPROPS.put("os.arch", "unknown");
        this.FAKE_SYSPROPS.put("java.vm.specification.name", "Java Card Virtual Machine Specification");
        this.FAKE_SYSPROPS.put("java.vm.vendor", "Sun Microsystems Inc.");
        this.FAKE_SYSPROPS.put("java.runtime.name", "Java Card Runtime Environment");
        this.FAKE_SYSPROPS.put("java.endorsed.dirs", "");
        this.FAKE_SYSPROPS.put("java.class.version", "50.0");
        this.FAKE_SYSPROPS.put("java.ext.dirs", "");
        this.FAKE_SYSPROPS.put("java.version", "1.6.0_10");
        this.props = props;
    }

    public RIPlatform(File root, String name, PlatformInfo info) {
        this(RIPlatform.props(root, name, info));
    }

    public void onDelete() throws IOException {
        FileObject fo = Utils.sfsFolderForDeviceConfigsForPlatformNamed((String)this.getSystemName(), (boolean)false);
        if (fo != null) {
            fo.delete();
        }
        if ((fo = Utils.sfsFolderForDeviceEepromsForPlatformNamed((String)this.getSystemName(), (boolean)false)) != null) {
            fo.delete();
        }
    }

    public Cards getCards() {
        Cards result;
        CardsFactory f = CardsFactory.find(this.getPlatformKind());
        if (f != null && (result = f.getCards(Utils.findPlatformDataObjectNamed((String)this.getSystemName()).getPrimaryFile())) != null) {
            return result;
        }
        return this.cards;
    }

    private static Properties props(File root, String name, PlatformInfo info) {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)RIPlatform.toProperties(root, name, info));
        return p;
    }

    public Set<ProjectKind> supportedProjectKinds() {
        if (this.suppKinds.isEmpty()) {
            String prop = this.props.getProperty("javacard.supported.project.kinds");
            this.suppKinds.addAll(ProjectKind.kindsFor((String)prop, (boolean)true));
        }
        return this.suppKinds;
    }

    private static EditableProperties toProperties(File root, String name, PlatformInfo info) {
        EditableProperties result = new EditableProperties(true);
        info.writeTo(result);
        result.setProperty("javacard.device.file.extension", "jcard");
        result.setProperty("javacard.displayName", name);
        result.setProperty("javacard.home", root.getAbsolutePath());
        return result;
    }

    public boolean isReferenceImplementation() {
        return "RI".equals(this.props.getProperty("javacard.platform.kind"));
    }

    public static DataObject findDefaultPlatform(DataObject caller) throws IOException {
        FileObject res = null;
        for (FileObject fo : Utils.findAllRegisteredJavacardPlatformFiles()) {
            JavacardPlatform p;
            if ("javacard_default".equals(fo.getName())) {
                res = fo;
                break;
            }
            DataObject ob = DataObject.find((FileObject)fo);
            if (caller == ob || (p = (JavacardPlatform)ob.getNodeDelegate().getLookup().lookup(RIPlatform.class)) == null || !"RI".equals(p.getPlatformKind())) continue;
            res = fo;
        }
        return res == null ? null : DataObject.find(res);
    }

    public static JavacardPlatform getDefault() {
        File riProps = null;
        try {
            riProps = (File)ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<File>(){

                public File run() throws Exception {
                    File result;
                    final EditableProperties globals = PropertyUtils.getGlobalProperties();
                    String path = globals.getProperty("javacard.ri.properties.path");
                    File file = result = path == null ? null : new File(path);
                    if (!(result == null || result.exists() && result.isFile())) {
                        result = null;
                    }
                    if (result == null) {
                        SpecificationVersion last = new SpecificationVersion("0.0");
                        FileObject target = null;
                        FileObject platformFolder = Utils.sfsFolderForRegisteredJavaPlatforms();
                        for (FileObject child : platformFolder.getChildren()) {
                            SpecificationVersion ver;
                            DataObject dob = DataObject.find((FileObject)child);
                            RIPlatform ri = (RIPlatform)((Object)dob.getLookup().lookup(RIPlatform.class));
                            if (ri == null || !ri.isReferenceImplementation() || (ver = ri.getJavacardVersion()).compareTo((Object)last) < 0) continue;
                            target = child;
                        }
                        if (target != null) {
                            final File p = FileUtil.toFile(target);
                            RequestProcessor.getDefault().post(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                                            public Object run() throws Exception {
                                                globals.setProperty("javacard.ri.properties.path", p.getAbsolutePath());
                                                PropertyUtils.putGlobalProperties((EditableProperties)globals);
                                                return null;
                                            }
                                        });
                                    }
                                    catch (MutexException me) {
                                        Exceptions.printStackTrace((Throwable)me);
                                    }
                                }
                            });
                        }
                    }
                    return result;
                }
            });
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (riProps == null) {
            return RIPlatform.brokenPlatform();
        }
        FileObject fo = FileUtil.toFileObject((File)riProps);
        if (fo == null) {
            return RIPlatform.brokenPlatform();
        }
        try {
            DataObject dob = DataObject.find((FileObject)fo);
            JavacardPlatform result = (JavacardPlatform)dob.getNodeDelegate().getLookup().lookup(JavacardPlatform.class);
            return result;
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return RIPlatform.brokenPlatform();
        }
    }

    private static JavacardPlatform brokenPlatform() {
        return JavacardPlatform.createBrokenJavacardPlatform((String)"none");
    }

    private List<? extends Lookup.Provider> getCardProviders() {
        String nm = this.getSystemName();
        FileObject fld = Utils.sfsFolderForDeviceConfigsForPlatformNamed((String)nm, (boolean)true);
        DataFolder df = DataFolder.findFolder((FileObject)fld);
        String ext = this.props.getProperty("javacard.device.file.extension");
        ext = ext == null ? "jcard" : ext;
        DataObject[] kids = df.getChildren();
        ArrayList<DataObject> result = new ArrayList<DataObject>(kids.length);
        for (DataObject dob : kids) {
            FileObject fo = dob.getPrimaryFile();
            if (!fo.isData() || !ext.equalsIgnoreCase(fo.getExt())) continue;
            result.add(dob);
        }
        return result;
    }

    public Properties toProperties() {
        return this.props;
    }

    public String getPlatformKind() {
        return this.props.getProperty("javacard.platform.kind", "RI");
    }

    public File getHome() {
        String home = this.props.getProperty("javacard.home");
        return home == null ? null : new File(home);
    }

    private static ClassPath createClasspathFromProperty(String key, Properties props) {
        return ClassPathFactory.createClassPath((ClassPathImplementation)new PropertyClassPathImpl(key, props));
    }

    private static URL[] getURLs(String absolutePaths) {
        String[] entries = absolutePaths.split(File.pathSeparator);
        ArrayList<URL> urls = new ArrayList<URL>(entries.length);
        for (String s : entries) {
            File f = new File(s);
            try {
                URL url = f.toURI().toURL();
                if (f.getName().endsWith(".jar")) {
                    String jarURL = "jar:" + url + "!/";
                    url = new URL(jarURL);
                } else if (!url.toString().endsWith("/")) {
                    url = new URL(url.toString() + "/");
                }
                urls.add(url);
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        URL[] results = urls.toArray(new URL[urls.size()]);
        return results;
    }

    public ClassPath getBootstrapLibraries() {
        return this.getBootstrapLibraries(ProjectKind.EXTENDED_APPLET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPath getStandardLibraries() {
        Object object = this.cpLock;
        synchronized (object) {
            if (this.stdLibs == null) {
                this.stdLibs = RIPlatform.createClasspathFromProperty("javacard.classpath", this.props);
            }
            return this.stdLibs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPath getProcessorClasspath(ProjectKind kind) {
        Object object = this.cpLock;
        synchronized (object) {
            ClassPath result = this.processorCps.get(kind.isClassic());
            if (result == null) {
                result = RIPlatform.createClasspathFromProperty(kind.isClassic() ? "javacard.platform.classic.processorpath" : "javacard.platform.processorpath", this.props);
                this.processorCps.put(kind.isClassic(), result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPath getBootstrapLibraries(ProjectKind kind) {
        Object object = this.cpLock;
        synchronized (object) {
            ClassPath result = this.bootCps.get(kind.isClassic());
            if (result == null) {
                String prop = kind.isClassic() ? "javacard.classic.bootclasspath" : "javacard.bootclasspath";
                result = RIPlatform.createClasspathFromProperty(prop, this.props);
                this.bootCps.put(kind.isClassic(), result);
            }
            return result;
        }
    }

    public Collection<FileObject> getInstallFolders() {
        if (this.isValid()) {
            return Collections.singleton(FileUtil.toFileObject((File)FileUtil.normalizeFile((File)this.getHome())));
        }
        return Collections.emptySet();
    }

    public FileObject findTool(String tool) {
        String path;
        File home = this.getHome();
        if ("emulator".equals(tool)) {
            String path2 = this.props.getProperty("javacard.debug.proxy");
            if (path2 == null) {
                File f = new File(new File(home, "bin"), Utilities.isWindows() ? "debugproxy.bat" : "debugproxy.sh");
                return FileUtil.toFileObject((File)FileUtil.normalizeFile((File)f));
            }
            return FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(path2)));
        }
        if ("debugProxy".equals(tool) && (path = this.props.getProperty("javacard.emulator")) == null) {
            File f = new File(new File(home, "bin"), Utilities.isWindows() ? "cjcre.exe" : "cjcre");
            return FileUtil.toFileObject((File)FileUtil.normalizeFile((File)f));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPath getSourceFolders() {
        Object object = this.cpLock;
        synchronized (object) {
            if (this.src == null) {
                this.src = RIPlatform.createClasspathFromProperty("javacard.sourcepath", this.props);
            }
            return this.src;
        }
    }

    public List<URL> getJavadocFolders() {
        String docFolders = this.props.getProperty("javacard.javadocpath");
        if (docFolders == null || "".equals(docFolders)) {
            return Collections.emptyList();
        }
        return Arrays.asList(RIPlatform.getURLs(docFolders));
    }

    public boolean isValid() {
        File home = this.getHome();
        boolean result = home != null && home.exists() && home.isDirectory();
        return result;
    }

    public String getDisplayName() {
        return this.props.getProperty("javacard.displayName", "[missing name]");
    }

    public String getSystemName() {
        return this.props.getProperty("javacard.instance.id");
    }

    public SpecificationVersion getJavacardVersion() {
        String ver = this.props.getProperty("javacard.device.version");
        return ver == null ? new SpecificationVersion("3.0") : new SpecificationVersion(ver);
    }

    public boolean isVersionSupported(SpecificationVersion javacardVersion) {
        return javacardVersion.compareTo((Object)3) >= 0;
    }

    public String getVendor() {
        String result = this.props.getProperty("javacard.vendor");
        if (result == null) {
            return NbBundle.getMessage(JavacardPlatform.class, (String)"UNKNOWN_VENDOR");
        }
        return result;
    }

    public Specification getSpecification() {
        String profileName = this.props.getProperty("javacard.profile");
        String profileVersion = this.props.getProperty("javacard.profileMajorVersion", "1") + '.' + this.props.getProperty("javacard.profileMinorVersion", "0");
        Profile profile = profileName == null ? null : new Profile(profileName, new SpecificationVersion(profileVersion));
        String platformVersion = this.props.getProperty("javacard.java.majorVersion", "1") + "." + this.props.getProperty("javacard.java.minorVersion", "0");
        SpecificationVersion specVer = new SpecificationVersion(platformVersion);
        Specification result = profile == null ? new Specification("JCRE", specVer) : new Specification("JCRE", specVer, new Profile[]{profile});
        return result;
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> result = new HashMap<String, String>(this.FAKE_SYSPROPS);
        result.put("bootclasspath", this.props.getProperty("javacard.bootclasspath"));
        return result;
    }

    public static class PropertyClassPathImpl
    extends ListenerProxy<Properties>
    implements ClassPathImplementation {
        private final String property;
        private final List<PathResourceImplementation> resources = new ArrayList<PathResourceImplementation>();
        private volatile boolean attached;

        PropertyClassPathImpl(String property, Properties props) {
            super((Object)props);
            this.property = property;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<? extends PathResourceImplementation> getResources() {
            PropertyClassPathImpl propertyClassPathImpl = this;
            synchronized (propertyClassPathImpl) {
                if (this.resources.isEmpty()) {
                    this.resources.addAll(this.refresh());
                }
                return new LinkedList<PathResourceImplementation>(this.resources);
            }
        }

        protected void attach(Properties props, PropertyChangeListener precreatedListener) {
            if (props instanceof ObservableProperties) {
                ObservableProperties ops = (ObservableProperties)props;
                ops.addPropertyChangeListener(precreatedListener);
            }
            this.attached = true;
        }

        protected void detach(Properties props, PropertyChangeListener precreatedListener) {
            if (props instanceof ObservableProperties) {
                ObservableProperties ops = (ObservableProperties)props;
                ops.removePropertyChangeListener(precreatedListener);
            }
            this.attached = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onChange(String prop, Object old, Object nue) {
            if (this.property.equals(prop)) {
                ArrayList<PathResourceImplementation> curr;
                boolean fire;
                ArrayList<PathResourceImplementation> oldRes = new ArrayList<PathResourceImplementation>();
                PropertyClassPathImpl propertyClassPathImpl = this;
                synchronized (propertyClassPathImpl) {
                    oldRes.addAll(this.resources);
                    this.resources.clear();
                    this.resources.addAll(this.refresh());
                    fire = !((Object)oldRes).equals(this.resources);
                    curr = !fire ? null : new ArrayList<PathResourceImplementation>(this.resources);
                }
                if (fire) {
                    this.fire("resources", oldRes, curr);
                }
            }
        }

        private List<PathResourceImplementation> refresh() {
            URL[] urls;
            ArrayList<PathResourceImplementation> result = new ArrayList<PathResourceImplementation>();
            String value = ((Properties)this.get()).getProperty(this.property);
            if (value == null) {
                return result;
            }
            for (URL u : urls = RIPlatform.getURLs(value)) {
                PRI pri = new PRI(u);
                result.add(pri);
            }
            return result;
        }

        private final class PRI
        implements PathResourceImplementation {
            private final URL url;

            PRI(URL url) {
                this.url = url;
                Parameters.notNull((CharSequence)"url", (Object)url);
            }

            public URL[] getRoots() {
                return new URL[]{this.url};
            }

            public ClassPathImplementation getContent() {
                return PropertyClassPathImpl.this;
            }

            public void addPropertyChangeListener(PropertyChangeListener listener) {
            }

            public void removePropertyChangeListener(PropertyChangeListener listener) {
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                PRI other = (PRI)obj;
                return this.url == other.url || this.url != null && this.url.toString().equals(other.url.toString());
            }

            public int hashCode() {
                return this.url.toString().hashCode();
            }
        }
    }

    private class CardsImpl
    extends Cards
    implements FileChangeListener {
        private CardsImpl() {
        }

        protected void addNotify() {
            super.addNotify();
            FileObject fld = this.getFolder();
            if (fld != null) {
                fld.addFileChangeListener((FileChangeListener)this);
            }
        }

        protected void removeNotify() {
            FileObject fld = this.getFolder();
            if (fld != null) {
                fld.removeFileChangeListener((FileChangeListener)this);
            }
            super.removeNotify();
        }

        private FileObject getFolder() {
            String nm = RIPlatform.this.getSystemName();
            FileObject fld = Utils.sfsFolderForDeviceConfigsForPlatformNamed((String)nm, (boolean)true);
            if (fld != null && fld.isValid()) {
                return fld;
            }
            return null;
        }

        public List<? extends Lookup.Provider> getCardSources() {
            return RIPlatform.this.getCardProviders();
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
            this.fireChange();
        }

        public void fileChanged(FileEvent fe) {
            this.fireChange();
        }

        public void fileDeleted(FileEvent fe) {
            this.fireChange();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.fireChange();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }
}

