/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.netbeans.modules.cnd.discovery.api.ApplicableImpl;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.netbeans.modules.cnd.discovery.api.DiscoveryUtils;
import org.netbeans.modules.cnd.discovery.api.Progress;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.ProviderProperty;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.DwarfSource;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.PathCache;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnit;
import org.netbeans.modules.cnd.dwarfdump.Dwarf;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.LANG;
import org.netbeans.modules.cnd.dwarfdump.exception.WrongFileFormatException;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public abstract class BaseDwarfProvider
implements DiscoveryProvider {
    private static final boolean TRACE_READ_EXCEPTIONS = Boolean.getBoolean("cnd.dwarfdiscovery.trace.read.errors");
    private static final boolean FULL_TRACE = Boolean.getBoolean("cnd.dwarfdiscovery.trace.read.source");
    public static final String RESTRICT_SOURCE_ROOT = "restrict_source_root";
    public static final String RESTRICT_COMPILE_ROOT = "restrict_compile_root";
    protected AtomicBoolean isStoped = new AtomicBoolean(false);
    private Map<String, GrepEntry> grepBase = new ConcurrentHashMap<String, GrepEntry>();
    private CompilerSettings myCommpilerSettings;

    public boolean isApplicable(ProjectProxy projectProxy) {
        return true;
    }

    public void stop() {
        this.isStoped.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SourceFileProperties> getSourceFileProperties(String[] stringArray, Progress progress, ProjectProxy projectProxy) {
        CountDownLatch countDownLatch = new CountDownLatch(stringArray.length);
        RequestProcessor requestProcessor = new RequestProcessor("Parallel analyzing", CndUtils.getNumberCndWorkerThreads());
        try {
            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
            for (String string : stringArray) {
                MyRunnable myRunnable = new MyRunnable(countDownLatch, string, concurrentHashMap, progress, projectProxy);
                requestProcessor.post((Runnable)myRunnable);
            }
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(concurrentHashMap.values());
            ArrayList arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            PathCache.dispose();
            this.grepBase.clear();
            this.grepBase = new ConcurrentHashMap<String, GrepEntry>();
            this.getCommpilerSettings().dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processObjectFile(String string, Map<String, SourceFileProperties> map, Progress progress, ProjectProxy projectProxy) {
        Object object;
        String string2;
        if (this.isStoped.get()) {
            return true;
        }
        String string3 = null;
        ProviderProperty providerProperty = this.getProperty(RESTRICT_SOURCE_ROOT);
        if (providerProperty != null && (string2 = (String)providerProperty.getValue()).length() > 0) {
            string3 = CndFileUtils.normalizeFile((File)new File(string2)).getAbsolutePath();
        }
        string2 = null;
        providerProperty = this.getProperty(RESTRICT_COMPILE_ROOT);
        if (providerProperty != null && ((String)(object = (String)providerProperty.getValue())).length() > 0) {
            string2 = CndFileUtils.normalizeFile((File)new File((String)object)).getAbsolutePath();
        }
        for (SourceFileProperties sourceFileProperties : this.getSourceFileProperties(string, map, projectProxy)) {
            if (this.isStoped.get()) break;
            String string4 = sourceFileProperties.getItemPath();
            if (string4 == null || string3 != null && !string4.startsWith(string3) || string2 != null && sourceFileProperties.getCompilePath() != null && !sourceFileProperties.getCompilePath().startsWith(string2)) continue;
            if (new File(string4).exists()) {
                SourceFileProperties sourceFileProperties2 = map.get(string4);
                if (sourceFileProperties2 == null) {
                    map.put(string4, sourceFileProperties);
                    continue;
                }
                if (sourceFileProperties2.getUserInludePaths().size() >= sourceFileProperties.getUserInludePaths().size()) continue;
                map.put(string4, sourceFileProperties);
                continue;
            }
            if (!FULL_TRACE) continue;
            System.out.println("Not Exist " + string4);
        }
        if (progress != null) {
            object = progress;
            synchronized (object) {
                progress.increment();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ApplicableImpl sizeComilationUnit(String string) {
        String string2;
        int n = 0;
        int n2 = 0;
        Dwarf dwarf = null;
        HashMap<String, AtomicInteger> hashMap = new HashMap<String, AtomicInteger>();
        try {
            dwarf = new Dwarf(string);
            Iterator iterator = dwarf.iteratorCompilationUnits();
            while (iterator.hasNext()) {
                Object object;
                string2 = (CompilationUnit)iterator.next();
                if (string2 == null || string2.getRoot() == null || string2.getSourceFileName() == null || (object = string2.getSourceLanguage()) == null) continue;
                boolean bl = false;
                if (LANG.DW_LANG_C.toString().equals(object) || LANG.DW_LANG_C89.toString().equals(object) || LANG.DW_LANG_C99.toString().equals(object)) {
                    ++n;
                } else {
                    if (!LANG.DW_LANG_C_plus_plus.toString().equals(object)) continue;
                    bl = true;
                    ++n;
                }
                String string3 = DwarfSource.extractCompilerName((CompilationUnit)string2, bl);
                if (string3 != null) {
                    AtomicInteger atomicInteger = (AtomicInteger)hashMap.get(string3);
                    if (atomicInteger == null) {
                        atomicInteger = new AtomicInteger();
                        hashMap.put(string3, atomicInteger);
                    }
                    atomicInteger.incrementAndGet();
                }
                if (!DwarfSource.isSunStudioCompiler((CompilationUnit)string2)) continue;
                ++n2;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (WrongFileFormatException wrongFileFormatException) {
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
        }
        finally {
            if (dwarf != null) {
                dwarf.dispose();
            }
        }
        int n3 = 0;
        string2 = "";
        for (Map.Entry entry : hashMap.entrySet()) {
            if (((AtomicInteger)entry.getValue()).get() <= n3) continue;
            n3 = ((AtomicInteger)entry.getValue()).get();
            string2 = (String)entry.getKey();
        }
        return new ApplicableImpl(n > 0, string2, n, n2 > n / 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SourceFileProperties> getSourceFileProperties(String string, Map<String, SourceFileProperties> map, ProjectProxy projectProxy) {
        ArrayList<SourceFileProperties> arrayList = new ArrayList<SourceFileProperties>();
        Dwarf dwarf = null;
        try {
            if (FULL_TRACE) {
                System.out.println("Process file " + string);
            }
            dwarf = new Dwarf(string);
            Iterator iterator = dwarf.iteratorCompilationUnits();
            while (iterator.hasNext()) {
                CompilationUnit compilationUnit = (CompilationUnit)iterator.next();
                if (compilationUnit == null) continue;
                if (this.isStoped.get()) {
                    break;
                }
                if (compilationUnit.getRoot() == null || compilationUnit.getSourceFileName() == null) {
                    if (!TRACE_READ_EXCEPTIONS) continue;
                    System.out.println("Compilation unit has broken name in file " + string);
                    continue;
                }
                String string2 = compilationUnit.getSourceLanguage();
                if (string2 == null) {
                    if (!TRACE_READ_EXCEPTIONS) continue;
                    System.out.println("Compilation unit has unresolved language in file " + string + "for " + compilationUnit.getSourceFileName());
                    continue;
                }
                DwarfSource dwarfSource = null;
                if (LANG.DW_LANG_C.toString().equals(string2) || LANG.DW_LANG_C89.toString().equals(string2) || LANG.DW_LANG_C99.toString().equals(string2)) {
                    dwarfSource = new DwarfSource(compilationUnit, false, this.getCommpilerSettings(), this.grepBase);
                } else if (LANG.DW_LANG_C_plus_plus.toString().equals(string2)) {
                    dwarfSource = new DwarfSource(compilationUnit, true, this.getCommpilerSettings(), this.grepBase);
                } else if (FULL_TRACE) {
                    System.out.println("Unknown language: " + string2);
                }
                if (dwarfSource == null) continue;
                String string3 = dwarfSource.getItemPath();
                SourceFileProperties sourceFileProperties = map.get(string3);
                if (sourceFileProperties != null && sourceFileProperties.getUserInludePaths().size() > 0) {
                    if (!FULL_TRACE) continue;
                    System.out.println("Compilation unit already exist. Skip " + string3);
                    continue;
                }
                dwarfSource.process(compilationUnit);
                if (dwarfSource.getCompilePath() == null) {
                    if (!TRACE_READ_EXCEPTIONS) continue;
                    System.out.println("Compilation unit has NULL compile path in file " + string);
                    continue;
                }
                arrayList.add(dwarfSource);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (TRACE_READ_EXCEPTIONS) {
                System.out.println("File not found " + string + ": " + fileNotFoundException.getMessage());
            }
        }
        catch (WrongFileFormatException wrongFileFormatException) {
            if (TRACE_READ_EXCEPTIONS) {
                System.out.println("Unsuported format of file " + string + ": " + wrongFileFormatException.getMessage());
            }
        }
        catch (IOException iOException) {
            if (TRACE_READ_EXCEPTIONS) {
                System.err.println("Exception in file " + string);
                iOException.printStackTrace();
            }
        }
        catch (Exception exception) {
            if (TRACE_READ_EXCEPTIONS) {
                System.err.println("Exception in file " + string);
                exception.printStackTrace();
            }
        }
        finally {
            if (dwarf != null) {
                dwarf.dispose();
            }
        }
        return arrayList;
    }

    public CompilerSettings getCommpilerSettings() {
        return this.myCommpilerSettings;
    }

    public void setCommpilerSettings(ProjectProxy projectProxy) {
        this.myCommpilerSettings = new CompilerSettings(projectProxy);
    }

    private class MyRunnable
    implements Runnable {
        private String file;
        private Map<String, SourceFileProperties> map;
        private Progress progress;
        private CountDownLatch countDownLatch;
        private ProjectProxy project;

        private MyRunnable(CountDownLatch countDownLatch, String string, Map<String, SourceFileProperties> map, Progress progress, ProjectProxy projectProxy) {
            this.file = string;
            this.map = map;
            this.progress = progress;
            this.countDownLatch = countDownLatch;
            this.project = projectProxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (!BaseDwarfProvider.this.isStoped.get()) {
                    Thread.currentThread().setName("Parallel analyzing " + this.file);
                    BaseDwarfProvider.this.processObjectFile(this.file, this.map, this.progress, this.project);
                }
            }
            finally {
                this.countDownLatch.countDown();
            }
        }
    }

    public static class CompilerSettings {
        private final List<String> systemIncludePathsC;
        private final List<String> systemIncludePathsCpp;
        private final Map<String, String> systemMacroDefinitionsC;
        private final Map<String, String> systemMacroDefinitionsCpp;
        private Map<String, String> normalizedPaths = new ConcurrentHashMap<String, String>();
        private final String compileFlavor;
        private final String cygwinDriveDirectory;
        private final boolean isWindows;

        public CompilerSettings(ProjectProxy projectProxy) {
            this.systemIncludePathsCpp = DiscoveryUtils.getSystemIncludePaths((ProjectProxy)projectProxy, (boolean)true);
            this.systemIncludePathsC = DiscoveryUtils.getSystemIncludePaths((ProjectProxy)projectProxy, (boolean)false);
            this.systemMacroDefinitionsCpp = DiscoveryUtils.getSystemMacroDefinitions((ProjectProxy)projectProxy, (boolean)true);
            this.systemMacroDefinitionsC = DiscoveryUtils.getSystemMacroDefinitions((ProjectProxy)projectProxy, (boolean)false);
            this.compileFlavor = DiscoveryUtils.getCompilerFlavor((ProjectProxy)projectProxy);
            this.isWindows = Utilities.isWindows();
            this.cygwinDriveDirectory = this.isWindows ? DiscoveryUtils.getCygwinDrive((ProjectProxy)projectProxy) : null;
        }

        public List<String> getSystemIncludePaths(boolean bl) {
            if (bl) {
                return this.systemIncludePathsCpp;
            }
            return this.systemIncludePathsC;
        }

        public Map<String, String> getSystemMacroDefinitions(boolean bl) {
            if (bl) {
                return this.systemMacroDefinitionsCpp;
            }
            return this.systemMacroDefinitionsC;
        }

        public String getNormalizedPath(String string) {
            String string2 = this.normalizedPaths.get(string);
            if (string2 == null) {
                string2 = this.normalizePath(string);
                this.normalizedPaths.put(string, string2);
            }
            return string2;
        }

        protected String normalizePath(String string) {
            string = CndFileUtils.normalizeFile((File)new File(string)).getAbsolutePath();
            if (Utilities.isWindows()) {
                string = string.replace('\\', '/');
            }
            return string;
        }

        public String getCompileFlavor() {
            return this.compileFlavor;
        }

        public String getCygwinDrive() {
            return this.cygwinDriveDirectory;
        }

        public boolean isWindows() {
            return this.isWindows;
        }

        private void dispose() {
            this.systemIncludePathsC.clear();
            this.systemIncludePathsCpp.clear();
            this.systemMacroDefinitionsC.clear();
            this.systemMacroDefinitionsCpp.clear();
            this.normalizedPaths.clear();
            this.normalizedPaths = new ConcurrentHashMap<String, String>();
        }
    }

    public static class GrepEntry {
        List<String> includes = new ArrayList<String>();
        String firstMacro = null;
        int firstMacroLine = -1;
    }
}

