/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.svg;

import java.util.Enumeration;
import java.util.Vector;
import org.netbeans.microedition.svg.SVGComponent;
import org.netbeans.microedition.svg.SVGForm;
import org.netbeans.microedition.svg.input.InputHandler;
import org.netbeans.microedition.svg.input.NumPadInputHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatableElement;
import org.w3c.dom.svg.SVGRect;

public class SVGTextArea
extends SVGComponent {
    private static final String HIDDEN_SUFFIX = "_hidden_text";
    private static final String CARET_SUFFIX = "_caret";
    private static final char LINE_BREAK = '\n';
    private InputHandler myHandler;
    private SVGLocatableElement myHiddenText;
    private Vector myLines;
    private Vector myEndOffsets;
    private int myStartOffset = 0;
    private int myLineWidth;
    private int myCaretPosition = -1;
    private int myCurrentLine;
    private float myLineHeight;
    private float myFirstLineY;
    private final SVGLocatableElement myCaret;
    private float myCaretWidth;

    public SVGTextArea(SVGForm form, String elemId) {
        super(form, elemId);
        SVGRect bBox;
        this.myHiddenText = (SVGLocatableElement)this.getElementById((SVGElement)this.wrapperElement, elemId + HIDDEN_SUFFIX);
        this.myCaret = (SVGLocatableElement)this.getElementById((SVGElement)this.wrapperElement, elemId + CARET_SUFFIX);
        this.myHandler = new TextAreaInputHandler();
        SVGRect outlineBox = this.wrapperElement.getBBox();
        SVGRect textBox = this.myHiddenText.getBBox();
        this.myLineWidth = textBox != null ? (int)(outlineBox.getWidth() + 0.5f - (textBox.getX() - outlineBox.getX()) * 2.0f) : 0;
        this.myLineHeight = this.myHiddenText.getBBox().getHeight();
        this.myFirstLineY = this.myHiddenText.getBBox().getY() + this.myLineHeight;
        if (this.myCaret != null && (bBox = this.myCaret.getBBox()) != null) {
            this.myCaretWidth = bBox.getWidth() / 2.0f;
        }
        this.setCaretPosition(0);
        this.showCaret(false);
    }

    public InputHandler getInputHandler() {
        return this.myHandler;
    }

    public String getText() {
        if (this.myLines == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        Enumeration en = this.myLines.elements();
        while (en.hasMoreElements()) {
            String line = (String)en.nextElement();
            buffer.append(line);
            buffer.append('\n');
        }
        if (buffer.length() > 0) {
            return buffer.toString().substring(0, buffer.length() - 1);
        }
        return buffer.toString();
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        StringBuffer buffer = new StringBuffer();
        char ch = ' ';
        this.myLines = new Vector();
        for (int i = 0; i < text.length(); ++i) {
            ch = text.charAt(i);
            if (ch == '\n') {
                this.myLines.addElement(buffer.toString());
                buffer = new StringBuffer();
                continue;
            }
            buffer.append(ch);
        }
        if (ch == '\n') {
            this.myLines.addElement("");
        } else {
            this.myLines.addElement(buffer.toString());
        }
        this.doSetText();
    }

    public void setCaretVisible(boolean isVisible) {
        this.showCaret(isVisible);
    }

    public void focusGained() {
        this.showCaret(true);
    }

    public void focusLost() {
        this.showCaret(false);
    }

    public void setCaretPosition(int caretPos) {
        if (caretPos != this.myCaretPosition) {
            this.myCaretPosition = caretPos;
            int endOffset = this.myEndOffsets == null ? 0 : (Integer)this.myEndOffsets.elementAt(this.myCurrentLine);
            if (caretPos < this.myStartOffset) {
                this.setStartOffset(caretPos);
            } else if (caretPos > endOffset) {
                this.setStartOffset(this.myStartOffset + caretPos - endOffset);
            }
            if (this.myCaret != null) {
                float caretLoc = this.myHiddenText.getFloatTrait("x");
                if (caretPos > 0) {
                    String beforeCaret = ((String)this.myLines.elementAt(this.myCurrentLine)).substring(this.myStartOffset, caretPos);
                    caretLoc += this.getTextWidth(beforeCaret) + this.myCaretWidth;
                }
                this.myCaret.setFloatTrait("x", caretLoc);
            }
        }
    }

    public void setStartOffset(int offset) {
        if (this.myStartOffset != offset) {
            this.myStartOffset = offset;
            this.doSetText();
        }
    }

    public int getCaretPosition() {
        return this.myCaretPosition;
    }

    private void showCaret(final boolean showCaret) {
        if (this.myCaret != null) {
            this.form.invokeLaterSafely(new Runnable(){

                public void run() {
                    SVGTextArea.this.myCaret.setTrait("visibility", showCaret ? "visible" : "hidden");
                }
            });
        }
    }

    private void doSetText() {
        if (this.myLines == null) {
            return;
        }
        this.cleanText();
        this.myEndOffsets = new Vector();
        Enumeration en = this.myLines.elements();
        float y = this.myFirstLineY;
        while (en.hasMoreElements()) {
            String text = (String)en.nextElement();
            if (this.myStartOffset > 0) {
                text = text.substring(this.myStartOffset);
            }
            while (this.getTextWidth(text) > (float)this.myLineWidth) {
                text = text.substring(0, text.length() - 1);
            }
            this.addText(text, y);
            y += this.myLineHeight;
            Integer endOffset = new Integer(this.myStartOffset + text.length());
            this.myEndOffsets.addElement(endOffset);
        }
    }

    private void addText(String text, float y) {
        SVGLocatableElement textElement = (SVGLocatableElement)this.form.getDocument().createElementNS("http://www.w3.org/2000/svg", "text");
        textElement.setFloatTrait("x", this.myHiddenText.getBBox().getX());
        textElement.setFloatTrait("y", y);
        textElement.setFloatTrait("font-size", this.myHiddenText.getFloatTrait("font-size"));
        textElement.setTrait("font-family", this.myHiddenText.getTrait("font-family"));
        textElement.setTrait("visibility", "inherit");
        if (text == null) {
            textElement.setTrait("#text", "");
        } else {
            textElement.setTrait("#text", text);
        }
        this.wrapperElement.appendChild((Node)textElement);
    }

    private void cleanText() {
        Element child = this.wrapperElement.getFirstElementChild();
        while (child != null) {
            if (!(child instanceof SVGElement)) {
                return;
            }
            SVGElement svgElement = (SVGElement)child;
            Element next = svgElement.getNextElementSibling();
            if ("text".equals(child.getLocalName()) && svgElement.getId() == null) {
                this.wrapperElement.removeChild((Node)child);
            }
            child = next;
        }
    }

    private float getTextWidth(String text) {
        float ret = text.endsWith(" ") ? this.computeTextWidth(text + "i") - this.computeTextWidth("i") : this.computeTextWidth(text);
        return ret;
    }

    private float computeTextWidth(String text) {
        float width = 0.0f;
        if (text.length() > 0) {
            this.myHiddenText.setTrait("#text", text);
            SVGRect bBox = this.myHiddenText.getBBox();
            if (bBox != null) {
                width = bBox.getWidth();
            }
        }
        return width;
    }

    class TextAreaInputHandler
    extends NumPadInputHandler {
        public TextAreaInputHandler() {
            super(SVGTextArea.this.form.getDisplay());
        }

        protected int getCaretPosition(SVGComponent comp) {
            return SVGTextArea.this.getCaretPosition();
        }

        protected String getText(SVGComponent comp) {
            return SVGTextArea.this.getText();
        }

        protected void setCaretPosition(SVGComponent comp, int position) {
            SVGTextArea.this.setCaretPosition(position);
        }

        protected void setText(SVGComponent comp, String text) {
            SVGTextArea.this.setText(text);
        }
    }
}

