/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;
import org.netbeans.modules.mobility.cldcplatform.ArchiveFilter;
import org.netbeans.modules.mobility.cldcplatform.DetectPanel;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;

public final class CustomizerPanel
extends JPanel
implements ChangeListener,
DocumentListener,
FocusListener {
    private static final Dimension PREF_DIM = new Dimension(560, 350);
    public static final String PREFS_TOOL = "prefs";
    public static final String UTILS_TOOL = "utils";
    public static final String MEM_PROP = "kvem.memory.monitor.enable";
    public static final String JAM_PROP = "jammode";
    public static final String NET_PROP = "kvem.netmon.enable";
    public static final String NET_HTTP_PROP = "kvem.netmon.http.enable";
    public static final String NET_HTTPS_PROP = "kvem.netmon.https.enable";
    public static final String PROF_PROP = "kvem.profiler.enable";
    public static final String FALSE = "false";
    J2MEPlatform platform;
    DefaultListModel mSources;
    DefaultListModel mJavaDocs;
    boolean mMemoryMonitor;
    boolean mNetworkMonitor;
    boolean mProfiler;
    String preverifyInfo;
    String executionInfo;
    String debuggerInfo;
    ListDataListener sourcesListener = new ListDataListener(){

        @Override
        public void intervalAdded(ListDataEvent e) {
            CustomizerPanel.this.saveSources();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            CustomizerPanel.this.saveSources();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            CustomizerPanel.this.saveSources();
        }
    };
    ListDataListener javadocsListener = new ListDataListener(){

        @Override
        public void intervalAdded(ListDataEvent e) {
            CustomizerPanel.this.saveJavadocs();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            CustomizerPanel.this.saveJavadocs();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            CustomizerPanel.this.saveJavadocs();
        }
    };
    private JButton bJavaDocAddArchive;
    private JButton bJavaDocAddFolder;
    private JButton bJavaDocMoveDown;
    private JButton bJavaDocMoveUp;
    private JButton bJavaDocRemove;
    private JButton bPreferences;
    private JButton bSourceAddArchive;
    private JButton bSourceAddFolder;
    private JButton bSourceMoveDown;
    private JButton bSourceMoveUp;
    private JButton bSourceRemove;
    private JButton bUtilities;
    private JCheckBox cMemoryMonitor;
    private JCheckBox cNetworkMonitor;
    private JCheckBox cProfiler;
    private JTextPane infoPanel;
    private JButton jButtonRefresh;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextFieldDebug;
    private JTextField jTextFieldDevice;
    private JTextField jTextFieldExec;
    private JTextField jTextFieldPreverify;
    private JList lDevices;
    private JList lJavaDocPaths;
    private JList lSourcePaths;

    public CustomizerPanel(J2MEPlatform platform) {
        this.initComponents();
        this.infoPanel.setEditorKitForContentType("text/html", new HTMLEditorKit());
        this.infoPanel.setContentType("text/html;charset=UTF-8");
        if (platform.getType().equalsIgnoreCase("custom")) {
            this.jTabbedPane1.remove(this.jPanel5);
        } else {
            this.jTabbedPane1.remove(this.jPanel6);
        }
        this.mSources = new DefaultListModel();
        this.lSourcePaths.setModel(this.mSources);
        this.mJavaDocs = new DefaultListModel();
        this.lJavaDocPaths.setModel(this.mJavaDocs);
        this.loadData(platform);
        this.addListeners();
    }

    void addListeners() {
        this.mSources.addListDataListener(this.sourcesListener);
        this.mJavaDocs.addListDataListener(this.javadocsListener);
        this.cMemoryMonitor.addChangeListener(this);
        this.cNetworkMonitor.addChangeListener(this);
        this.cProfiler.addChangeListener(this);
        this.jTextFieldPreverify.getDocument().addDocumentListener(this);
        this.jTextFieldExec.getDocument().addDocumentListener(this);
        this.jTextFieldDebug.getDocument().addDocumentListener(this);
        this.jTextFieldPreverify.addFocusListener(this);
        this.jTextFieldExec.addFocusListener(this);
        this.jTextFieldDebug.addFocusListener(this);
        this.preverifyInfo = this.loadInfo("nbresloc:/org/netbeans/modules/mobility/cldcplatform/customwizard/preverifyinfo.html");
        this.executionInfo = this.loadInfo("nbresloc:/org/netbeans/modules/mobility/cldcplatform/customwizard/executioninfo.html");
        this.debuggerInfo = this.loadInfo("nbresloc:/org/netbeans/modules/mobility/cldcplatform/customwizard/debuggerinfo.html");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadInfo(String location) {
        StringBuffer sb = new StringBuffer();
        InputStreamReader reader = null;
        try {
            int len;
            reader = new InputStreamReader(new URL(location).openStream(), "UTF-8");
            char[] chars = new char[4096];
            while ((len = reader.read(chars, 0, 4096)) >= 0) {
                sb.append(chars, 0, len);
            }
            String string = sb.toString();
            return string;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    public void clearData() {
        this.platform = null;
        this.mSources.clear();
        this.mJavaDocs.clear();
        this.bPreferences.setEnabled(false);
        this.bUtilities.setEnabled(false);
        this.cMemoryMonitor.setEnabled(false);
        this.mMemoryMonitor = false;
        this.cMemoryMonitor.setSelected(false);
        this.cNetworkMonitor.setEnabled(false);
        this.mNetworkMonitor = false;
        this.cNetworkMonitor.setSelected(false);
        this.cProfiler.setEnabled(false);
        this.mProfiler = false;
        this.cProfiler.setSelected(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadData(J2MEPlatform platform) {
        this.clearData();
        this.platform = platform;
        if (platform == null) {
            return;
        }
        DefaultListModel<String> mDevices = new DefaultListModel<String>();
        J2MEPlatform.Device[] devices = platform.getDevices();
        if (devices != null) {
            if (devices.length > 0) {
                this.jTextFieldDevice.setText(devices[0].getName());
            }
            for (int a = 0; a < devices.length; ++a) {
                mDevices.addElement(devices[a].isValid() ? devices[a].getName() : "<html><font color=\"#A40000\"><strike>" + devices[a].getName() + "</strike></font>");
            }
        }
        this.lDevices.setModel(mDevices);
        this.jTextFieldPreverify.setText(platform.getPreverifyCmd());
        this.jTextFieldExec.setText(platform.getRunCmd());
        this.jTextFieldDebug.setText(platform.getDebugCmd());
        FileObject[] al = platform.getSourceFolders().getRoots();
        this.mSources.clear();
        if (al != null) {
            for (FileObject ala : al) {
                this.mSources.addElement(new ListItem<FileObject>(ala));
            }
        }
        List<URL> l = platform.getJavadocFolders();
        this.mJavaDocs.clear();
        if (l != null) {
            for (URL la : l) {
                this.mJavaDocs.addElement(new ListItem<URL>(la));
            }
        }
        this.bPreferences.setEnabled(platform.findTool(PREFS_TOOL) != null);
        this.bUtilities.setEnabled(platform.findTool(UTILS_TOOL) != null);
        File f = new File(platform.getHomePath(), "wtklib" + File.separator + "emulator.properties");
        if (f.exists() && f.canWrite()) {
            Properties props = new Properties();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(f);
                props.load(fis);
            }
            catch (IOException e) {
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                    fis = null;
                }
            }
            this.cMemoryMonitor.setEnabled(true);
            this.cNetworkMonitor.setEnabled(true);
            this.cProfiler.setEnabled(true);
            this.mMemoryMonitor = Boolean.valueOf(props.getProperty(MEM_PROP, FALSE));
            this.cMemoryMonitor.setSelected(this.mMemoryMonitor);
            this.mNetworkMonitor = Boolean.valueOf(props.getProperty(NET_PROP, FALSE));
            this.cNetworkMonitor.setSelected(this.mNetworkMonitor);
            this.mProfiler = Boolean.valueOf(props.getProperty(PROF_PROP, FALSE));
            this.cProfiler.setSelected(this.mProfiler);
        }
        this.refreshButtons();
    }

    public void saveSources() {
        if (this.platform == null) {
            return;
        }
        Object[] os = this.mSources.toArray();
        ArrayList<FileObject> l = new ArrayList<FileObject>();
        if (os != null) {
            for (Object osa : os) {
                l.add((FileObject)((ListItem)osa).getObject());
            }
        }
        this.platform.setSourceFolders(l);
    }

    public void saveJavadocs() {
        if (this.platform == null) {
            return;
        }
        Object[] os = this.mJavaDocs.toArray();
        ArrayList<URL> l = new ArrayList<URL>();
        if (os != null) {
            for (Object osa : os) {
                l.add((URL)((ListItem)osa).getObject());
            }
        }
        this.platform.setJavadocFolders(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveWtkExtensions() {
        if (this.platform == null) {
            return;
        }
        File f = new File(this.platform.getHomePath(), "wtklib" + File.separator + "emulator.properties");
        if (f.exists() && f.canWrite() && this.cMemoryMonitor.isEnabled() && (this.cMemoryMonitor.isSelected() != this.mMemoryMonitor || this.cNetworkMonitor.isSelected() != this.mNetworkMonitor || this.cProfiler.isSelected() != this.mProfiler)) {
            String res;
            Properties props = new Properties();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(f);
                props.load(fis);
            }
            catch (IOException e) {
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                    fis = null;
                }
            }
            if (this.cMemoryMonitor.isSelected() != this.mMemoryMonitor) {
                res = String.valueOf(this.cMemoryMonitor.isSelected());
                props.setProperty(JAM_PROP, "");
                props.setProperty(MEM_PROP, res);
            }
            if (this.cNetworkMonitor.isSelected() != this.mNetworkMonitor) {
                res = String.valueOf(this.cNetworkMonitor.isSelected());
                props.setProperty(NET_PROP, res);
                props.setProperty(NET_HTTP_PROP, res);
                props.setProperty(NET_HTTPS_PROP, res);
            }
            if (this.cProfiler.isSelected() != this.mProfiler) {
                res = String.valueOf(this.cProfiler.isSelected());
                props.setProperty(PROF_PROP, res);
            }
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(f);
                props.store(fos, null);
            }
            catch (IOException e) {
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {}
                    fos = null;
                }
            }
        }
    }

    public void refreshButtons() {
        this.bSourceRemove.setEnabled(this.lSourcePaths.getSelectedValue() != null);
        this.bSourceMoveUp.setEnabled(this.lSourcePaths.getSelectedIndex() > 0);
        this.bSourceMoveDown.setEnabled(this.lSourcePaths.getSelectedIndex() >= 0 && this.lSourcePaths.getSelectedIndex() < this.mSources.getSize() - 1);
        this.bJavaDocRemove.setEnabled(this.lJavaDocPaths.getSelectedValue() != null);
        this.bJavaDocMoveUp.setEnabled(this.lJavaDocPaths.getSelectedIndex() > 0);
        this.bJavaDocMoveDown.setEnabled(this.lJavaDocPaths.getSelectedIndex() >= 0 && this.lJavaDocPaths.getSelectedIndex() < this.mJavaDocs.getSize() - 1);
    }

    private String browseArchive(String title) {
        File f = new FileChooserBuilder(CustomizerPanel.class).setFilesOnly(true).setFileFilter((FileFilter)new ArchiveFilter()).setTitle(title).showOpenDialog();
        if (f != null) {
            return f.getAbsolutePath();
        }
        return null;
    }

    private String browseFolder(String title) {
        File defPath = this.platform.getHomePath() == null ? null : new File(this.platform.getHomePath());
        File f = new FileChooserBuilder(this.getClass().getName() + ".fld").setFileFilter((FileFilter)new FolderFilter()).setTitle(title).setDefaultWorkingDirectory(defPath).showOpenDialog();
        if (f != null) {
            return f.getAbsolutePath();
        }
        return null;
    }

    private void openTool(FileObject tool) {
        if (tool == null) {
            return;
        }
        File f = FileUtil.toFile((FileObject)tool);
        if (f == null) {
            return;
        }
        try {
            Runtime.getRuntime().exec(f.getAbsolutePath());
        }
        catch (IOException e) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CustomizerPanel.class, (String)"MSG_CustomizerPanel_CannotExecTool", (Object)f.getAbsolutePath())));
        }
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel5 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.lDevices = new JList();
        this.jButtonRefresh = new JButton();
        this.jPanel6 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jTextFieldDevice = new JTextField();
        this.jLabel7 = new JLabel();
        this.jTextFieldPreverify = new JTextField();
        this.jLabel8 = new JLabel();
        this.jTextFieldExec = new JTextField();
        this.jLabel9 = new JLabel();
        this.jTextFieldDebug = new JTextField();
        this.jScrollPane4 = new JScrollPane();
        this.infoPanel = new JTextPane();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lSourcePaths = new JList();
        this.bSourceAddArchive = new JButton();
        this.bSourceAddFolder = new JButton();
        this.bSourceRemove = new JButton();
        this.bSourceMoveUp = new JButton();
        this.bSourceMoveDown = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.lJavaDocPaths = new JList();
        this.bJavaDocAddArchive = new JButton();
        this.bJavaDocAddFolder = new JButton();
        this.bJavaDocRemove = new JButton();
        this.bJavaDocMoveUp = new JButton();
        this.bJavaDocMoveDown = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabel4 = new JLabel();
        this.bPreferences = new JButton();
        this.bUtilities = new JButton();
        this.jLabel5 = new JLabel();
        this.cMemoryMonitor = new JCheckBox();
        this.cNetworkMonitor = new JCheckBox();
        this.cProfiler = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.setEnabled(false);
        this.setLayout(new BorderLayout());
        this.jTabbedPane1.setRequestFocusEnabled(false);
        this.jPanel5.setLayout(new GridBagLayout());
        this.jLabel3.setLabelFor(this.lDevices);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_Devices"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 6, 0, 6);
        this.jPanel5.add((Component)this.jLabel3, gridBagConstraints);
        this.lDevices.setSelectionMode(0);
        this.jScrollPane3.setViewportView(this.lDevices);
        this.lDevices.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPanel.class, (String)"ACD_CustomizerPanel_Devices"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel5.add((Component)this.jScrollPane3, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonRefresh, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_Refresh"));
        this.jButtonRefresh.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"TTT_CustomizerPanel_Refresh"));
        this.jButtonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerPanel.this.jButtonRefreshActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel5.add((Component)this.jButtonRefresh, gridBagConstraints);
        this.jTabbedPane1.addTab(NbBundle.getMessage(CustomizerPanel.class, (String)"TITLE_Customizer_Devices"), this.jPanel5);
        this.jPanel5.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPanel.class, (String)"ACN_CustomizerPanel_Devices"));
        this.jPanel5.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPanel.class, (String)"ACD_CustomizerPanel_Devices"));
        this.jPanel6.setLayout(new GridBagLayout());
        this.jLabel6.setLabelFor(this.jTextFieldDevice);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/mobility/cldcplatform/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)bundle.getString("LBL_Customizer_Device"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel6.add((Component)this.jLabel6, gridBagConstraints);
        this.jTextFieldDevice.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.jPanel6.add((Component)this.jTextFieldDevice, gridBagConstraints);
        this.jLabel7.setLabelFor(this.jTextFieldPreverify);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_Preverify"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 6, 0, 0);
        this.jPanel6.add((Component)this.jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 6, 0, 5);
        this.jPanel6.add((Component)this.jTextFieldPreverify, gridBagConstraints);
        this.jLabel8.setLabelFor(this.jTextFieldExec);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_Exec"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 6, 0, 0);
        this.jPanel6.add((Component)this.jLabel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 6, 0, 5);
        this.jPanel6.add((Component)this.jTextFieldExec, gridBagConstraints);
        this.jLabel9.setLabelFor(this.jTextFieldDebug);
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_Debug"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 6, 0, 0);
        this.jPanel6.add((Component)this.jLabel9, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 6, 0, 5);
        this.jPanel6.add((Component)this.jTextFieldDebug, gridBagConstraints);
        this.infoPanel.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.infoPanel.setEditable(false);
        this.jScrollPane4.setViewportView(this.infoPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 6, 5, 5);
        this.jPanel6.add((Component)this.jScrollPane4, gridBagConstraints);
        this.jTabbedPane1.addTab(NbBundle.getMessage(CustomizerPanel.class, (String)"TITLE_Customizer_Commands"), this.jPanel6);
        this.jPanel6.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPanel.class, (String)"ACN_CustomizerPanel_Commands"));
        this.jPanel6.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPanel.class, (String)"ACD_CustomizerPanel_Commands"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel2.setLabelFor(this.lSourcePaths);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_Sources"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 6, 0, 6);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jScrollPane1.setPreferredSize(new Dimension(500, 300));
        this.lSourcePaths.setSelectionMode(0);
        this.lSourcePaths.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                CustomizerPanel.this.lSourcePathsValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lSourcePaths);
        this.lSourcePaths.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPanel.class, (String)"ACD_CustomizerPanel_Sources"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bSourceAddArchive, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_AddArchive"));
        this.bSourceAddArchive.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"TTT_CustomizerPanel_SrcAddZip"));
        this.bSourceAddArchive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerPanel.this.bSourceAddArchiveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel1.add((Component)this.bSourceAddArchive, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bSourceAddFolder, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_AddFolder"));
        this.bSourceAddFolder.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"TTT_CustomizerPanel_SrcAddFolder"));
        this.bSourceAddFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerPanel.this.bSourceAddFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel1.add((Component)this.bSourceAddFolder, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bSourceRemove, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_Remove"));
        this.bSourceRemove.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"TTT_CustomizerPanel_SrcRemove"));
        this.bSourceRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerPanel.this.bSourceRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel1.add((Component)this.bSourceRemove, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bSourceMoveUp, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_MoveUp"));
        this.bSourceMoveUp.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"TTT_CustomizerPanel_SrcMoveUp"));
        this.bSourceMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerPanel.this.bSourceMoveUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel1.add((Component)this.bSourceMoveUp, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bSourceMoveDown, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_MoveDown"));
        this.bSourceMoveDown.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"TTT_CustomizerPanel_SrcMoveDown"));
        this.bSourceMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerPanel.this.bSourceMoveDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel1.add((Component)this.bSourceMoveDown, gridBagConstraints);
        this.jTabbedPane1.addTab(NbBundle.getMessage(CustomizerPanel.class, (String)"TITLE_Customizer_Sources"), this.jPanel1);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.lJavaDocPaths);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_JavaDocs"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 6, 0, 6);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.jScrollPane2.setPreferredSize(new Dimension(500, 300));
        this.lJavaDocPaths.setSelectionMode(0);
        this.lJavaDocPaths.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                CustomizerPanel.this.lJavaDocPathsValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.lJavaDocPaths);
        this.lJavaDocPaths.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPanel.class, (String)"ACD_CustomizerPanel_Javadoc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel2.add((Component)this.jScrollPane2, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bJavaDocAddArchive, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_AddArchive"));
        this.bJavaDocAddArchive.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"TTT_CustomizerPanel_Javadoc_AddJar"));
        this.bJavaDocAddArchive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerPanel.this.bJavaDocAddArchiveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel2.add((Component)this.bJavaDocAddArchive, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bJavaDocAddFolder, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_AddFolder"));
        this.bJavaDocAddFolder.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"TTT_CustomizerPanel_JavadocAddFolder"));
        this.bJavaDocAddFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerPanel.this.bJavaDocAddFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel2.add((Component)this.bJavaDocAddFolder, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bJavaDocRemove, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_Remove"));
        this.bJavaDocRemove.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"TTT_CustomizerPanel_JavadocRemove"));
        this.bJavaDocRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerPanel.this.bJavaDocRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel2.add((Component)this.bJavaDocRemove, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bJavaDocMoveUp, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_MoveUp"));
        this.bJavaDocMoveUp.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"TTT_CustomizerPanel_JavadocMoveUp"));
        this.bJavaDocMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerPanel.this.bJavaDocMoveUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel2.add((Component)this.bJavaDocMoveUp, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bJavaDocMoveDown, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_MoveDown"));
        this.bJavaDocMoveDown.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"TTT_CustomizerPanel_JavadocMoveDown"));
        this.bJavaDocMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerPanel.this.bJavaDocMoveDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel2.add((Component)this.bJavaDocMoveDown, gridBagConstraints);
        this.jTabbedPane1.addTab(NbBundle.getMessage(CustomizerPanel.class, (String)"TITLE_Customizer_JavaDocs"), this.jPanel2);
        this.jPanel2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPanel.class, (String)"ACN_CustomizerPanel_JavaDocs"));
        this.jPanel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPanel.class, (String)"ACD_CustomizerPanel_Javadoc"));
        this.jPanel3.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_OpenTools"));
        this.jLabel4.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_OpenTools"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel3.add((Component)this.jLabel4, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bPreferences, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_Preferences"));
        this.bPreferences.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"TTT_CustomizerPanel_ToolsPreferences"));
        this.bPreferences.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerPanel.this.bPreferencesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel3.add((Component)this.bPreferences, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bUtilities, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_Utilities"));
        this.bUtilities.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"TTT_CustomizerPanel_ToolsUtilities"));
        this.bUtilities.setPreferredSize(this.bPreferences.getPreferredSize());
        this.bUtilities.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerPanel.this.bUtilitiesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel3.add((Component)this.bUtilities, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_WTKExtensions"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel3.add((Component)this.jLabel5, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.cMemoryMonitor, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_MemoryMonitor"));
        this.cMemoryMonitor.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"TTT_CustomizerPanel_ToolsMemoryMon"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.jPanel3.add((Component)this.cMemoryMonitor, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.cNetworkMonitor, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_NetworkMonitor"));
        this.cNetworkMonitor.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"TTT_CustomizerPanel_ToolsNetworkMon"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 5, 6);
        this.jPanel3.add((Component)this.cNetworkMonitor, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.cProfiler, (String)NbBundle.getMessage(CustomizerPanel.class, (String)"LBL_Customizer_Profiler"));
        this.cProfiler.setToolTipText(NbBundle.getMessage(CustomizerPanel.class, (String)"TTT_CustomizerPanel_ToolsProfiler"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 5, 6);
        this.jPanel3.add((Component)this.cProfiler, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jPanel4, gridBagConstraints);
        this.jTabbedPane1.addTab(NbBundle.getMessage(CustomizerPanel.class, (String)"TITLE_Customizer_Tools"), this.jPanel3);
        this.jPanel3.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPanel.class, (String)"ACN_CustomizerPanel_Tools"));
        this.jPanel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPanel.class, (String)"ACD_CustomizerPanel_Tools"));
        this.add((Component)this.jTabbedPane1, "Center");
        this.jTabbedPane1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPanel.class, (String)"ACN_CustomizerPanel_Sources"));
        this.jTabbedPane1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPanel.class, (String)"ACD_CustomizerPanel_Sources"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPanel.class, (String)"ACN_CustomizerPanel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPanel.class, (String)"ACD_CustomizerPanel"));
    }

    private void jButtonRefreshActionPerformed(ActionEvent evt) {
        J2MEPlatform[] pfs = new J2MEPlatform[]{this.platform};
        DetectPanel dtp = new DetectPanel();
        DialogDescriptor desc = new DialogDescriptor((Object)dtp, NbBundle.getMessage(CustomizerPanel.class, (String)"TITLE_Customizer_PlatformRefresh"), true, 2, NotifyDescriptor.OK_OPTION, null);
        dtp.detectPlatform(pfs, this.platform.getHomePath(), null, desc);
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)desc))) {
            this.platform.setDevices(pfs[0].getDevices());
            ArrayList<URL> docs = new ArrayList<URL>(this.platform.getJavadocFolders());
            for (URL o : pfs[0].getJavadocFolders()) {
                if (docs.contains(o)) continue;
                docs.add(o);
            }
            this.platform.setJavadocFolders(docs);
            this.loadData(this.platform);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return PREF_DIM;
    }

    private void bJavaDocMoveDownActionPerformed(ActionEvent evt) {
        if (this.platform == null) {
            return;
        }
        int row = this.lJavaDocPaths.getSelectedIndex();
        if (row < 0 && row >= this.mJavaDocs.getSize() - 1) {
            return;
        }
        Object value1 = this.mJavaDocs.get(row);
        Object value2 = this.mJavaDocs.get(row + 1);
        this.mJavaDocs.set(row, value2);
        this.mJavaDocs.set(row + 1, value1);
        this.lJavaDocPaths.setSelectedIndex(row + 1);
        this.refreshButtons();
    }

    private void bJavaDocMoveUpActionPerformed(ActionEvent evt) {
        if (this.platform == null) {
            return;
        }
        int row = this.lJavaDocPaths.getSelectedIndex();
        if (row <= 0) {
            return;
        }
        Object value1 = this.mJavaDocs.get(row - 1);
        Object value2 = this.mJavaDocs.get(row);
        this.mJavaDocs.set(row - 1, value2);
        this.mJavaDocs.set(row, value1);
        this.lJavaDocPaths.setSelectedIndex(row - 1);
        this.refreshButtons();
    }

    private void bSourceMoveDownActionPerformed(ActionEvent evt) {
        if (this.platform == null) {
            return;
        }
        int row = this.lSourcePaths.getSelectedIndex();
        if (row < 0 && row >= this.mSources.getSize() - 1) {
            return;
        }
        Object value1 = this.mSources.get(row);
        Object value2 = this.mSources.get(row + 1);
        this.mSources.set(row, value2);
        this.mSources.set(row + 1, value1);
        this.lSourcePaths.setSelectedIndex(row + 1);
        this.refreshButtons();
    }

    private void bSourceMoveUpActionPerformed(ActionEvent evt) {
        if (this.platform == null) {
            return;
        }
        int row = this.lSourcePaths.getSelectedIndex();
        if (row <= 0) {
            return;
        }
        Object value1 = this.mSources.get(row - 1);
        Object value2 = this.mSources.get(row);
        this.mSources.set(row - 1, value2);
        this.mSources.set(row, value1);
        this.lSourcePaths.setSelectedIndex(row - 1);
        this.refreshButtons();
    }

    private void bJavaDocAddFolderActionPerformed(ActionEvent evt) {
        if (this.platform == null) {
            return;
        }
        String value = this.browseFolder(NbBundle.getMessage(CustomizerPanel.class, (String)"TITLE_Customizer_SelectJavaDocFolder"));
        if (value == null) {
            return;
        }
        URL o = J2MEPlatform.localfilepath2url(value);
        if (o != null) {
            this.mJavaDocs.addElement(new ListItem<URL>(o));
            this.refreshButtons();
        }
    }

    private void lJavaDocPathsValueChanged(ListSelectionEvent evt) {
        this.refreshButtons();
    }

    private void lSourcePathsValueChanged(ListSelectionEvent evt) {
        this.refreshButtons();
    }

    private void bSourceAddFolderActionPerformed(ActionEvent evt) {
        if (this.platform == null) {
            return;
        }
        String value = this.browseFolder(NbBundle.getMessage(CustomizerPanel.class, (String)"TITLE_Customizer_SelectSourceFolder"));
        if (value == null) {
            return;
        }
        FileObject o = this.platform.resolveRelativePathToFileObject(value);
        if (o != null) {
            this.mSources.addElement(new ListItem<FileObject>(o));
            this.refreshButtons();
        }
    }

    private void bUtilitiesActionPerformed(ActionEvent evt) {
        this.openTool(this.platform.findTool(UTILS_TOOL));
    }

    private void bPreferencesActionPerformed(ActionEvent evt) {
        this.openTool(this.platform.findTool(PREFS_TOOL));
    }

    private void bJavaDocRemoveActionPerformed(ActionEvent evt) {
        Object selected = this.lJavaDocPaths.getSelectedValue();
        if (selected == null) {
            return;
        }
        this.mJavaDocs.removeElement(selected);
        this.refreshButtons();
    }

    private void bJavaDocAddArchiveActionPerformed(ActionEvent evt) {
        if (this.platform == null) {
            return;
        }
        String value = this.browseArchive(NbBundle.getMessage(CustomizerPanel.class, (String)"TITLE_Customizer_SelectJavaDocArchive"));
        if (value == null) {
            return;
        }
        URL o = J2MEPlatform.localfilepath2url(value);
        if (o != null) {
            this.mJavaDocs.addElement(new ListItem<URL>(o));
            this.refreshButtons();
        }
    }

    private void bSourceRemoveActionPerformed(ActionEvent evt) {
        Object selected = this.lSourcePaths.getSelectedValue();
        if (selected == null) {
            return;
        }
        this.mSources.removeElement(selected);
        this.refreshButtons();
    }

    private void bSourceAddArchiveActionPerformed(ActionEvent evt) {
        if (this.platform == null) {
            return;
        }
        String value = this.browseArchive(NbBundle.getMessage(CustomizerPanel.class, (String)"TITLE_Customizer_SelectSourceArchive"));
        if (value == null) {
            return;
        }
        FileObject o = this.platform.resolveRelativePathToFileObject(value);
        if (o != null) {
            this.mSources.addElement(new ListItem<FileObject>(o));
            this.refreshButtons();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.saveWtkExtensions();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        Document d = e.getDocument();
        if (this.jTextFieldPreverify.getDocument() == d) {
            this.platform.setPreverifyCmd(this.jTextFieldPreverify.getText());
        } else if (this.jTextFieldExec.getDocument() == d) {
            this.platform.setRunCmd(this.jTextFieldExec.getText());
        } else {
            this.platform.setDebugCmd(this.jTextFieldDebug.getText());
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        Component component = e.getComponent();
        if (component == this.jTextFieldPreverify) {
            this.infoPanel.setText(this.preverifyInfo);
        } else if (component == this.jTextFieldExec) {
            this.infoPanel.setText(this.executionInfo);
        } else if (component == this.jTextFieldDebug) {
            this.infoPanel.setText(this.debuggerInfo);
        }
        this.infoPanel.setCaretPosition(0);
    }

    @Override
    public void focusLost(FocusEvent e) {
        Component oppositeComponent = e.getOppositeComponent();
        if (oppositeComponent != null && oppositeComponent != this.jTextFieldPreverify && oppositeComponent != this.jTextFieldExec && oppositeComponent != this.jTextFieldDebug && oppositeComponent != this.infoPanel) {
            this.infoPanel.setText("");
        }
    }

    static class ListItem<T> {
        T o;
        String str;

        ListItem(T o) {
            this.o = o;
            if (o instanceof FileObject) {
                this.str = J2MEPlatform.getFilePath((FileObject)o);
            } else if (o instanceof URL) {
                this.str = J2MEPlatform.getFilePath(URLMapper.findFileObject((URL)((URL)o)));
            }
            if (this.str == null) {
                this.str = o != null ? o.toString() : "";
            }
        }

        T getObject() {
            return this.o;
        }

        public String toString() {
            return this.str;
        }
    }

    private static final class FolderFilter
    extends FileFilter {
        private FolderFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.exists() && f.canRead() && f.isDirectory();
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(CustomizerPanel.class, (String)"TXT_Customizer_FolderFilter");
        }
    }
}

