/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.utils;

public final class JavaSourceLocation {
    public final String className;
    public final String methodName;
    public final String signature;
    public final int line;

    public JavaSourceLocation(String className) {
        this(className, null, null, Integer.MIN_VALUE);
    }

    public JavaSourceLocation(String className, String methodName) {
        this(className, methodName, null, Integer.MIN_VALUE);
    }

    public JavaSourceLocation(String className, String methodName, String signature) {
        this(className, methodName, signature, Integer.MIN_VALUE);
    }

    public JavaSourceLocation(String className, int line) {
        this(className, null, null, line);
    }

    public JavaSourceLocation(String className, String methodName, int line) {
        this(className, methodName, null, line);
    }

    public JavaSourceLocation(String className, String methodName, String signature, int line) {
        this.className = className;
        this.methodName = methodName;
        this.signature = signature;
        this.line = line;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaSourceLocation other = (JavaSourceLocation)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
            return false;
        }
        if (this.signature == null ? other.signature != null : !this.signature.equals(other.signature)) {
            return false;
        }
        return this.line == other.line;
    }

    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + (this.className != null ? this.className.hashCode() : 0);
        hash = 71 * hash + (this.methodName != null ? this.methodName.hashCode() : 0);
        hash = 71 * hash + (this.signature != null ? this.signature.hashCode() : 0);
        hash = 71 * hash + this.line;
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.className);
        if (this.methodName != null) {
            sb.append("#").append(this.methodName);
            if (this.signature != null) {
                sb.append("(").append(this.signature).append(")");
            }
        }
        if (this.line > Integer.MIN_VALUE) {
            sb.append(":").append(this.line);
        }
        return sb.toString();
    }
}

