/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.run;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.support.TargetLister;
import org.apache.tools.ant.module.bridge.AntBridge;
import org.apache.tools.ant.module.run.AdvancedActionPanel;
import org.apache.tools.ant.module.run.LastTargetExecuted;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.LifecycleManager;
import org.openide.awt.Actions;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.io.ReaderInputStream;
import org.openide.windows.IOProvider;
import org.openide.windows.IOSelect;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;
import org.w3c.dom.Element;

public final class TargetExecutor
implements Runnable {
    private static final RequestProcessor RP = new RequestProcessor(TargetExecutor.class.getName());
    private static final Map<InputOutput, String> freeTabs = new WeakHashMap<InputOutput, String>();
    private static final Set<String> activeDisplayNames = new HashSet<String>();
    private AntProjectCookie pcookie;
    private InputOutput io;
    private OutputStream outputStream;
    private boolean ok = false;
    private int verbosity = AntSettings.getVerbosity();
    private Map<String, String> properties = AntSettings.getProperties();
    private List<String> targetNames;
    private String displayName;
    private String suggestedDisplayName;
    private static final Map<InputOutput, StopAction> stopActions = new HashMap<InputOutput, StopAction>();
    private static final Map<InputOutput, RerunAction[]> rerunActions = new HashMap<InputOutput, RerunAction[]>();

    public TargetExecutor(AntProjectCookie pcookie, String[] targets) {
        this.pcookie = pcookie;
        this.targetNames = targets == null ? null : Arrays.asList(targets);
    }

    public void setVerbosity(int v) {
        this.verbosity = v;
    }

    public synchronized void setProperties(Map<String, String> p) {
        this.properties = new HashMap<String, String>(p);
    }

    void setDisplayName(String n) {
        this.suggestedDisplayName = n;
    }

    private static String getProcessDisplayName(AntProjectCookie pcookie, List<String> targetNames) {
        Element projel = pcookie.getProjectElement();
        String projectName = projel != null ? Actions.cutAmpersand((String)projel.getAttribute("name")) : NbBundle.getMessage(TargetExecutor.class, (String)"LBL_unparseable_proj_name");
        String fileName = pcookie.getFileObject() != null ? pcookie.getFileObject().getNameExt() : (pcookie.getFile() != null ? pcookie.getFile().getName() : "");
        if (projectName.equals("")) {
            projectName = fileName;
        }
        if (targetNames != null) {
            StringBuffer targetList = new StringBuffer();
            Iterator<String> it = targetNames.iterator();
            if (it.hasNext()) {
                targetList.append(it.next());
            }
            while (it.hasNext()) {
                targetList.append(NbBundle.getMessage(TargetExecutor.class, (String)"SEP_output_target"));
                targetList.append(it.next());
            }
            return NbBundle.getMessage(TargetExecutor.class, (String)"TITLE_output_target", (Object)projectName, (Object)fileName, (Object)targetList);
        }
        return NbBundle.getMessage(TargetExecutor.class, (String)"TITLE_output_notarget", (Object)projectName, (Object)fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorTask execute() throws IOException {
        ExecutorTask task;
        Object testdn;
        String dn = this.suggestedDisplayName != null ? this.suggestedDisplayName : TargetExecutor.getProcessDisplayName(this.pcookie, this.targetNames);
        Set<String> set = activeDisplayNames;
        synchronized (set) {
            if (activeDisplayNames.contains(dn)) {
                int i = 2;
                while (activeDisplayNames.contains(testdn = NbBundle.getMessage(TargetExecutor.class, (String)"TargetExecutor.uniquified", (Object)dn, (Object)i++))) {
                }
                dn = testdn;
            }
            assert (!activeDisplayNames.contains(dn));
            this.displayName = dn;
            activeDisplayNames.add(this.displayName);
        }
        TargetExecutor i = this;
        synchronized (i) {
            if (AntSettings.getAutoCloseTabs()) {
                testdn = freeTabs;
                synchronized (testdn) {
                    for (Map.Entry<InputOutput, String> entry : freeTabs.entrySet()) {
                        InputOutput free = entry.getKey();
                        String freeName = entry.getValue();
                        if (this.io == null && freeName.equals(this.displayName)) {
                            this.io = free;
                            this.io.getOut().reset();
                            continue;
                        }
                        free.closeInputOutput();
                        stopActions.remove(free);
                        rerunActions.remove(free);
                    }
                    freeTabs.clear();
                }
            }
            if (this.io == null) {
                StopAction sa = new StopAction();
                RerunAction[] ras = new RerunAction[]{new RerunAction(this, false), new RerunAction(this, true)};
                this.io = IOProvider.getDefault().getIO(this.displayName, new Action[]{ras[0], ras[1], sa, new OptionsAction()});
                stopActions.put(this.io, sa);
                rerunActions.put(this.io, ras);
            }
            task = ExecutionEngine.getDefault().execute(this.displayName, (Runnable)this, InputOutput.NULL);
        }
        WrapperExecutorTask wrapper = new WrapperExecutorTask(task, this.io);
        RP.post((Runnable)((Object)wrapper));
        return wrapper;
    }

    public ExecutorTask execute(OutputStream outputStream) throws IOException {
        this.outputStream = outputStream;
        ExecutorTask task = ExecutionEngine.getDefault().execute(null, (Runnable)this, InputOutput.NULL);
        return new WrapperExecutorTask(task, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        RerunAction[] ras;
        StopAction sa;
        LastTargetExecuted[] thisExec;
        block46: {
            File buildFile;
            OutputWriter err;
            OutputWriter out;
            Object displayed;
            block44: {
                block45: {
                    thisExec = new LastTargetExecuted[1];
                    sa = stopActions.get(this.io);
                    assert (sa != null);
                    ras = rerunActions.get(this.io);
                    assert (ras != null);
                    displayed = new AtomicBoolean(AntSettings.getAlwaysShowOutput());
                    if (this.outputStream == null) {
                        if (((AtomicBoolean)displayed).get()) {
                            this.io.select();
                        } else if (IOSelect.isSupported((InputOutput)this.io)) {
                            boolean onlyProcessRunning;
                            Set<String> set = activeDisplayNames;
                            synchronized (set) {
                                onlyProcessRunning = activeDisplayNames.size() == 1;
                            }
                            if (onlyProcessRunning) {
                                IOSelect.select((InputOutput)this.io, EnumSet.noneOf(IOSelect.AdditionalOperation.class));
                            }
                        }
                    }
                    if (AntSettings.getSaveAll()) {
                        LifecycleManager.getDefault().saveAll();
                    }
                    if (this.outputStream != null) {
                        throw new RuntimeException("XXX No support for outputStream currently!");
                    }
                    out = this.io.getOut();
                    err = this.io.getErr();
                    buildFile = this.pcookie.getFile();
                    if (buildFile != null) break block44;
                    err.println(NbBundle.getMessage(TargetExecutor.class, (String)"EXC_non_local_proj_file"));
                    if (this.io == null) break block45;
                    Map<InputOutput, String> map = freeTabs;
                    synchronized (map) {
                        freeTabs.put(this.io, this.displayName);
                    }
                }
                if (thisExec[0] != null) {
                    LastTargetExecuted.finish(thisExec[0]);
                }
                sa.t = null;
                TargetExecutor.setEnabledEQ(sa, false);
                for (RerunAction ra : ras) {
                    TargetExecutor.setEnabledEQ(ra, true);
                    ra.reinit(this);
                }
                Set<String> set = activeDisplayNames;
                synchronized (set) {
                    activeDisplayNames.remove(this.displayName);
                }
                return;
            }
            try {
                thisExec[0] = LastTargetExecuted.record(buildFile, this.targetNames != null ? this.targetNames.toArray(new String[this.targetNames.size()]) : null, this.properties, this.suggestedDisplayName != null ? this.suggestedDisplayName : TargetExecutor.getProcessDisplayName(this.pcookie, this.targetNames), Thread.currentThread());
                sa.t = thisExec[0];
                Thread.currentThread().setPriority(3);
                final Runnable runnable = new Runnable((AtomicBoolean)displayed){
                    final /* synthetic */ AtomicBoolean val$displayed;
                    {
                        this.val$displayed = atomicBoolean;
                    }

                    @Override
                    public void run() {
                        if (!this.val$displayed.getAndSet(true)) {
                            TargetExecutor.this.io.select();
                        }
                    }
                };
                ReaderInputStream in = null;
                if (this.outputStream == null) {
                    try {
                        in = new ReaderInputStream(this.io.getIn()){

                            public int read() throws IOException {
                                runnable.run();
                                return super.read();
                            }

                            public int read(byte[] b) throws IOException {
                                runnable.run();
                                return super.read(b);
                            }

                            public int read(byte[] b, int off, int len) throws IOException {
                                runnable.run();
                                return super.read(b, off, len);
                            }

                            public long skip(long n) throws IOException {
                                runnable.run();
                                return super.skip(n);
                            }
                        };
                    }
                    catch (IOException e) {
                        AntModule.err.notify(1, (Throwable)e);
                    }
                }
                ProgressHandle handle = ProgressHandleFactory.createHandle((String)this.displayName, (Cancellable)new Cancellable(){

                    public boolean cancel() {
                        sa.actionPerformed(null);
                        return true;
                    }
                }, (Action)new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TargetExecutor.this.io.select();
                    }
                });
                handle.setInitialDelay(0);
                handle.start();
                TargetExecutor.setEnabledEQ(sa, true);
                for (RerunAction ra : ras) {
                    TargetExecutor.setEnabledEQ(ra, false);
                }
                this.ok = AntBridge.getInterface().run(buildFile, this.targetNames, (InputStream)in, out, err, this.properties, this.verbosity, this.displayName, runnable, handle, this.io);
                if (this.io == null) break block46;
                displayed = freeTabs;
            }
            catch (Throwable throwable) {
                Object object;
                if (this.io != null) {
                    object = freeTabs;
                    synchronized (object) {
                        freeTabs.put(this.io, this.displayName);
                    }
                }
                if (thisExec[0] != null) {
                    LastTargetExecuted.finish(thisExec[0]);
                }
                sa.t = null;
                TargetExecutor.setEnabledEQ(sa, false);
                for (RerunAction ra : ras) {
                    TargetExecutor.setEnabledEQ(ra, true);
                    ra.reinit(this);
                }
                object = activeDisplayNames;
                synchronized (object) {
                    activeDisplayNames.remove(this.displayName);
                }
                throw throwable;
            }
            synchronized (displayed) {
                freeTabs.put(this.io, this.displayName);
            }
        }
        if (thisExec[0] != null) {
            LastTargetExecuted.finish(thisExec[0]);
        }
        sa.t = null;
        TargetExecutor.setEnabledEQ(sa, false);
        for (RerunAction ra : ras) {
            TargetExecutor.setEnabledEQ(ra, true);
            ra.reinit(this);
        }
        Set<String> set = activeDisplayNames;
        synchronized (set) {
            activeDisplayNames.remove(this.displayName);
        }
    }

    static void stopProcess(Thread t) {
        AntBridge.getInterface().stop(t);
    }

    private static void setEnabledEQ(final Action a, final boolean enabled) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                a.setEnabled(enabled);
            }
        });
    }

    private static class WrapperRunnable
    implements Runnable {
        private final ExecutorTask task;

        public WrapperRunnable(ExecutorTask task) {
            this.task = task;
        }

        @Override
        public void run() {
            this.task.waitFinished();
        }
    }

    private class WrapperExecutorTask
    extends ExecutorTask {
        private ExecutorTask task;
        private InputOutput io;

        public WrapperExecutorTask(ExecutorTask task, InputOutput io) {
            super((Runnable)new WrapperRunnable(task));
            this.task = task;
            this.io = io;
        }

        public void stop() {
            StopAction sa = (StopAction)stopActions.get(this.io);
            if (sa != null) {
                sa.actionPerformed(null);
            } else {
                this.task.stop();
            }
        }

        public int result() {
            return this.task.result() + (TargetExecutor.this.ok ? 0 : 1);
        }

        public InputOutput getInputOutput() {
            return this.io;
        }
    }

    private static final class OptionsAction
    extends AbstractAction {
        private OptionsAction() {
        }

        @Override
        public Object getValue(String key) {
            if (key.equals("SmallIcon")) {
                return new ImageIcon(TargetExecutor.class.getResource("/org/apache/tools/ant/module/resources/options.png"));
            }
            if (key.equals("ShortDescription")) {
                return NbBundle.getMessage(TargetExecutor.class, (String)"TargetExecutor.OptionsAction");
            }
            return super.getValue(key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OptionsDisplayer.getDefault().open("Advanced/Ant");
        }
    }

    private static final class RerunAction
    extends AbstractAction
    implements FileChangeListener {
        private final boolean withModifications;
        private AntProjectCookie pcookie;
        private List<String> targetNames;
        private int verbosity;
        private Map<String, String> properties;
        private String displayName;

        public RerunAction(TargetExecutor prototype, boolean withModifications) {
            this.withModifications = withModifications;
            this.reinit(prototype);
            TargetExecutor.setEnabledEQ(this, false);
            FileObject script = this.pcookie.getFileObject();
            if (script != null) {
                script.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)script));
            }
        }

        private void reinit(TargetExecutor prototype) {
            this.pcookie = prototype.pcookie;
            this.targetNames = prototype.targetNames;
            this.verbosity = prototype.verbosity;
            this.properties = prototype.properties;
            this.displayName = prototype.suggestedDisplayName;
        }

        @Override
        public Object getValue(String key) {
            if (key.equals("SmallIcon")) {
                if (this.withModifications) {
                    return new ImageIcon(TargetExecutor.class.getResource("/org/apache/tools/ant/module/resources/rerun-mod.png"));
                }
                return new ImageIcon(TargetExecutor.class.getResource("/org/apache/tools/ant/module/resources/rerun.png"));
            }
            if (key.equals("ShortDescription")) {
                if (this.withModifications) {
                    return NbBundle.getMessage(TargetExecutor.class, (String)"TargetExecutor.RerunAction.rerun_different");
                }
                return NbBundle.getMessage(TargetExecutor.class, (String)"TargetExecutor.RerunAction.rerun");
            }
            return super.getValue(key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            try {
                if (this.withModifications) {
                    AdvancedActionPanel panel = new AdvancedActionPanel(this.pcookie, TargetLister.getTargets(this.pcookie));
                    panel.setTargets(this.targetNames);
                    panel.setVerbosity(this.verbosity);
                    panel.setProperties(this.properties);
                    if (!panel.display()) {
                        this.setEnabled(true);
                    }
                } else {
                    TargetExecutor exec = new TargetExecutor(this.pcookie, this.targetNames != null ? this.targetNames.toArray(new String[this.targetNames.size()]) : null);
                    exec.setProperties(this.properties);
                    if (this.displayName != null) {
                        exec.setDisplayName(this.displayName);
                    }
                    exec.execute();
                }
            }
            catch (IOException x) {
                Logger.getLogger(TargetExecutor.class.getName()).log(Level.INFO, null, x);
            }
        }

        public void fileDeleted(FileEvent fe) {
            this.firePropertyChange("enabled", null, false);
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileRenamed(FileRenameEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && this.pcookie.getFileObject() != null && this.pcookie.getFileObject().isValid();
        }
    }

    private static final class StopAction
    extends AbstractAction {
        public LastTargetExecuted t;

        public StopAction() {
            TargetExecutor.setEnabledEQ(this, false);
        }

        @Override
        public Object getValue(String key) {
            if (key.equals("SmallIcon")) {
                return new ImageIcon(TargetExecutor.class.getResource("/org/apache/tools/ant/module/resources/stop.png"));
            }
            if (key.equals("ShortDescription")) {
                return NbBundle.getMessage(TargetExecutor.class, (String)"TargetExecutor.StopAction.stop");
            }
            return super.getValue(key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            if (this.t != null) {
                this.t.stopRunning();
            }
        }
    }
}

