/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.web;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.j2ee.web.WebAppFilterNode;
import org.netbeans.modules.maven.spi.nodes.AbstractMavenNodeList;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Node;

public class WebAppNodeFactory
implements NodeFactory {
    private static final String KEY_WEBAPP = "webapp";

    public NodeList createNodes(Project project) {
        Project project2 = (Project)project.getLookup().lookup(Project.class);
        return new NList(project2);
    }

    private static class NList
    extends AbstractMavenNodeList<String>
    implements PropertyChangeListener {
        private Project project;
        private NbMavenProject mavenproject;
        private String currentWebAppKey;

        private NList(Project project) {
            this.project = project;
            this.mavenproject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        }

        public List<String> keys() {
            URI uRI = this.mavenproject.getWebAppDirectory();
            if (uRI != null) {
                this.currentWebAppKey = WebAppNodeFactory.KEY_WEBAPP + uRI.toString();
                return Collections.singletonList(this.currentWebAppKey);
            }
            return Collections.emptyList();
        }

        public Node node(String string) {
            return this.createWebAppNode();
        }

        private Node createWebAppNode() {
            WebAppFilterNode webAppFilterNode = null;
            try {
                FileObject fileObject = URLMapper.findFileObject((URL)this.mavenproject.getWebAppDirectory().toURL());
                if (fileObject != null) {
                    DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
                    File file = FileUtil.toFile((FileObject)fileObject);
                    if (dataFolder != null) {
                        webAppFilterNode = new WebAppFilterNode(this.project, dataFolder.getNodeDelegate().cloneNode(), file);
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                webAppFilterNode = null;
            }
            return webAppFilterNode;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("MavenProject".equals(propertyChangeEvent.getPropertyName())) {
                this.fireChange();
            }
        }

        public void addNotify() {
            NbMavenProject.addPropertyChangeListener((Project)this.project, (PropertyChangeListener)this);
        }

        public void removeNotify() {
            NbMavenProject.removePropertyChangeListener((Project)this.project, (PropertyChangeListener)this);
        }
    }
}

