/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common.models;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.modules.cnd.debugger.common.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.common.breakpoints.AddressBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.FunctionBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.LineBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.customizers.AddressBreakpointPanel;
import org.netbeans.modules.cnd.debugger.common.breakpoints.customizers.ControllerProvider;
import org.netbeans.modules.cnd.debugger.common.breakpoints.customizers.FunctionBreakpointPanel;
import org.netbeans.modules.cnd.debugger.common.breakpoints.customizers.LineBreakpointPanel;
import org.netbeans.modules.cnd.debugger.common.disassembly.DisassemblyService;
import org.netbeans.spi.debugger.ui.Controller;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class BreakpointsActionsProvider
implements NodeActionsProviderFilter {
    private static final Action GO_TO_SOURCE_ACTION = Models.createAction((String)BreakpointsActionsProvider.loc("CTL_Breakpoint_GoToSource_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return true;
        }

        public void perform(Object[] nodes) {
            BreakpointsActionsProvider.goToSource((LineBreakpoint)((Object)nodes[0]));
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    private static final Action CUSTOMIZE_ACTION = Models.createAction((String)BreakpointsActionsProvider.loc("CTL_Breakpoint_Customize_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return true;
        }

        public void perform(Object[] nodes) {
            BreakpointsActionsProvider.customize((Breakpoint)nodes[0]);
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    private static final Action GO_TO_DIS_ACTION = Models.createAction((String)BreakpointsActionsProvider.loc("CTL_Breakpoint_GoToDis_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            DisassemblyService disProvider = EditorContextBridge.getCurrentDisassemblyService();
            return disProvider != null;
        }

        public void perform(Object[] nodes) {
            BreakpointsActionsProvider.goToSource((AddressBreakpoint)nodes[0]);
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);

    private static String loc(String key) {
        return NbBundle.getBundle(BreakpointsActionsProvider.class).getString(key);
    }

    public Action[] getActions(NodeActionsProvider original, Object node) throws UnknownTypeException {
        if (!(node instanceof CndBreakpoint)) {
            return original.getActions(node);
        }
        Action[] oas = original.getActions(node);
        if (node instanceof LineBreakpoint) {
            Action[] as = new Action[oas.length + 3];
            as[0] = GO_TO_SOURCE_ACTION;
            as[1] = null;
            System.arraycopy(oas, 0, as, 2, oas.length);
            as[as.length - 1] = CUSTOMIZE_ACTION;
            return as;
        }
        if (node instanceof AddressBreakpoint) {
            Action[] as = new Action[oas.length + 3];
            as[0] = GO_TO_DIS_ACTION;
            as[1] = null;
            System.arraycopy(oas, 0, as, 2, oas.length);
            as[as.length - 1] = CUSTOMIZE_ACTION;
            return as;
        }
        Action[] as = new Action[oas.length + 1];
        System.arraycopy(oas, 0, as, 0, oas.length);
        as[as.length - 1] = CUSTOMIZE_ACTION;
        return as;
    }

    public void performDefaultAction(NodeActionsProvider original, Object node) throws UnknownTypeException {
        if (node instanceof LineBreakpoint) {
            BreakpointsActionsProvider.goToSource((LineBreakpoint)((Object)node));
        } else if (node instanceof AddressBreakpoint) {
            BreakpointsActionsProvider.goToSource((AddressBreakpoint)node);
        } else if (node instanceof CndBreakpoint) {
            BreakpointsActionsProvider.customize((Breakpoint)node);
        } else {
            original.performDefaultAction(node);
        }
    }

    public void addModelListener(ModelListener l) {
    }

    public void removeModelListener(ModelListener l) {
    }

    public static JComponent getCustomizerComponent(Breakpoint b) {
        JPanel c = null;
        if (b instanceof LineBreakpoint) {
            c = new LineBreakpointPanel((LineBreakpoint)b);
        } else if (b instanceof FunctionBreakpoint) {
            c = new FunctionBreakpointPanel((FunctionBreakpoint)b);
        } else if (b instanceof AddressBreakpoint) {
            c = new AddressBreakpointPanel((AddressBreakpoint)b);
        } else {
            throw new IllegalStateException(b.toString());
        }
        ((Component)c).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BreakpointsActionsProvider.class, (String)"ACSD_Breakpoint_Customizer_Dialog"));
        return c;
    }

    public static void customize(Breakpoint b) {
        JComponent c = BreakpointsActionsProvider.getCustomizerComponent(b);
        HelpCtx helpCtx = HelpCtx.findHelp((Component)c);
        if (helpCtx == null) {
            helpCtx = new HelpCtx("debug.add.breakpoint");
        }
        final Controller[] cPtr = new Controller[]{((ControllerProvider)((Object)c)).getController()};
        final DialogDescriptor[] descriptorPtr = new DialogDescriptor[1];
        final Dialog[] dialogPtr = new Dialog[1];
        ActionListener buttonsActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (descriptorPtr[0].getValue() == DialogDescriptor.OK_OPTION) {
                    boolean ok = cPtr[0].ok();
                    if (ok) {
                        dialogPtr[0].setVisible(false);
                    }
                } else {
                    dialogPtr[0].setVisible(false);
                }
            }
        };
        DialogDescriptor descriptor = new DialogDescriptor((Object)c, NbBundle.getMessage(BreakpointsActionsProvider.class, (String)"CTL_Breakpoint_Customizer_Title"), true, 2, DialogDescriptor.OK_OPTION, 0, helpCtx, buttonsActionListener);
        descriptor.setClosingOptions(new Object[0]);
        Dialog d = DialogDisplayer.getDefault().createDialog(descriptor);
        d.pack();
        descriptorPtr[0] = descriptor;
        dialogPtr[0] = d;
        d.setVisible(true);
    }

    private static void goToSource(CndBreakpoint b) {
        EditorContextBridge.showSource(b, null);
    }
}

