/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.debugger.common.breakpoints.LineBreakpoint;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.WeakListeners;

class LineTranslations {
    private static LineTranslations translations;
    private ChangeListener changedFilesListener;
    private Map<Object, Registry> timeStampToRegistry = new WeakHashMap<Object, Registry>();
    private Map<LineBreakpoint, BreakpointLineUpdater> lineUpdaters = new HashMap<LineBreakpoint, BreakpointLineUpdater>();
    private Map<Object, Map<LineBreakpoint, Integer>> originalBreakpointLines = new WeakHashMap<Object, Map<LineBreakpoint, Integer>>();
    private Map<Object, PropertyChangeListener> breakpointListeners = new WeakHashMap<Object, PropertyChangeListener>();

    private LineTranslations() {
    }

    static synchronized LineTranslations getTranslations() {
        if (translations == null) {
            translations = new LineTranslations();
        }
        return translations;
    }

    synchronized void createTimeStamp(Object timeStamp) {
        Set modifiedDataObjects = DataObject.getRegistry().getModifiedSet();
        Registry r = new Registry();
        this.timeStampToRegistry.put(timeStamp, r);
        for (DataObject dobj : modifiedDataObjects) {
            r.register(dobj);
        }
        if (this.changedFilesListener == null) {
            this.changedFilesListener = new ChangedFilesListener();
            DataObject.getRegistry().addChangeListener(this.changedFilesListener);
        }
    }

    synchronized void disposeTimeStamp(Object timeStamp) {
        this.timeStampToRegistry.remove(timeStamp);
        if (this.timeStampToRegistry.isEmpty()) {
            DataObject.getRegistry().removeChangeListener(this.changedFilesListener);
            this.changedFilesListener = null;
        }
        this.originalBreakpointLines.remove(timeStamp);
        this.breakpointListeners.remove(timeStamp);
    }

    synchronized int getOriginalLineNumber(LineBreakpoint lb, final Object timeStamp) {
        Map<LineBreakpoint, Integer> bpLines = this.originalBreakpointLines.get(timeStamp);
        if (bpLines != null) {
            Integer line = bpLines.get((Object)lb);
            if (line != null) {
                return line;
            }
        } else {
            bpLines = new WeakHashMap<LineBreakpoint, Integer>();
            this.originalBreakpointLines.put(timeStamp, bpLines);
        }
        int line = this.getOriginalLineNumber(lb.getURL(), lb.getLineNumber(), timeStamp);
        bpLines.put(lb, line);
        PropertyChangeListener lineNumberListener = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("lineNumber".equals(evt.getPropertyName())) {
                    LineTranslations lineTranslations = LineTranslations.this;
                    synchronized (lineTranslations) {
                        Map bpLines = (Map)LineTranslations.this.originalBreakpointLines.get(timeStamp);
                        if (bpLines != null) {
                            LineBreakpoint lb = (LineBreakpoint)((Object)evt.getSource());
                            int line = LineTranslations.this.getOriginalLineNumber(lb.getURL(), lb.getLineNumber(), timeStamp);
                            bpLines.put(lb, line);
                        }
                    }
                }
            }
        };
        this.breakpointListeners.put(timeStamp, lineNumberListener);
        lb.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)lineNumberListener, (Object)((Object)lb)));
        return line;
    }

    int getOriginalLineNumber(String url, int currentLineNumber, Object timeStamp) {
        if (timeStamp == null) {
            return currentLineNumber;
        }
        Line.Set lineSet = this.getLineSet(url, timeStamp);
        if (lineSet == null) {
            return currentLineNumber;
        }
        try {
            return lineSet.getOriginalLineNumber(lineSet.getCurrent(currentLineNumber));
        }
        catch (IndexOutOfBoundsException ioobex) {
            return currentLineNumber;
        }
    }

    synchronized void updateTimeStamp(Object timeStamp, String url) {
        Registry registry = this.timeStampToRegistry.get(timeStamp);
        registry.register(LineTranslations.getDataObject(url));
        Map<LineBreakpoint, Integer> bpLines = this.originalBreakpointLines.get(timeStamp);
        if (bpLines != null) {
            HashSet<LineBreakpoint> bpts = new HashSet<LineBreakpoint>(bpLines.keySet());
            for (LineBreakpoint bp : bpts) {
                if (!url.equals(bp.getURL())) continue;
                bpLines.remove((Object)bp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Line.Set getLineSet(String url, Object timeStamp) {
        LineCookie lineCookie;
        DataObject dataObject = LineTranslations.getDataObject(url);
        if (dataObject == null) {
            return null;
        }
        if (timeStamp != null) {
            LineTranslations lineTranslations = this;
            synchronized (lineTranslations) {
                Line.Set ls;
                Registry registry = this.timeStampToRegistry.get(timeStamp);
                if (registry != null && (ls = registry.getLineSet(dataObject)) != null) {
                    return ls;
                }
            }
        }
        if ((lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class)) == null) {
            return null;
        }
        return lineCookie.getLineSet();
    }

    Line getLine(String url, int lineNumber, Object timeStamp) {
        Line.Set ls = this.getLineSet(url, timeStamp);
        if (ls == null) {
            return null;
        }
        try {
            if (timeStamp == null) {
                return ls.getCurrent(lineNumber - 1);
            }
            return ls.getOriginal(lineNumber - 1);
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        return null;
    }

    synchronized void registerForLineUpdates(LineBreakpoint lb) {
        DataObject dobj = LineTranslations.getDataObject(lb.getURL());
        if (dobj != null) {
            BreakpointLineUpdater blu = new BreakpointLineUpdater(lb, dobj);
            try {
                blu.attach();
                this.lineUpdaters.put(lb, blu);
            }
            catch (IOException ioex) {
                // empty catch block
            }
        }
    }

    synchronized void unregisterFromLineUpdates(LineBreakpoint lb) {
        BreakpointLineUpdater blu = this.lineUpdaters.remove((Object)lb);
        if (blu != null) {
            blu.detach();
        }
    }

    private static DataObject getDataObject(String url) {
        FileObject file;
        try {
            file = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException e) {
            return null;
        }
        if (file == null) {
            return null;
        }
        try {
            return DataObject.find((FileObject)file);
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
    }

    private static class BreakpointLineUpdater
    implements PropertyChangeListener {
        private LineBreakpoint lb;
        private DataObject dataObject;
        private Line line;
        private boolean updatingLine = false;

        public BreakpointLineUpdater(LineBreakpoint lb, DataObject dataObject) {
            this.lb = lb;
            this.dataObject = dataObject;
        }

        public synchronized void attach() throws IOException {
            LineCookie lc = (LineCookie)this.dataObject.getCookie(LineCookie.class);
            if (lc == null) {
                return;
            }
            this.lb.addPropertyChangeListener(this);
            try {
                this.line = lc.getLineSet().getCurrent(this.lb.getLineNumber() - 1);
                this.line.addPropertyChangeListener((PropertyChangeListener)this);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }

        public synchronized void detach() {
            this.lb.removePropertyChangeListener(this);
            if (this.line != null) {
                this.line.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void update() {
            this.updatingLine = true;
            try {
                this.lb.setLineNumberNoOld(this.line.getLineNumber() + 1);
            }
            finally {
                this.updatingLine = false;
            }
        }

        @Override
        public synchronized void propertyChange(PropertyChangeEvent evt) {
            LineCookie lc;
            if ("lineNumber".equals(evt.getPropertyName()) && this.line == evt.getSource()) {
                this.update();
                return;
            }
            if (!this.updatingLine && "lineNumber".equals(evt.getPropertyName())) {
                this.line.removePropertyChangeListener((PropertyChangeListener)this);
                if (this.dataObject == null) {
                    return;
                }
                lc = (LineCookie)this.dataObject.getCookie(LineCookie.class);
                try {
                    this.line = lc.getLineSet().getCurrent(this.lb.getLineNumber() - 1);
                    this.line.addPropertyChangeListener((PropertyChangeListener)this);
                }
                catch (IndexOutOfBoundsException ioobex) {
                    this.line = null;
                }
            }
            if ("url".equals(evt.getPropertyName())) {
                this.line.removePropertyChangeListener((PropertyChangeListener)this);
                this.dataObject = LineTranslations.getDataObject(this.lb.getURL());
                if (this.dataObject == null) {
                    return;
                }
                lc = (LineCookie)this.dataObject.getCookie(LineCookie.class);
                try {
                    this.line = lc.getLineSet().getCurrent(this.lb.getLineNumber() - 1);
                    this.line.addPropertyChangeListener((PropertyChangeListener)this);
                }
                catch (IndexOutOfBoundsException ioobex) {
                    this.line = null;
                }
            }
        }
    }

    private class ChangedFilesListener
    implements ChangeListener {
        private ChangedFilesListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent e) {
            HashSet newDOs = new HashSet(DataObject.getRegistry().getModifiedSet());
            LineTranslations lineTranslations = LineTranslations.this;
            synchronized (lineTranslations) {
                for (Registry r : LineTranslations.this.timeStampToRegistry.values()) {
                    for (DataObject dobj : newDOs) {
                        r.registerIfNotThere(dobj);
                    }
                }
            }
        }
    }

    private static class Registry {
        private Map<DataObject, Line.Set> dataObjectToLineSet = new HashMap<DataObject, Line.Set>();

        private Registry() {
        }

        synchronized void register(DataObject dataObject) {
            LineCookie lc = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (lc == null) {
                return;
            }
            this.dataObjectToLineSet.put(dataObject, lc.getLineSet());
        }

        synchronized void registerIfNotThere(DataObject dataObject) {
            if (!this.dataObjectToLineSet.containsKey(dataObject)) {
                this.register(dataObject);
            }
        }

        synchronized Line.Set getLineSet(DataObject dataObject) {
            return this.dataObjectToLineSet.get(dataObject);
        }
    }
}

