/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.util.Set;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.JoinTokenList;
import org.netbeans.lib.lexer.LanguageManager;
import org.netbeans.lib.lexer.LanguageOperation;
import org.netbeans.lib.lexer.LexerApiPackageAccessor;
import org.netbeans.lib.lexer.LexerSpiPackageAccessor;
import org.netbeans.lib.lexer.TokenIdImpl;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.TokenOrEmbedding;
import org.netbeans.lib.lexer.inc.MutableTokenList;
import org.netbeans.lib.lexer.inc.SnapshotTokenList;
import org.netbeans.lib.lexer.inc.TokenHierarchyEventInfo;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.TextToken;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;

public final class LexerUtilsConstants {
    public static final int MAX_FLY_SEQUENCE_LENGTH = 5;
    public static final int MOD_COUNT_IMMUTABLE_INPUT = -1;
    public static final int MOD_COUNT_REMOVED = -2;
    public static final int MAX_CACHED_TOKEN_LENGTH = 200;
    public static final short CACHE_TOKEN_TO_STRING_THRESHOLD = 900;
    public static final short INPUT_TEXT_STRING_THRESHOLD = 300;
    public static final short TOKEN_LENGTH_STRING_CREATION_FACTOR = 50;
    public static final int READER_TEXT_BUFFER_SIZE = 4096;
    public static final AbstractToken<?> SKIP_TOKEN = new TextToken<TokenIdImpl>(new TokenIdImpl("skip-token-id; special id of TokenFactory.SKIP_TOKEN;  It should never be part of token sequence", 0, null), "");
    public static final int MOD_COUNT_EMBEDDED_INITIAL = -3;

    public static void tokenLengthZeroOrNegative(int tokenLength) {
        if (tokenLength == 0) {
            throw new IllegalArgumentException("Tokens with zero length are not supported by the framework. Fix the lexer.");
        }
        throw new IllegalArgumentException("Negative token length " + tokenLength);
    }

    public static void throwFlyTokenProhibited() {
        throw new IllegalStateException("Flyweight token created but prohibited. Lexer needs to check lexerInput.isFlyTokenAllowed().");
    }

    public static void throwBranchTokenFlyProhibited(AbstractToken token) {
        throw new IllegalStateException("Language embedding cannot be created for flyweight token=" + token + "\nFix the lexer to not create flyweight token instance when" + " language embedding exists for the token.");
    }

    public static void checkValidBackup(int count, int maxCount) {
        if (count > maxCount) {
            throw new IndexOutOfBoundsException("Cannot backup " + count + " characters. Maximum: " + maxCount + '.');
        }
    }

    public static <T extends TokenId> Language<T> innerLanguage(LanguagePath languagePath) {
        Language<?> l = languagePath.innerLanguage();
        return l;
    }

    public static <T extends TokenId> LanguageHierarchy<T> innerLanguageHierarchy(LanguagePath languagePath) {
        Language<T> language = LexerUtilsConstants.innerLanguage(languagePath);
        return LexerApiPackageAccessor.get().languageHierarchy(language);
    }

    public static <T extends TokenId> LanguageOperation<T> innerLanguageOperation(LanguagePath languagePath) {
        Language<T> language = LexerUtilsConstants.innerLanguage(languagePath);
        return LexerApiPackageAccessor.get().languageOperation(language);
    }

    public static <T extends TokenId> LanguageEmbedding<?> findEmbedding(LanguageHierarchy<T> languageHierarchy, AbstractToken<T> token, LanguagePath languagePath, InputAttributes inputAttributes) {
        LanguageEmbedding<?> embedding = LexerSpiPackageAccessor.get().embedding(languageHierarchy, token, languagePath, inputAttributes);
        if (embedding == null) {
            embedding = LanguageManager.getInstance().findLanguageEmbedding(token, languagePath, inputAttributes);
        }
        return embedding;
    }

    public static int maxLanguagePathSize(Set<LanguagePath> paths) {
        int maxPathSize = 0;
        for (LanguagePath lp : paths) {
            maxPathSize = Math.max(lp.size(), maxPathSize);
        }
        return maxPathSize;
    }

    public static int[] tokenIndexLazyTokenCreation(TokenList<?> tokenList, int offset) {
        int prevTokenOffset;
        int tokenCount = tokenList.tokenCountCurrent();
        if (tokenCount == 0) {
            if (tokenList.tokenOrEmbedding(0) == null) {
                return new int[]{-1, 0};
            }
            tokenCount = tokenList.tokenCountCurrent();
        }
        if (offset > (prevTokenOffset = tokenList.tokenOffset(tokenCount - 1))) {
            int tokenLength = tokenList.tokenOrEmbedding(tokenCount - 1).token().length();
            while (offset >= prevTokenOffset + tokenLength) {
                TokenOrEmbedding<?> tokenOrEmbedding = tokenList.tokenOrEmbedding(tokenCount);
                if (tokenOrEmbedding != null) {
                    AbstractToken<?> t = tokenOrEmbedding.token();
                    prevTokenOffset = t.isFlyweight() ? (prevTokenOffset += tokenLength) : tokenList.tokenOffset(tokenCount);
                    tokenLength = t.length();
                    ++tokenCount;
                    continue;
                }
                return new int[]{tokenCount, prevTokenOffset + tokenLength};
            }
            return new int[]{tokenCount - 1, prevTokenOffset};
        }
        return LexerUtilsConstants.tokenIndexBinSearch(tokenList, offset, tokenCount);
    }

    public static int[] tokenIndexBinSearch(TokenList<?> tokenList, int offset, int tokenCount) {
        int low = 0;
        int high = tokenCount - 1;
        int mid = -1;
        int midStartOffset = -1;
        while (low <= high) {
            mid = low + high >>> 1;
            midStartOffset = tokenList.tokenOffset(mid);
            if (midStartOffset < offset) {
                low = mid + 1;
                continue;
            }
            if (midStartOffset > offset) {
                high = mid - 1;
                continue;
            }
            return new int[]{mid, midStartOffset};
        }
        if (high >= 0) {
            if (low == tokenCount) {
                AbstractToken<?> t = tokenList.tokenOrEmbedding(high).token();
                if (offset >= midStartOffset + t.length()) {
                    midStartOffset += t.length();
                } else if (mid != high) {
                    midStartOffset = tokenList.tokenOffset(high);
                }
            } else if (mid != high) {
                midStartOffset = tokenList.tokenOffset(high);
            }
        } else {
            if (tokenCount == 0) {
                return new int[]{-1, 0};
            }
            high = 0;
        }
        return new int[]{++high, midStartOffset};
    }

    public static int updatedStartOffset(EmbeddedTokenList<?> etl, TokenHierarchyEventInfo eventInfo) {
        etl.embeddingContainer().updateStatusUnsync();
        int startOffset = etl.startOffset();
        return etl.isRemoved() && startOffset > eventInfo.modOffset() ? Math.max(startOffset - eventInfo.removedLength(), eventInfo.modOffset()) : startOffset;
    }

    public static <T extends TokenId> StringBuilder appendTokenList(StringBuilder sb, TokenList<T> tokenList) {
        return LexerUtilsConstants.appendTokenList(sb, tokenList, -1, 0, Integer.MAX_VALUE, true, 0, true);
    }

    public static <T extends TokenId> StringBuilder appendTokenListIndented(StringBuilder sb, TokenList<T> tokenList, int indent) {
        return LexerUtilsConstants.appendTokenList(sb, tokenList, -1, 0, Integer.MAX_VALUE, false, indent, true);
    }

    public static <T extends TokenId> StringBuilder appendTokenList(StringBuilder sb, TokenList<T> tokenList, int currentIndex, int startIndex, int endIndex, boolean appendEmbedded, int indent, boolean dumpTokenText) {
        if (sb == null) {
            sb = new StringBuilder(200);
        }
        TokenHierarchy<?> tokenHierarchy = tokenList instanceof SnapshotTokenList ? ((SnapshotTokenList)tokenList).snapshot().tokenHierarchy() : null;
        endIndex = Math.min(tokenList.tokenCountCurrent(), endIndex);
        int digitCount = ArrayUtilities.digitCount((int)(endIndex - 1));
        for (int i = Math.max(startIndex, 0); i < endIndex; ++i) {
            ArrayUtilities.appendSpaces((StringBuilder)sb, (int)indent);
            sb.append(i == currentIndex ? (char)'*' : 'T');
            ArrayUtilities.appendBracketedIndex((StringBuilder)sb, (int)i, (int)digitCount);
            LexerUtilsConstants.appendTokenInfo(sb, tokenList, i, tokenHierarchy, appendEmbedded, indent, dumpTokenText);
            sb.append('\n');
        }
        return sb;
    }

    public static boolean statesEqual(Object state1, Object state2) {
        return state1 == null && state2 == null || state1 != null && state1.equals(state2);
    }

    public static String idToString(TokenId id) {
        return id.name() + '[' + id.ordinal() + ']';
    }

    public static <T extends TokenId> void appendTokenInfo(StringBuilder sb, TokenList<T> tokenList, int index, TokenHierarchy tokenHierarchy, boolean appendEmbedded, int indent, boolean dumpTokenText) {
        try {
            LexerUtilsConstants.appendTokenInfo(sb, tokenList.tokenOrEmbedding(index), tokenList.lookahead(index), tokenList.state(index), tokenHierarchy, appendEmbedded, indent, dumpTokenText);
        }
        catch (IndexOutOfBoundsException e) {
            tokenList.lookahead(index);
            System.err.println("Index=" + index + ", tokenCount=" + tokenList.tokenCount() + ", cls=" + tokenList.getClass());
            throw e;
        }
    }

    public static <T extends TokenId> void appendTokenInfo(StringBuilder sb, TokenOrEmbedding<T> tokenOrEmbedding, int lookahead, Object state, TokenHierarchy<?> tokenHierarchy, boolean appendEmbedded, int indent, boolean dumpTokenText) {
        if (tokenOrEmbedding == null) {
            sb.append("<NULL-TOKEN>");
        } else {
            EmbeddingContainer<T> ec = tokenOrEmbedding.embedding();
            AbstractToken<T> token = tokenOrEmbedding.token();
            token.dumpInfo(sb, tokenHierarchy, dumpTokenText, true, indent);
            LexerUtilsConstants.appendLAState(sb, lookahead, state);
            sb.append(", ");
            LexerUtilsConstants.appendIdentityHashCode(sb, token);
            if (ec != null) {
                indent += 4;
                sb.append("; EC-");
                LexerUtilsConstants.appendIdentityHashCode(sb, ec);
                EmbeddedTokenList<?> etl = ec.firstEmbeddedTokenList();
                int index = 0;
                while (etl != null) {
                    sb.append('\n');
                    ArrayUtilities.appendSpaces((StringBuilder)sb, (int)indent);
                    sb.append("Embedding[").append(index).append("]: \"").append(etl.languagePath().mimePath()).append("\"\n");
                    if (appendEmbedded) {
                        LexerUtilsConstants.appendTokenList(sb, etl, -1, 0, Integer.MAX_VALUE, appendEmbedded, indent, true);
                    }
                    etl = etl.nextEmbeddedTokenList();
                    ++index;
                }
            }
        }
    }

    public static void appendIdentityHashCode(StringBuilder sb, Object o) {
        sb.append("IHC=");
        sb.append(System.identityHashCode(o));
    }

    public static void appendLAState(StringBuilder sb, TokenList<?> tokenList, int index) {
        LexerUtilsConstants.appendLAState(sb, tokenList.lookahead(index), tokenList.state(index));
    }

    public static void appendLAState(StringBuilder sb, int lookahead, Object state) {
        if (lookahead > 0) {
            sb.append(", la=");
            sb.append(lookahead);
        }
        if (state != null) {
            sb.append(", st=");
            sb.append(state);
        }
    }

    public static String checkConsistencyTokenList(TokenList<?> tokenList, boolean checkEmbedded) {
        int startOffset;
        int tokenCountCurrent = tokenList.tokenCountCurrent();
        boolean continuous = tokenList.isContinuous();
        if (tokenList instanceof EmbeddedTokenList) {
            ((EmbeddedTokenList)tokenList).embeddingContainer().updateStatus();
        }
        int lastOffset = startOffset = tokenList.startOffset();
        for (int i = 0; i < tokenCountCurrent; ++i) {
            int offset;
            TokenOrEmbedding<?> tokenOrEmbedding = tokenList.tokenOrEmbedding(i);
            if (tokenOrEmbedding == null) {
                tokenOrEmbedding = tokenList.tokenOrEmbedding(i);
                return LexerUtilsConstants.dumpContext("Null token", tokenList, i);
            }
            AbstractToken<?> token = tokenOrEmbedding.token();
            if (token.isRemoved()) {
                return LexerUtilsConstants.dumpContext("Token is removed", tokenList, i);
            }
            if (i == 0 && continuous && tokenCountCurrent > 0 && !token.isFlyweight() && token.offset(null) != tokenList.startOffset()) {
                return LexerUtilsConstants.dumpContext("firstToken.offset()=" + token.offset(null) + " != tokenList.startOffset()=" + tokenList.startOffset(), tokenList, i);
            }
            if (!token.isFlyweight() && token.tokenList() != tokenList && !(tokenList instanceof JoinTokenList)) {
                return LexerUtilsConstants.dumpContext("Invalid token.tokenList()=" + token.tokenList(), tokenList, i);
            }
            if (token.text() == null) {
                return LexerUtilsConstants.dumpContext("Null token.text()", tokenList, i);
            }
            if (((Object)token.text()).toString() == null) {
                return LexerUtilsConstants.dumpContext("Null token.text().toString()", tokenList, i);
            }
            int n = offset = token.isFlyweight() ? lastOffset : token.offset(null);
            if (offset < 0) {
                return LexerUtilsConstants.dumpContext("Token offset=" + offset + " < 0", tokenList, i);
            }
            if (offset < lastOffset) {
                return LexerUtilsConstants.dumpContext("Token offset=" + offset + " < lastOffset=" + lastOffset, tokenList, i);
            }
            if (offset > lastOffset && continuous) {
                return LexerUtilsConstants.dumpContext("Gap between tokens; offset=" + offset + ", lastOffset=" + lastOffset, tokenList, i);
            }
            lastOffset = offset + token.length();
            EmbeddingContainer<?> ec = tokenOrEmbedding.embedding();
            if (ec == null || !checkEmbedded) continue;
            for (EmbeddedTokenList<?> etl = ec.firstEmbeddedTokenList(); etl != null; etl = etl.nextEmbeddedTokenList()) {
                String error = LexerUtilsConstants.checkConsistencyTokenList(etl, checkEmbedded);
                if (error == null) continue;
                return error;
            }
        }
        if (tokenList instanceof MutableTokenList && ((MutableTokenList)tokenList).isFullyLexed()) {
            int endOffset = tokenList.endOffset();
            if (startOffset != endOffset && tokenCountCurrent == 0) {
                return LexerUtilsConstants.dumpContext("Non-empty token list does not contain any tokens", tokenList, 0);
            }
            if (continuous && lastOffset != endOffset) {
                return LexerUtilsConstants.dumpContext("lastOffset=" + lastOffset + " != endOffset=" + endOffset, tokenList, tokenCountCurrent);
            }
        }
        return null;
    }

    private static String dumpContext(String msg, TokenList<?> tokenList, int index) {
        StringBuilder sb = new StringBuilder();
        sb.append(msg);
        sb.append(" at index=");
        sb.append(index);
        sb.append(" of tokens of language-path ");
        sb.append(tokenList.languagePath().mimePath());
        sb.append(", ").append(tokenList.getClass());
        sb.append('\n');
        LexerUtilsConstants.appendTokenList(sb, tokenList, index, index - 2, index + 3, false, 0, true);
        return sb.toString();
    }

    private LexerUtilsConstants() {
    }
}

