/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.actions;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.spi.actions.ContextAction;
import org.netbeans.spi.project.ProjectConfiguration;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;

public abstract class AntAction
extends ContextAction<Node> {
    final String command;

    AntAction(String aName, String comm) {
        super(Node.class);
        this.putValue("Name", aName);
        this.command = comm;
    }

    public void actionPerformed(Collection<? extends Node> nodes) {
        Node[] n = nodes.toArray(new Node[nodes.size()]);
        this.performAction(n);
    }

    protected void performAction(Node[] activatedNodes) {
        final HashMap<J2MEProject, String> todo = new HashMap<J2MEProject, String>();
        for (Node node : activatedNodes) {
            J2MEProject project = (J2MEProject)node.getLookup().lookup(J2MEProject.class);
            String tobuild = (String)todo.get(project);
            if (tobuild == null) {
                tobuild = new String();
                todo.put(project, tobuild);
            }
            String conf = ((ProjectConfiguration)node.getLookup().lookup(ProjectConfiguration.class)).getDisplayName();
            String comma = tobuild == null || tobuild.length() == 0 ? "" : ",";
            tobuild = "DefaultConfiguration".equals(conf) ? " " + comma + tobuild : tobuild + comma + conf;
            todo.put(project, tobuild);
        }
        Runnable action = new Runnable(){

            @Override
            public void run() {
                for (Map.Entry entry : todo.entrySet()) {
                    String[] targetNames = new String[]{AntAction.this.command};
                    Properties props = new Properties();
                    props.put("selected.configurations", entry.getValue());
                    try {
                        ActionUtils.runTarget((FileObject)((J2MEProject)entry.getKey()).getProjectDirectory().getFileObject("build.xml"), (String[])targetNames, (Properties)props);
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
            }
        };
        action.run();
    }
}

