/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.shell;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.javacard.shell.ShellException;
import org.openide.util.NbBundle;

final class APDUParser {
    private final String text;
    final Pattern SPLIT = Pattern.compile("([a-zA-Z_0-9\\\\]*)\\s*", 40);
    final Pattern UNICODE_SPLIT = Pattern.compile("\\\\u(\\p{XDigit}{4}+)");
    final Pattern NUMBER = Pattern.compile("[0-9]*");
    final Pattern OCTAL = Pattern.compile("0[0-9]*");
    final Pattern HEX = Pattern.compile("0x[0-9A-F]++", 2);

    APDUParser(String text) {
        this.text = text;
    }

    final Matcher matcher() {
        return this.SPLIT.matcher(this.text);
    }

    public byte[] bytes() throws ShellException {
        ArrayList<Byte> bytes = new ArrayList<Byte>(20);
        Matcher m = this.matcher();
        while (m.find()) {
            String s;
            if (m.groupCount() != 1 || (s = m.group(1)) == null || "".equals(s)) continue;
            this.tokenize(s, bytes);
        }
        byte[] result = new byte[bytes.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Byte)bytes.get(i);
        }
        return result;
    }

    private void tokenize(String s, List<Byte> result) throws ShellException {
        if (this.HEX.matcher(s).matches()) {
            result.add(this.parseHex(s));
        } else if (this.NUMBER.matcher(s).matches()) {
            if (this.OCTAL.matcher(s).matches()) {
                result.add(this.parseOctal(s));
            } else {
                result.add(this.parseInteger(s));
            }
        } else if (s.length() == 1) {
            char c = s.charAt(0);
            result.add(this.parseChar(s, c));
        } else {
            this.parseString(s, result);
        }
    }

    private void parseString(String s, List<Byte> result) throws ShellException {
        int len = s.length();
        Matcher um = this.UNICODE_SPLIT.matcher(s);
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                if (um.find(i)) {
                    String rawHex = um.group(1);
                    result.add(this.parseRawHex(rawHex));
                    i += 6;
                    continue;
                }
                result.add(this.parseChar(s, c));
                continue;
            }
            result.add(this.parseChar(s, c));
        }
    }

    private byte parseOctal(String s) throws ShellException {
        int result = Integer.parseInt(s.substring(1), 8);
        this.checkRange(s, result);
        return (byte)result;
    }

    private byte parseHex(String s) throws ShellException {
        return this.parseRawHex(s.substring(2));
    }

    private byte parseRawHex(String s) throws ShellException {
        int result = Integer.parseInt(s, 16);
        this.checkRange(s, result);
        return (byte)result;
    }

    private byte parseInteger(String s) throws ShellException {
        int result = Integer.parseInt(s);
        this.checkRange(s, result);
        return (byte)result;
    }

    private byte parseChar(String s, char c) throws ShellException {
        assert (!Character.isWhitespace(c)) : "Whitespace parsed as char in '" + s + "'";
        this.checkRange(s, c);
        return (byte)c;
    }

    private void checkRange(String s, int result) throws ShellException {
        if (result > 255) {
            this.tooBig(s, result);
        } else if (result < 0) {
            this.tooSmall(s, result);
        }
    }

    private void tooBig(String s, int result) throws ShellException {
        throw new ShellException(NbBundle.getMessage(APDUParser.class, (String)"ERR_VAL_TOO_LARGE", (Object)s, (Object)result));
    }

    private void tooSmall(String s, int result) throws ShellException {
        throw new ShellException(NbBundle.getMessage(APDUParser.class, (String)"ERR_VAL_TOO_SMALL", (Object)s, (Object)result));
    }
}

