/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.services.strikeiron.ui;

import com.strikeiron.search.AUTHENTICATIONSTYLE;
import com.strikeiron.search.ArrayOfMarketPlaceService;
import com.strikeiron.search.MarketPlaceService;
import com.strikeiron.search.SORTBY;
import com.strikeiron.search.SearchOutPut;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableModel;
import javax.xml.namespace.QName;
import org.netbeans.modules.websvc.saas.services.strikeiron.StrikeIronSearch;
import org.netbeans.modules.websvc.saas.services.strikeiron.ui.SiServiceData;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlServiceData;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlServiceProxyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ServiceTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 1L;
    public static final QName SI_SEARCH_SERVICE = new QName("http://www.strikeiron.com", "SISearchService");
    public static final String STRIKE_IRON_HOME = WsdlServiceProxyDescriptor.WEBSVC_HOME + "/strikeiron";
    public static final String SEARCH_PROPERTIES = "search.properties";
    public static final String WSDL_LOCATION = "wsdlLocation";
    public static final String USERID = "userId";
    public static final String PASSWORD = "password";
    private static final String DEFAULT_USERID = "Sun_Search@strikeiron.com";
    private static final String DEFAULT_PASSWORD = "SearchSun.01";
    private static final String DEFAULT_URL = "http://ws.strikeiron.com/Searchsunsi01.StrikeIron/MarketplaceSearch?WSDL";
    static final int COLUMN_WS_NAME = 1;
    static final int COLUMN_SELECT = 0;
    private String wsdlLocation;
    private String userId;
    private String password;
    private AUTHENTICATIONSTYLE authenticationStyle = AUTHENTICATIONSTYLE.SIMPLE_PARAM;
    private Boolean useCustomWSDL = Boolean.TRUE;
    private SORTBY sortBy = SORTBY.NAME;
    private List<? extends WsdlServiceData> result;
    private String status;
    private boolean warnsOrErrors = false;
    private Set<Integer> selectedRows = new HashSet<Integer>();
    private RequestProcessor.Task searchTask;
    List<SearchListener> listeners = new ArrayList<SearchListener>();

    public ServiceTableModel() {
        this.init();
    }

    private void init() {
        Properties p = new Properties();
        File propFile = new File(STRIKE_IRON_HOME, SEARCH_PROPERTIES);
        if (propFile.isFile()) {
            try {
                p.load(new FileInputStream(propFile));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.wsdlLocation = p.getProperty(WSDL_LOCATION);
        if (this.wsdlLocation == null) {
            this.wsdlLocation = DEFAULT_URL;
        }
        this.userId = p.getProperty(USERID);
        if (this.userId == null) {
            this.userId = DEFAULT_USERID;
        }
        this.password = p.getProperty(PASSWORD);
        if (this.password == null) {
            this.password = DEFAULT_PASSWORD;
        }
    }

    public AUTHENTICATIONSTYLE getAuthenticationStyle() {
        return this.authenticationStyle;
    }

    public void setAuthenticationStyle(AUTHENTICATIONSTYLE v) {
        this.authenticationStyle = v;
    }

    public SORTBY getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(SORTBY v) {
        this.sortBy = v;
    }

    public WsdlServiceData getService(int row) {
        return this.result.get(row);
    }

    public void addEventListener(SearchListener listener) {
        this.listeners.add(listener);
    }

    public void removeEventListener(SearchListener listener) {
        this.listeners.remove(listener);
    }

    private void fireSearchEnded() {
        for (SearchListener l : this.listeners) {
            l.searchCompleted(new ChangeEvent(this));
        }
    }

    private void fireServiceSelectionChanged() {
        for (SearchListener l : this.listeners) {
            l.serviceSelectionChanged(new ChangeEvent(this));
        }
    }

    public void doSearch(final String searchTerm) {
        this.cancelSearch();
        this.searchTask = RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                ServiceTableModel.this.callSearch(searchTerm);
            }
        });
    }

    public boolean cancelSearch() {
        if (this.searchTask != null) {
            boolean cancelled = this.searchTask.cancel();
            this.searchTask = null;
            this.fireSearchEnded();
            return cancelled;
        }
        return true;
    }

    public int getSelectedCount() {
        return this.selectedRows.size();
    }

    public Set<? extends WsdlServiceData> getSelectedServices() {
        HashSet<WsdlServiceData> selection = new HashSet<WsdlServiceData>();
        for (int i : this.selectedRows) {
            selection.add(this.result.get(i));
        }
        return selection;
    }

    public String getStatusMessage() {
        return this.status;
    }

    public boolean hasWarnsOrErrors() {
        return this.warnsOrErrors;
    }

    private List<? extends WsdlServiceData> convertResult(List<MarketPlaceService> rawResult) {
        ArrayList<SiServiceData> converted = new ArrayList<SiServiceData>();
        if (rawResult != null) {
            for (MarketPlaceService service : rawResult) {
                SiServiceData raw = new SiServiceData(service);
                converted.add(raw);
            }
        }
        return converted;
    }

    private void clearStatusMessage() {
        this.status = "";
        this.warnsOrErrors = false;
    }

    private void setErrorMessage(String msg) {
        this.status = msg;
        this.warnsOrErrors = true;
    }

    private void setStatusMessage(String msg) {
        this.status = msg;
        this.warnsOrErrors = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callSearch(String searchTerm) {
        this.clearStatusMessage();
        this.selectedRows = new HashSet<Integer>();
        this.result = new ArrayList<WsdlServiceData>();
        this.fireTableDataChanged();
        try {
            SearchOutPut output = StrikeIronSearch.search(this.userId, this.password, searchTerm, this.sortBy, this.useCustomWSDL, this.authenticationStyle);
            if (output != null) {
                ArrayOfMarketPlaceService amps = output.getStrikeIronWebServices();
                if (amps != null) {
                    this.result = this.convertResult(output.getStrikeIronWebServices().getMarketPlaceService());
                }
                if (output.getServiceStatus() != null) {
                    String msg = output.getServiceStatus().getStatusDescription();
                    if (msg == null || msg.trim().length() == 0 || msg.startsWith("Found")) {
                        this.setStatusMessage(NbBundle.getMessage(ServiceTableModel.class, (String)"MSG_Found", (Object)this.result.size()));
                    } else {
                        this.setErrorMessage(NbBundle.getMessage(ServiceTableModel.class, (String)"MSG_ERROR", (Object)msg));
                    }
                }
            }
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            this.setErrorMessage(ex.getLocalizedMessage());
            ex.printStackTrace();
        }
        finally {
            this.fireSearchEnded();
            this.searchTask = null;
        }
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    public Class getColumnClass(int column) {
        if (column == 0) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 1: {
                return NbBundle.getMessage(ServiceTableModel.class, (String)"LBL_ServiceName");
            }
            case 0: {
                return NbBundle.getMessage(ServiceTableModel.class, (String)"LBL_Select");
            }
        }
        throw new IllegalArgumentException("column > 1");
    }

    public boolean isSearching() {
        return this.searchTask != null && this.result == null;
    }

    @Override
    public int getRowCount() {
        if (this.isSearching()) {
            return 1;
        }
        return this.result != null ? this.result.size() : 0;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.isSearching()) {
            return NbBundle.getMessage(ServiceTableModel.class, (String)"MSG_Searching");
        }
        if (this.result == null) {
            throw new IllegalStateException("Search has not started or has no results");
        }
        WsdlServiceData mps = this.result.get(row);
        switch (column) {
            case 1: {
                return mps.getServiceName();
            }
            case 0: {
                return this.selectedRows.contains(row) || mps.isInRepository();
            }
        }
        throw new IllegalArgumentException("column = " + column);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (column == 0 && value instanceof Boolean) {
            boolean selected = (Boolean)value;
            if (selected) {
                this.selectedRows.add(row);
            } else {
                this.selectedRows.remove(row);
            }
            this.fireServiceSelectionChanged();
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        switch (column) {
            case 0: {
                return !this.getService(row).isInRepository();
            }
        }
        return false;
    }

    public static interface SearchListener
    extends EventListener {
        public void searchCompleted(ChangeEvent var1);

        public void serviceSelectionChanged(ChangeEvent var1);
    }
}

