/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.validator;

import com.sun.javacard.validator.AttributedItem;
import com.sun.javacard.validator.ErrorKey;
import com.sun.javacard.validator.Module;
import com.sun.javacard.validator.ValidValues;
import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.Manifest;

public abstract class ModuleJCRD
extends AttributedItem {
    protected static final String MAPPED_TO_CLIENT_URI = "-Mapped-To-Client-URI";
    protected static final String MAPPED_TO_DOMAIN_NAME = "-Mapped-To-Domain-Name";
    protected static final String MAPPED_TO_AUTH_CREDENTIAL = "-Mapped-To-Auth-Credential";
    protected static final String CLIENT_CREDENTIAL_AUTH_TYPE = "-Credential-Auth-Type";
    protected static final String CLIENT_CREDENTIAL_AUTH_DURATION = "-Credential-Auth-Duration";
    protected static final String MAPPED_TO_AUTH_URI = "-Mapped-To-Auth-URI";
    protected static final String[] CLIENT_MAPPING_ATTRIBUTES_LIST = new String[]{"-Mapped-To-Client-URI", "-Mapped-To-Domain-Name", "-Mapped-To-Auth-Credential", "-Credential-Auth-Type", "-Credential-Auth-Duration"};
    protected Module module;
    protected File file;
    protected Vector<String> oncardClientRoleList = new Vector();
    protected Vector<String> userRoleList = new Vector();
    protected String oncardClientsCredentialAuthType;
    protected String oncardClientsCredentialAuthDuration;
    protected Hashtable<String, Vector<String>> clientRoleMappedToClientURI = new Hashtable();
    protected Hashtable<String, Vector<String>> clientRoleMappedToDomainName = new Hashtable();
    protected Hashtable<String, Vector<String>> clientRoleMappedToAuthCredential = new Hashtable();
    protected Hashtable<String, String> clientRoleCredentialAuthType = new Hashtable();
    protected Hashtable<String, String> clientRoleCredentialAuthDuration = new Hashtable();
    protected Hashtable<String, Vector<String>> userRoleMappedToAuthURI = new Hashtable();
    protected String applicationType;
    private String runtimeDescriptorVersion;

    public ModuleJCRD(Module module, File file) {
        this.module = module;
        this.file = file;
    }

    @Override
    public void initialize() {
        if (!this.file.exists()) {
            this.addError(ErrorKey.DoesNotExists, this.file.getAbsolutePath());
            this.proceed = false;
            return;
        }
        Manifest manifest = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.file);
            manifest = new Manifest(fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            this.addError(ErrorKey.UnableToParseManifestFile, new Object[0]);
            this.proceed = false;
            return;
        }
        this.attributes = manifest.getMainAttributes();
        Object[] objectArray = this.attributes.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            this.jcrdKeyList.add(objectArray[i].toString());
        }
        this.runtimeDescriptorVersion = this.getAttributeValue("Runtime-Descriptor-Version");
        if (this.runtimeDescriptorVersion == null) {
            this.addError(ErrorKey.MissingAttribute, "Runtime-Descriptor-Version");
        }
        this.applicationType = this.getAttributeValue("Application-Type");
        if (this.applicationType == null || this.applicationType.trim().length() <= 0) {
            this.addError(ErrorKey.MissingAttribute, "Application-Type");
        }
        String string = null;
        this.oncardClientsCredentialAuthType = this.getAttributeValue("On-Card-Clients-Credential-Auth-Type", false);
        if (this.oncardClientsCredentialAuthType == null) {
            this.oncardClientsCredentialAuthType = "client-only";
        } else if (!ValidValues.isValidCredentialAuthType(this.oncardClientsCredentialAuthType)) {
            this.addError(ErrorKey.InvalidAttributeValue, this.oncardClientsCredentialAuthType, "On-Card-Clients-Credential-Auth-Type");
            this.oncardClientsCredentialAuthType = "client-only";
        }
        this.oncardClientsCredentialAuthDuration = this.getAttributeValue("On-Card-Clients-Credential-Auth-Duration", false);
        if (this.oncardClientsCredentialAuthDuration == null) {
            this.oncardClientsCredentialAuthDuration = "card-session";
        } else if (!ValidValues.isValidCredentialAuthDuration(this.oncardClientsCredentialAuthDuration)) {
            this.addError(ErrorKey.InvalidAttributeValue, this.oncardClientsCredentialAuthDuration, "On-Card-Clients-Credential-Auth-Duration");
            this.oncardClientsCredentialAuthDuration = "card-session";
        }
        string = this.getAttributeValue("On-Card-Client-Role-List");
        if (string != null) {
            this.oncardClientRoleList = this.splitNames(string);
        }
        if ((string = this.getAttributeValue("User-Role-List")) != null) {
            this.userRoleList = this.splitNames(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string2 : this.userRoleList) {
            if (!this.oncardClientRoleList.contains(string2)) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string2);
        }
        if (stringBuffer.length() > 0) {
            this.addError(ErrorKey.DuplicateRoleNames, stringBuffer);
        }
        for (String string2 : this.oncardClientRoleList) {
            string = this.getAttributeValue(string2 + MAPPED_TO_CLIENT_URI);
            if (string != null && !this.isClientRoleALreadyMapped(string2)) {
                this.clientRoleMappedToClientURI.put(string2, this.splitNames(string));
            }
            if ((string = this.getAttributeValue(string2 + MAPPED_TO_DOMAIN_NAME)) != null && !this.isClientRoleALreadyMapped(string2)) {
                this.clientRoleMappedToDomainName.put(string2, this.splitNames(string));
            }
            if ((string = this.getAttributeValue(string2 + MAPPED_TO_AUTH_CREDENTIAL)) != null && !this.isClientRoleALreadyMapped(string2)) {
                this.clientRoleMappedToAuthCredential.put(string2, this.splitNames(string));
            }
            if ((string = this.getAttributeValue(string2 + CLIENT_CREDENTIAL_AUTH_TYPE)) == null) {
                this.clientRoleCredentialAuthType.put(string2, this.oncardClientsCredentialAuthType);
            } else {
                this.clientRoleCredentialAuthType.put(string2, string);
            }
            string = this.getAttributeValue(string2 + CLIENT_CREDENTIAL_AUTH_DURATION);
            if (string == null) {
                this.clientRoleCredentialAuthDuration.put(string2, this.oncardClientsCredentialAuthDuration);
                continue;
            }
            this.clientRoleCredentialAuthDuration.put(string2, string);
        }
        for (String string2 : this.userRoleList) {
            string = this.getAttributeValue(string2 + MAPPED_TO_AUTH_URI);
            if (string == null) continue;
            this.userRoleMappedToAuthURI.put(string2, this.splitNames(string));
        }
    }

    @Override
    public void processInternal() {
        Object object;
        if (this.runtimeDescriptorVersion != null && !this.runtimeDescriptorVersion.equals("3.0")) {
            this.addError(ErrorKey.InvalidVersion, this.runtimeDescriptorVersion);
        }
        if (this.applicationType != null && !ValidValues.isValidAppType(this.applicationType)) {
            this.addError(ErrorKey.InvliadAttributeApplicationType, this.applicationType);
        }
        if (this.applicationType.equals("classic-applet")) {
            return;
        }
        this.verifyClientRolesMapping();
        this.verifyUserRolesMapping();
        for (String string : this.jcrdKeyList) {
            if (string.endsWith(MAPPED_TO_AUTH_URI)) {
                object = string.substring(0, string.indexOf(MAPPED_TO_AUTH_URI));
                if (this.userRoleList.contains(object)) continue;
                this.addError(ErrorKey.RoleOfMappingAttributeIsNotListed, string, "User-Role-List");
                continue;
            }
            for (String string2 : CLIENT_MAPPING_ATTRIBUTES_LIST) {
                String string3;
                if (!string.endsWith(string2) || (string3 = string.substring(0, string.indexOf(string2))).equalsIgnoreCase("on-card-clients") || this.oncardClientRoleList.contains(string3)) continue;
                this.addError(ErrorKey.RoleOfMappingAttributeIsNotListed, string, "On-Card-Client-Role-List");
            }
        }
        for (String string : this.jcrdKeyList) {
            String string4;
            object = "";
            if (string.endsWith(MAPPED_TO_CLIENT_URI)) {
                object = MAPPED_TO_CLIENT_URI;
                string4 = this.getAttributeValue(string).trim();
                if (string4.equals("") || !string4.startsWith("/")) {
                    this.addError(ErrorKey.InvalidClientURI, string4);
                    continue;
                }
            } else if (string.endsWith(MAPPED_TO_DOMAIN_NAME)) {
                object = MAPPED_TO_DOMAIN_NAME;
                string4 = this.getAttributeValue(string).trim();
                if (string4.equals("") || !string4.startsWith("pd:")) {
                    this.addError(ErrorKey.InvalidProtectionDomainName, string4);
                    continue;
                }
            } else if (string.endsWith(MAPPED_TO_AUTH_CREDENTIAL)) {
                object = MAPPED_TO_AUTH_CREDENTIAL;
                string4 = this.getAttributeValue(string).trim();
                if (string4.equals("")) {
                    this.addError(ErrorKey.InvalidAuthCredential, string4);
                    continue;
                }
            } else if (string.endsWith(CLIENT_CREDENTIAL_AUTH_TYPE)) {
                object = CLIENT_CREDENTIAL_AUTH_TYPE;
                string4 = this.getAttributeValue(string);
                if (!ValidValues.isValidCredentialAuthType(string4)) {
                    this.addError(ErrorKey.InvalidAttributeValue, string4, string);
                }
            } else if (string.endsWith(CLIENT_CREDENTIAL_AUTH_DURATION)) {
                object = CLIENT_CREDENTIAL_AUTH_DURATION;
                string4 = this.getAttributeValue(string);
                if (!ValidValues.isValidCredentialAuthDuration(string4)) {
                    this.addError(ErrorKey.InvalidAttributeValue, string4, string);
                }
            } else if (string.endsWith(MAPPED_TO_AUTH_URI)) {
                object = MAPPED_TO_AUTH_URI;
            }
            if (((String)object).equals("")) continue;
            string4 = string.substring(0, ((String)object).length());
            if (((String)object).equals(MAPPED_TO_AUTH_URI)) {
                if (this.userRoleList.contains(string4)) continue;
                continue;
            }
            if (this.oncardClientRoleList.contains(string4)) continue;
        }
    }

    void verifyUserRolesMapping() {
        for (String string : this.userRoleList) {
            Vector<String> vector = this.userRoleMappedToAuthURI.get(string);
            if (vector == null) {
                this.addError(ErrorKey.UserRoleNotMappedToAuthURI, string);
                continue;
            }
            for (String string2 : vector) {
                this.validateAuthenticatorURI(string2, string);
            }
        }
    }

    boolean isClientRoleALreadyMapped(String string) {
        if (this.clientRoleMappedToClientURI.containsKey(string) || this.clientRoleMappedToDomainName.containsKey(string) || this.clientRoleMappedToAuthCredential.containsKey(string)) {
            this.addError(ErrorKey.ClientRoleMappedMoreThanOnce, string);
            return true;
        }
        if (this.clientRoleMappedToDomainName.containsKey(string)) {
            this.addError(ErrorKey.ClientRoleMappedMoreThanOnce, string);
            return true;
        }
        return false;
    }

    void verifyClientRolesMapping() {
        for (String string : this.oncardClientRoleList) {
            if (this.jcrdKeyList.contains(string + MAPPED_TO_CLIENT_URI) || this.jcrdKeyList.contains(string + MAPPED_TO_DOMAIN_NAME) || this.jcrdKeyList.contains(string + MAPPED_TO_AUTH_CREDENTIAL)) continue;
            this.addError(ErrorKey.ClientNotMappedtoAnyAttributes, string);
        }
    }

    void validateAuthenticatorURI(String string, String string2) {
        String string3 = "sio:///standard/auth/holder/global/";
        String string4 = "sio:///standard/auth/holder/session/";
        String string5 = "sio:///standard/auth/user/session/";
        int n = 0;
        if (string.startsWith(string3)) {
            n = string3.length();
        } else if (string.startsWith(string4)) {
            n = string4.length();
        } else if (string.startsWith(string5)) {
            n = string5.length();
        } else {
            this.addError(ErrorKey.InvalidAuthURIStart, string);
            return;
        }
        String string6 = string.substring(n);
        int n2 = string6.lastIndexOf("/");
        if (n2 == -1) {
            this.addError(ErrorKey.InvalidAuthURIMissingScheme, string);
            return;
        }
        String string7 = string6.substring(n2 + 1);
        if (string7.trim().equals("")) {
            this.addError(ErrorKey.InvalidAuthURIMissingScheme, string);
            return;
        }
        String string8 = string6.substring(0, n2);
        if ((n2 = string8.lastIndexOf("/")) > -1) {
            string8 = string8.substring(n2 + 1);
        }
    }

    @Override
    public String getItemDisplayName() {
        return "JCRD";
    }

    public Vector<String> getOncardClientRoleList() {
        return this.oncardClientRoleList;
    }

    public Vector<String> getUserRoleList() {
        return this.userRoleList;
    }

    public Hashtable<String, Vector<String>> getUserRoleAuthURIMappings() {
        return this.userRoleMappedToAuthURI;
    }
}

