/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.gsf;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.css.lexer.api.CssTokenId;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.filesystems.FileObject;

public class CssDeclarationFinder
implements DeclarationFinder {
    private static final Pattern URI_PATTERN = Pattern.compile("url\\(\\s*(.*)\\s*\\)");

    public DeclarationFinder.DeclarationLocation findDeclaration(ParserResult info, int caretOffset) {
        Matcher m;
        TokenSequence ts = LexerUtils.getJoinedTokenSequence((Document)info.getSnapshot().getSource().getDocument(true), (int)caretOffset, CssTokenId.language());
        Token valueToken = ts.token();
        String valueText = ((Object)valueToken.text()).toString();
        if (valueToken.id() == CssTokenId.URI && (m = URI_PATTERN.matcher(valueToken.text())).matches()) {
            int groupIndex = 1;
            valueText = m.group(groupIndex);
        }
        valueText = WebUtils.unquotedValue((CharSequence)valueText);
        FileObject resolved = WebUtils.resolve((FileObject)info.getSnapshot().getSource().getFileObject(), (String)valueText);
        if (resolved != null) {
            return new DeclarationFinder.DeclarationLocation(resolved, 0);
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    public OffsetRange getReferenceSpan(Document doc, int caretOffset) {
        TokenSequence ts = LexerUtils.getJoinedTokenSequence((Document)doc, (int)caretOffset, CssTokenId.language());
        if (ts == null) {
            return OffsetRange.NONE;
        }
        Token token = ts.token();
        int quotesDiff = WebUtils.isValueQuoted((CharSequence)((Object)ts.token().text()).toString()) ? 1 : 0;
        OffsetRange range = new OffsetRange(ts.offset() + quotesDiff, ts.offset() + ts.token().length() - quotesDiff);
        if ((token.id() == CssTokenId.STRING || token.id() == CssTokenId.URI) && ts.movePrevious() && ts.token().id() == CssTokenId.S && ts.movePrevious() && ts.token().id() == CssTokenId.IMPORT_SYM) {
            return range;
        }
        return OffsetRange.NONE;
    }
}

