/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints.introduce;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.MissingResourceException;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.PreviewableFix;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.ParseTreeVisitor;
import org.netbeans.modules.ruby.ParseTreeWalker;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.hints.introduce.DuplicateDetector;
import org.netbeans.modules.ruby.hints.introduce.InputOutputVarFinder;
import org.netbeans.modules.ruby.hints.introduce.IntroduceFieldPanel;
import org.netbeans.modules.ruby.hints.introduce.IntroduceHint;
import org.netbeans.modules.ruby.hints.introduce.IntroduceKind;
import org.netbeans.modules.ruby.hints.introduce.IntroduceMethodPanel;
import org.netbeans.modules.ruby.hints.introduce.IntroduceVariablePanel;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

class IntroduceFix
implements PreviewableFix {
    private static final boolean FORCE_COMPLETION_SPACES = Boolean.getBoolean("ruby.complete.spaces");
    private static final boolean COMMENT_NEW_ELEMENTS = !Boolean.getBoolean("ruby.create.nocomments");
    private final RubyRuleContext context;
    private final ParserResult info;
    private final OffsetRange lexRange;
    private final OffsetRange astRange;
    private final IntroduceKind kind;
    private final List<Node> nodes;
    private final BaseDocument doc;
    private int commentOffset = -1;

    IntroduceFix(RubyRuleContext context, List<Node> nodes, OffsetRange lexRange, OffsetRange astRange, IntroduceKind kind) {
        this.context = context;
        this.nodes = nodes;
        this.lexRange = lexRange;
        this.astRange = astRange;
        this.kind = kind;
        this.info = context.parserResult;
        this.doc = context.doc;
    }

    public String getKeyExt() {
        switch (this.kind) {
            case CREATE_CONSTANT: {
                return "IntroduceConstant";
            }
            case CREATE_VARIABLE: {
                return "IntroduceVariable";
            }
            case CREATE_METHOD: {
                return "IntroduceMethod";
            }
            case CREATE_FIELD: {
                return "IntroduceField";
            }
        }
        throw new IllegalStateException(this.kind.toString());
    }

    public String getDescription() {
        return NbBundle.getMessage(IntroduceHint.class, (String)("FIX_" + this.getKeyExt()));
    }

    public void implement() throws Exception {
        String s;
        String commentText;
        int offset;
        JTextComponent target;
        String name = null;
        EditList edits = this.createEdits(name);
        if (edits == null) {
            return;
        }
        Position commentPosition = edits.createPosition(this.commentOffset);
        edits.apply();
        if (commentPosition != null && commentPosition.getOffset() != -1 && (target = GsfUtilities.getPaneFor((FileObject)RubyUtils.getFileObject((Parser.Result)this.info))) != null && (offset = commentPosition.getOffset()) + (commentText = this.getCommentText()).length() <= this.doc.getLength() && commentText.equals(s = this.doc.getText(offset, commentText.length()))) {
            target.select(offset, offset + commentText.length());
        }
    }

    private String getCommentText() throws MissingResourceException {
        return NbBundle.getMessage(IntroduceHint.class, (String)"DefaultMethodComment");
    }

    public EditList getEditList() {
        String name = "new_name";
        try {
            return this.createEdits(name);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private EditList createEdits(String name) throws Exception {
        String guessedName = AstUtilities.guessName((Parser.Result)this.info, (OffsetRange)this.lexRange, (OffsetRange)this.astRange);
        RubyIndex index = RubyIndex.get((Parser.Result)this.info);
        AstPath startPath = new AstPath(AstUtilities.getRoot((Parser.Result)this.info), this.astRange.getStart());
        List<Object> duplicates = null;
        if (name == null) {
            switch (this.kind) {
                case CREATE_CONSTANT: 
                case CREATE_VARIABLE: {
                    Node startNode = this.nodes.get(0);
                    Node endNode = this.nodes.get(this.nodes.size() - 1);
                    Node top = AstUtilities.getRoot((Parser.Result)this.info);
                    int numDuplicates = 1;
                    if (this.kind == IntroduceKind.CREATE_CONSTANT) {
                        ClassNode cls = AstUtilities.findClass((AstPath)startPath);
                        if (cls != null) {
                            top = cls;
                        }
                        numDuplicates = (duplicates = DuplicateDetector.findDuplicates(this.info, this.doc, top, this.nodes, startNode, endNode)) == null ? 1 : duplicates.size();
                    }
                    JButton btnOk = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Ok"));
                    JButton btnCancel = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Cancel"));
                    Set takenNames = this.kind == IntroduceKind.CREATE_CONSTANT ? AstUtilities.getUsedConstants((RubyIndex)index, (AstPath)startPath) : AstUtilities.getUsedLocalNames((AstPath)startPath, (Node)startPath.leaf());
                    IntroduceVariablePanel panel = new IntroduceVariablePanel(numDuplicates, guessedName, this.kind == IntroduceKind.CREATE_CONSTANT, btnOk, takenNames);
                    String caption = NbBundle.getMessage(IntroduceHint.class, (String)("CAP_" + this.getKeyExt()));
                    DialogDescriptor dd = new DialogDescriptor((Object)panel, caption, true, new Object[]{btnOk, btnCancel}, (Object)btnOk, 0, null, null);
                    if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) != btnOk) {
                        return null;
                    }
                    name = panel.getVariableName();
                    if (panel.isReplaceAll()) break;
                    duplicates = Collections.emptyList();
                    break;
                }
                case CREATE_FIELD: {
                    int numDuplicates = 1;
                    JButton btnOk = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Ok"));
                    JButton btnCancel = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Cancel"));
                    int[] initilizeIn = new int[1];
                    Set takenNames = AstUtilities.getUsedFields((RubyIndex)index, (AstPath)startPath);
                    IntroduceFieldPanel panel = new IntroduceFieldPanel(guessedName, initilizeIn, numDuplicates, btnOk, takenNames);
                    String caption = NbBundle.getMessage(IntroduceHint.class, (String)("CAP_" + this.getKeyExt()));
                    DialogDescriptor dd = new DialogDescriptor((Object)panel, caption, true, new Object[]{btnOk, btnCancel}, (Object)btnOk, 0, null, null);
                    if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) != btnOk) {
                        return null;
                    }
                    name = panel.getFieldName();
                    if (panel.isReplaceAll()) break;
                    duplicates = Collections.emptyList();
                    break;
                }
                case CREATE_METHOD: {
                    JButton btnOk = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Ok"));
                    JButton btnCancel = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Cancel"));
                    Set takenNames = AstUtilities.getUsedMethods((RubyIndex)index, (AstPath)startPath);
                    IntroduceMethodPanel panel = new IntroduceMethodPanel("", takenNames);
                    panel.setOkButton(btnOk);
                    String caption = NbBundle.getMessage(IntroduceHint.class, (String)"CAP_IntroduceMethod");
                    DialogDescriptor dd = new DialogDescriptor((Object)panel, caption, true, new Object[]{btnOk, btnCancel}, (Object)btnOk, 0, null, null);
                    if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) != btnOk) {
                        return null;
                    }
                    name = panel.getMethodName();
                    break;
                }
            }
        }
        if (this.kind == IntroduceKind.CREATE_FIELD) {
            name = "@" + name;
        } else if (this.kind == IntroduceKind.CREATE_CONSTANT) {
            name = name.toUpperCase();
        }
        if (this.kind == IntroduceKind.CREATE_CONSTANT || this.kind == IntroduceKind.CREATE_VARIABLE || this.kind == IntroduceKind.CREATE_FIELD) {
            return this.introduceExp(name, duplicates);
        }
        assert (this.kind == IntroduceKind.CREATE_METHOD);
        return this.extractMethod(name);
    }

    private EditList introduceExp(String name, List<OffsetRange> duplicates) throws BadLocationException {
        int begin;
        boolean isConstant;
        boolean bl = isConstant = this.kind == IntroduceKind.CREATE_CONSTANT;
        if (isConstant) {
            begin = this.findClassBegin();
            if (begin == -1) {
                begin = this.findMethodBegin();
            }
            begin = begin == -1 ? this.findStatementBegin() : Utilities.getRowStart((BaseDocument)this.doc, (int)begin);
        } else {
            begin = this.findStatementBegin();
        }
        int lexStart = this.lexRange.getStart();
        int lexEnd = this.lexRange.getEnd();
        assert (begin <= lexStart);
        StringBuilder sb = new StringBuilder();
        if (isConstant && COMMENT_NEW_ELEMENTS) {
            sb.append("# ");
        }
        int commentTextDelta = sb.length();
        if (isConstant && COMMENT_NEW_ELEMENTS) {
            sb.append(this.getCommentText());
            sb.append("\n");
        }
        sb.append(name);
        sb.append(" = ");
        AstPath path = new AstPath(AstUtilities.getRoot((Parser.Result)this.info), this.astRange.getStart());
        boolean addHash = false;
        if (path.leafGrandParent() != null && path.leafGrandParent().getNodeType() == NodeType.HASHNODE) {
            addHash = true;
        }
        if (addHash) {
            sb.append("{ ");
        }
        sb.append(this.doc.getText(lexStart, lexEnd - lexStart));
        if (addHash) {
            sb.append(" }");
        }
        sb.append("\n");
        if (isConstant) {
            sb.append("\n");
        }
        this.commentOffset = -1;
        if (isConstant && begin > 0 && COMMENT_NEW_ELEMENTS) {
            this.commentOffset = begin + commentTextDelta;
        }
        EditList edits = new EditList(this.doc);
        edits.setFormatAll(false);
        edits.replace(lexStart, lexEnd - lexStart, name, true, 1);
        edits.replace(begin, 0, sb.toString(), true, 2);
        if (duplicates != null && duplicates.size() > 1) {
            HashSet<Integer> starts = new HashSet<Integer>();
            starts.add(lexStart);
            starts.add(begin);
            for (OffsetRange range : duplicates) {
                int start = range.getStart();
                if (starts.contains(start)) continue;
                edits.replace(start, range.getLength(), name, true, 0);
                starts.add(start);
            }
        }
        return edits;
    }

    private EditList extractMethod(String name) throws BadLocationException {
        Node startNode = this.nodes.get(0);
        Node endNode = this.nodes.get(this.nodes.size() - 1);
        AstPath startPath = new AstPath(AstUtilities.getRoot((Parser.Result)this.info), this.astRange.getStart() + this.astRange.getLength() / 2);
        List applicableBlocks = AstUtilities.getApplicableBlocks((AstPath)startPath, (boolean)true);
        InputOutputVarFinder varFinder = new InputOutputVarFinder(startNode, endNode, applicableBlocks);
        ParseTreeWalker walker = new ParseTreeWalker((ParseTreeVisitor)varFinder);
        Node method = AstUtilities.findLocalScope((Node)startPath.leaf(), (AstPath)startPath);
        walker.walk(method);
        Set<String> inputs = varFinder.getInputVars();
        Set<String> outputs = varFinder.getOutputVars();
        ArrayList<String> inputVars = new ArrayList<String>(inputs);
        Collections.sort(inputVars);
        ArrayList<String> outputVars = new ArrayList<String>(outputs);
        Collections.sort(outputVars);
        int prevEnd = this.findMethodEnd();
        StringBuilder sb = new StringBuilder();
        EditList edits = new EditList(this.doc);
        edits.setFormatAll(false);
        boolean isAbove = prevEnd < this.astRange.getStart();
        sb.append("\n");
        if (!isAbove) {
            sb.append("\n");
        }
        sb.append("# ");
        int commentTextDelta = sb.length();
        sb.append(this.getCommentText());
        sb.append("\n");
        sb.append("def ");
        sb.append(name);
        if (inputVars.size() > 0) {
            if (FORCE_COMPLETION_SPACES) {
                this.appendCommaList(sb, inputVars, " ", "");
            } else {
                this.appendCommaList(sb, inputVars, "(", ")");
            }
        }
        sb.append('\n');
        int lexStart = this.lexRange.getStart();
        int lexEnd = this.lexRange.getEnd();
        sb.append(this.doc.getText(lexStart, lexEnd - lexStart));
        sb.append('\n');
        if (outputVars.size() > 0) {
            this.appendCommaList(sb, outputVars, outputVars.size() == 1 ? "" : "return ", "\n");
        }
        sb.append("end");
        if (isAbove) {
            sb.append("\n");
        }
        edits.replace(prevEnd, 0, sb.toString(), true, 0);
        this.commentOffset = prevEnd + commentTextDelta;
        sb = new StringBuilder();
        if (outputVars.size() > 0) {
            this.appendCommaList(sb, outputVars, null, null);
            sb.append(" = ");
        }
        sb.append(name);
        if (inputVars.size() > 0) {
            if (FORCE_COMPLETION_SPACES) {
                this.appendCommaList(sb, inputVars, " ", "");
            } else {
                this.appendCommaList(sb, inputVars, "(", ")");
            }
        }
        edits.replace(lexStart, lexEnd - lexStart, sb.toString(), true, 0);
        return edits;
    }

    private void appendCommaList(StringBuilder sb, List<String> items, String pre, String post) {
        if (pre != null) {
            sb.append(pre);
        }
        boolean first = true;
        for (String item : items) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(item);
        }
        if (post != null) {
            sb.append(post);
        }
    }

    private int findClassBegin() throws BadLocationException {
        AstPath path = new AstPath(AstUtilities.getRoot((Parser.Result)this.info), this.astRange.getStart());
        ClassNode cls = AstUtilities.findClass((AstPath)path);
        if (cls != null) {
            int astPos = Utilities.getRowEnd((BaseDocument)this.doc, (int)cls.getPosition().getStartOffset()) + 1;
            return Math.min(LexUtilities.getLexerOffset((Parser.Result)this.info, (int)astPos), this.doc.getLength());
        }
        return -1;
    }

    private int findStatementBegin() throws BadLocationException {
        AstPath path = new AstPath(AstUtilities.getRoot((Parser.Result)this.info), this.astRange.getStart());
        ListIterator it = path.leafToRoot();
        Node prev = null;
        boolean found = false;
        block0: while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getNodeType() == NodeType.NEWLINENODE) {
                if (prev == null) break;
                found = true;
                Node p = n;
                Node innerNewline = n;
                while (it.hasNext()) {
                    n = (Node)it.next();
                    if (n.getNodeType() == NodeType.NEWLINENODE) {
                        int prevNewline = Math.min(LexUtilities.getLexerOffset((Parser.Result)this.info, (int)innerNewline.getPosition().getStartOffset()), this.doc.getLength());
                        int newLine = Math.min(LexUtilities.getLexerOffset((Parser.Result)this.info, (int)n.getPosition().getStartOffset()), this.doc.getLength());
                        if (p == null || newLine == -1 || prevNewline == -1 || Utilities.getRowStart((BaseDocument)this.doc, (int)prevNewline) != Utilities.getRowStart((BaseDocument)this.doc, (int)newLine)) break block0;
                        prev = p;
                        break block0;
                    }
                    p = n;
                }
                break;
            }
            prev = n;
        }
        if (found) {
            return Math.min(LexUtilities.getLexerOffset((Parser.Result)this.info, (int)prev.getPosition().getStartOffset()), this.doc.getLength());
        }
        return Utilities.getRowFirstNonWhite((BaseDocument)this.doc, (int)this.lexRange.getStart());
    }

    private int findMethodEnd() throws BadLocationException {
        AstPath path = new AstPath(AstUtilities.getRoot((Parser.Result)this.info), this.astRange.getStart());
        for (Node curr : path) {
            if (curr.getNodeType() == NodeType.DEFNNODE || curr.getNodeType() == NodeType.DEFSNODE) {
                return Math.min(LexUtilities.getLexerOffset((Parser.Result)this.info, (int)curr.getPosition().getEndOffset()), this.doc.getLength());
            }
            if (curr.getNodeType() != NodeType.CLASSNODE && curr.getNodeType() != NodeType.SCLASSNODE && curr.getNodeType() != NodeType.MODULENODE) continue;
            int clzStart = LexUtilities.getLexerOffset((Parser.Result)this.info, (int)curr.getPosition().getStartOffset());
            return Utilities.getRowEnd((BaseDocument)this.doc, (int)clzStart);
        }
        return this.doc.getLength();
    }

    private int findMethodBegin() throws BadLocationException {
        AstPath path = new AstPath(AstUtilities.getRoot((Parser.Result)this.info), this.astRange.getStart());
        MethodDefNode method = AstUtilities.findMethod((AstPath)path);
        if (method != null) {
            OffsetRange comment;
            int methodAstOffset = method.getPosition().getStartOffset();
            int lexOffset = LexUtilities.getLexerOffset((Parser.Result)this.info, (int)methodAstOffset);
            if (lexOffset != -1 && (comment = LexUtilities.findRDocRange((BaseDocument)this.doc, (int)methodAstOffset)) != OffsetRange.NONE) {
                return comment.getStart();
            }
            return LexUtilities.getLexerOffset((Parser.Result)this.info, (int)methodAstOffset);
        }
        return -1;
    }

    public boolean isSafe() {
        return true;
    }

    public boolean isInteractive() {
        return true;
    }

    public boolean canPreview() {
        return true;
    }
}

