/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.refactoring.moveclass;

import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.netbeans.modules.j2ee.jpa.refactoring.PersistenceXmlRefactoring;
import org.netbeans.modules.j2ee.jpa.refactoring.RefactoringUtil;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class PersistenceXmlMoveClass
extends PersistenceXmlRefactoring {
    private final MoveRefactoring moveRefactoring;

    public PersistenceXmlMoveClass(MoveRefactoring moveRefactoring) {
        this.moveRefactoring = moveRefactoring;
    }

    @Override
    protected AbstractRefactoring getRefactoring() {
        return this.moveRefactoring;
    }

    @Override
    protected RefactoringElementImplementation getRefactoringElement(PersistenceUnit persistenceUnit, FileObject fileObject, PUDataObject pUDataObject, FileObject fileObject2) {
        String string = JavaIdentifiers.getQualifiedName((FileObject)fileObject);
        String string2 = this.getTargetPackageName(fileObject.getParent());
        String string3 = string2 + "." + JavaIdentifiers.unqualify((String)string);
        return new PersistenceXmlMoveClassRefactoringElement(persistenceUnit, string, string3, pUDataObject, fileObject2);
    }

    private String getTargetPackageName(FileObject fileObject) {
        String string = RefactoringUtil.getPackageName((URL)this.moveRefactoring.getTarget().lookup(URL.class));
        String string2 = "";
        for (FileObject fileObject2 : this.getMovedFolders()) {
            if (!FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject) && !fileObject2.equals(fileObject)) continue;
            string2 = FileUtil.getRelativePath((FileObject)fileObject2.getParent(), (FileObject)fileObject).replace('/', '.');
            break;
        }
        if (string.length() == 0) {
            return string2;
        }
        if (string2.length() == 0) {
            return string;
        }
        return string + "." + string2;
    }

    private Set<FileObject> getMovedFolders() {
        Collection collection = this.moveRefactoring.getRefactoringSource().lookupAll(FileObject.class);
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        for (FileObject fileObject : collection) {
            if (!fileObject.isFolder()) continue;
            hashSet.add(fileObject);
        }
        return hashSet;
    }

    private static class PersistenceXmlMoveClassRefactoringElement
    extends PersistenceXmlRefactoring.PersistenceXmlRefactoringElement {
        private final String newName;

        public PersistenceXmlMoveClassRefactoringElement(PersistenceUnit persistenceUnit, String string, String string2, PUDataObject pUDataObject, FileObject fileObject) {
            super(persistenceUnit, string, pUDataObject, fileObject);
            this.newName = string2;
        }

        public String getDisplayText() {
            Object[] objectArray = new Object[]{this.parentFile.getNameExt(), this.clazz, this.newName};
            return MessageFormat.format(NbBundle.getMessage(PersistenceXmlMoveClassRefactoringElement.class, (String)"TXT_PersistenceXmlRename"), objectArray);
        }

        public void undoChange() {
            ProviderUtil.renameManagedClass((PersistenceUnit)this.persistenceUnit, (String)this.clazz, (String)this.newName, (PUDataObject)this.puDataObject);
        }

        public void performChange() {
            ProviderUtil.renameManagedClass((PersistenceUnit)this.persistenceUnit, (String)this.newName, (String)this.clazz, (PUDataObject)this.puDataObject);
        }
    }
}

