/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.profiles;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfile;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.ProfileBaseForm;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.HttpsToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.TransportToken;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class TransportSecurity
extends ProfileBaseForm {
    private JCheckBox requireCertificateChBox;

    public TransportSecurity(WSDLComponent comp, SecurityProfile secProfile) {
        super(comp, secProfile);
        this.initComponents();
        this.sync();
    }

    @Override
    protected void sync() {
        this.inSync = true;
        ExtensibilityElement secBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
        WSDLComponent tokenKind = SecurityTokensModelHelper.getTokenElement((WSDLComponent)secBinding, TransportToken.class);
        HttpsToken token = (HttpsToken)SecurityTokensModelHelper.getTokenTypeElement(tokenKind);
        if (token instanceof HttpsToken) {
            this.setChBox(this.requireCertificateChBox, SecurityTokensModelHelper.isRequireClientCertificate(token));
        }
        this.inSync = false;
    }

    @Override
    protected void setValue(JComponent source) {
        if (this.inSync) {
            return;
        }
        ExtensibilityElement secBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
        if (source.equals(this.requireCertificateChBox)) {
            WSDLComponent tokenKind = SecurityTokensModelHelper.getTokenElement((WSDLComponent)secBinding, TransportToken.class);
            HttpsToken token = (HttpsToken)SecurityTokensModelHelper.getTokenTypeElement(tokenKind);
            SecurityTokensModelHelper.setRequireClientCertificate(token, this.requireCertificateChBox.isSelected());
        }
    }

    private void initComponents() {
        this.requireCertificateChBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.requireCertificateChBox, (String)NbBundle.getMessage(TransportSecurity.class, (String)"LBL_RequireClientCertificate"));
        this.requireCertificateChBox.setMargin(new Insets(0, 0, 0, 0));
        this.requireCertificateChBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TransportSecurity.this.requireCertificateChBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.requireCertificateChBox).addContainerGap(40, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.requireCertificateChBox).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void requireCertificateChBoxActionPerformed(ActionEvent evt) {
        this.setValue(this.requireCertificateChBox);
    }

    @Override
    protected void enableDisable() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

