/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class Portability {
    private static Reference<ResourceBundle> bundleRef;
    private static Boolean inNetBeans;

    private Portability() {
    }

    public static String getString(String key, Object substitutions) {
        if (Portability.inNetBeans()) {
            return Portability.getViaNbBundle(key, substitutions);
        }
        return Portability.getViaResourceBundle(key, substitutions);
    }

    public static String getString(String key) {
        return Portability.getString(key, null);
    }

    private static String getViaNbBundle(String key, Object substitutions) {
        try {
            Class<?> clazz = Class.forName("org.openide.util.NbBundle");
            if (substitutions == null) {
                Method m = clazz.getMethod("getMessage", Class.class, String.class);
                return (String)m.invoke(null, Portability.class, key);
            }
            Method m = clazz.getMethod("getMessage", Class.class, String.class, Object.class);
            return (String)m.invoke(null, Portability.class, key, substitutions);
        }
        catch (Exception ex) {
            Logger.getLogger(Portability.class.getName()).log(Level.SEVERE, null, ex);
            return Portability.getViaResourceBundle(key, substitutions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getViaResourceBundle(String key, Object substitutions) {
        ResourceBundle bundle;
        ResourceBundle resourceBundle = bundle = bundleRef == null ? null : bundleRef.get();
        if (bundle == null) {
            try {
                bundle = ResourceBundle.getBundle("com.sun.javacard.Bundle", Locale.getDefault());
            }
            catch (MissingResourceException e) {
                try {
                    bundle = ResourceBundle.getBundle("com.sun.javacard.Bundle", Locale.ENGLISH);
                }
                catch (MissingResourceException e1) {
                    InputStream in = Portability.class.getResourceAsStream("Bundle.properties");
                    try {
                        bundle = new PropertyResourceBundle(in);
                    }
                    catch (IOException ioe) {
                        Logger.getLogger(Portability.class.getName()).log(Level.SEVERE, null, ioe);
                        String string = key;
                        return string;
                    }
                    finally {
                        try {
                            in.close();
                        }
                        catch (IOException ex) {
                            Logger.getLogger(Portability.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
            }
            if (bundle != null) {
                bundleRef = new SoftReference<ResourceBundle>(bundle);
            }
        }
        if (bundle != null) {
            String result = bundle.getString(key);
            if (substitutions != null) {
                MessageFormat fmt = new MessageFormat(result);
                return fmt.format(new Object[]{substitutions});
            }
            return result;
        }
        return key;
    }

    public static XMLReader createXMLReader() {
        if (Portability.inNetBeans()) {
            return Portability.getXmlReaderViaXmlUtil();
        }
        try {
            return XMLReaderFactory.createXMLReader();
        }
        catch (SAXException ex) {
            throw new Error("Could not create XML reader", ex);
        }
    }

    private static XMLReader getXmlReaderViaXmlUtil() {
        try {
            Class<?> clazz = Class.forName("org.openide.xml.XMLUtil");
            Method m = clazz.getMethod("createXMLReader", Boolean.TYPE, Boolean.TYPE);
            return (XMLReader)m.invoke(null, false, false);
        }
        catch (Exception ex) {
            Portability.logException(ex);
            try {
                return XMLReaderFactory.createXMLReader();
            }
            catch (SAXException ex1) {
                Portability.logException(ex);
                throw new Error("Cannot create an XML reader", ex);
            }
        }
    }

    public static Document parse(InputStream in) throws IOException {
        if (Portability.inNetBeans()) {
            return Portability.parseViaXmlUtil(in);
        }
        return Portability.parseDefault(in);
    }

    private static synchronized boolean inNetBeans() {
        if (inNetBeans == null) {
            try {
                Class.forName("org.openide.util.NbBundle");
                inNetBeans = Boolean.TRUE;
            }
            catch (ClassNotFoundException e) {
                inNetBeans = Boolean.FALSE;
            }
        }
        return inNetBeans;
    }

    private static Document parseDefault(InputStream in) throws IOException {
        try {
            Document doc;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = doc = db.parse(in);
            return document;
        }
        catch (SAXException ex) {
            if (System.getProperty("netbeans.home") == null) {
                ex.printStackTrace();
            }
            IOException ioe = new IOException();
            ioe.initCause(ex);
            throw ioe;
        }
        catch (ParserConfigurationException ex) {
            IOException ioe = new IOException();
            ioe.initCause(ex);
            throw ioe;
        }
        finally {
            in.close();
        }
    }

    private static Document parseViaXmlUtil(InputStream in) throws IOException {
        try {
            Class[] types = new Class[]{InputSource.class, Boolean.TYPE, Boolean.TYPE, ErrorHandler.class, EntityResolver.class};
            Class<?> clazz = Class.forName("org.openide.xml.XMLUtil");
            Method m = clazz.getMethod("parse", types);
            InputSource src = new InputSource(in);
            Object[] args = new Object[]{src, Boolean.FALSE, Boolean.FALSE, null, null};
            Document document = (Document)m.invoke(null, args);
            return document;
        }
        catch (Exception ex) {
            IOException ioe = new IOException();
            ioe.initCause(ex);
            throw ioe;
        }
        finally {
            in.close();
        }
    }

    public static void logException(Exception e) {
        if (Portability.inNetBeans()) {
            Portability.logExceptionViaExceptions(e);
        } else {
            Portability.logViaLogger(e);
        }
    }

    private static void logViaLogger(Exception e) {
        Logger.getLogger(Portability.class.getName()).log(Level.SEVERE, null, e);
    }

    private static void logExceptionViaExceptions(Exception e) {
        try {
            Class<?> clazz = Class.forName("org.openide.util.Exceptions");
            Method m = clazz.getDeclaredMethod("printStackTrace", Throwable.class);
            m.invoke(null, e);
        }
        catch (Exception ex) {
            Portability.logViaLogger(e);
            Portability.logViaLogger(ex);
        }
    }
}

