/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.end2end.ui.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.mobility.end2end.classdata.AbstractService;
import org.netbeans.modules.mobility.end2end.classdata.ClassService;
import org.netbeans.modules.mobility.end2end.classdata.WSDLService;
import org.netbeans.modules.mobility.end2end.client.config.ClassDescriptor;
import org.netbeans.modules.mobility.end2end.client.config.Configuration;
import org.netbeans.modules.mobility.end2end.client.config.ServerConfiguration;
import org.netbeans.modules.mobility.end2end.util.Util;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientView;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.modules.SpecificationVersion;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class WebApplicationPanel
extends JPanel
implements ChangeListener,
ActionListener,
DocumentListener {
    private Project enterpriseProject;
    WebProjectsActionListener webProjectsActionListener = new WebProjectsActionListener();
    private final ArrayList<ChangeListener> listeners = new ArrayList();
    private static final String CLIENT_NAME = "WebToMobileServlet";
    private Project project;
    private ModelItem[] groupItems;
    private String expectedExtension;
    private boolean isPackage;
    private SourceGroup[] folders;
    private String clientTypeSelection;
    private static String openProject = NbBundle.getMessage(WebApplicationPanel.class, (String)"LBL_Open_WebProject");
    private static String noProject = NbBundle.getMessage(WebApplicationPanel.class, (String)"LBL_No_WebProject");
    private static final String DEFAULT_NEW_PACKAGE_NAME = NbBundle.getMessage(WebApplicationPanel.class, (String)"LBL_JavaTargetChooserPanelGUI_DefaultNewPackageName");
    private static final ListCellRenderer CELL_RENDERER = new NodeCellRenderer();
    private JRadioButton clientToWebAppRadio;
    private JRadioButton clientToWebServiceRadio;
    private ButtonGroup clientTypeButtonGroup;
    private JTextField documentNameTextField;
    private JComboBox enterpriseProjectsComboBox;
    private JTextField fileTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JComboBox packageComboBox;
    private JComboBox rootComboBox;
    private JComboBox serviceCombo;

    public static WebApplicationPanelWizard create() {
        return new WebApplicationPanelWizard();
    }

    public WebApplicationPanel() {
        this.initComponents();
        this.setName(NbBundle.getMessage(WebApplicationPanel.class, (String)"TITLE_clientTypeStep"));
        this.setValues();
        this.clientTypeButtonGroup.add(this.clientToWebAppRadio);
        this.clientTypeButtonGroup.add(this.clientToWebServiceRadio);
        this.initAccessibility();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WebApplicationPanel.class, (String)"ACSN_Web_Application_Panel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebApplicationPanel.class, (String)"ACSD_Web_Application_Panel"));
        this.enterpriseProjectsComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebApplicationPanel.class, (String)"ACSD_Web_Application_Panel"));
        this.documentNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebApplicationPanel.class, (String)"ACSD_Servlet_Name"));
        this.rootComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebApplicationPanel.class, (String)"ACSD_Location"));
        this.packageComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebApplicationPanel.class, (String)"ACSD_Server_Package"));
        this.fileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebApplicationPanel.class, (String)"ACSD_Server_Created_File"));
        this.clientToWebAppRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebApplicationPanel.class, (String)"ACSD_LBL_ClassClientType"));
        this.clientToWebServiceRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebApplicationPanel.class, (String)"ACSD_WebServiceClientType"));
    }

    private void setValues() {
        Sources sources = null;
        DefaultComboBoxModel<Project> defaultComboBoxModel = new DefaultComboBoxModel<Project>(this.getEnterpriseProjects());
        this.enterpriseProjectsComboBox.setModel(defaultComboBoxModel);
        this.enterpriseProjectsComboBox.setRenderer(new ProjectCellRenderer());
        this.serviceCombo.setRenderer(new ServiceCellRenderer());
        if (defaultComboBoxModel.getSize() == 0) {
            defaultComboBoxModel.addElement((Project)noProject);
            this.setServletPanelEnabled(false);
            this.updateWebServices(null);
        } else {
            if (this.enterpriseProject == null) {
                this.enterpriseProject = defaultComboBoxModel.getElementAt(0);
            }
            this.updateWebServices(this.enterpriseProject);
            this.enterpriseProjectsComboBox.setSelectedItem(this.enterpriseProject);
            sources = ProjectUtils.getSources((Project)this.enterpriseProject);
            sources.getSourceGroups("java");
            this.rootComboBox.setRenderer(CELL_RENDERER);
            this.packageComboBox.setRenderer(CELL_RENDERER);
            this.rootComboBox.addActionListener(this);
            this.initValues(CLIENT_NAME, this.enterpriseProject);
        }
        defaultComboBoxModel.addElement((Project)openProject);
        Component component = this.packageComboBox.getEditor().getEditorComponent();
        ((JTextField)component).getDocument().addDocumentListener(this);
        this.packageComboBox.addActionListener(this);
        this.enterpriseProjectsComboBox.addActionListener(this.webProjectsActionListener);
        this.documentNameTextField.getDocument().addDocumentListener(this);
        this.clientToWebServiceRadio.addActionListener(this);
        this.clientToWebAppRadio.addActionListener(this);
        this.clientToWebServiceRadio.addChangeListener(this);
        this.clientToWebAppRadio.addChangeListener(this);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChange();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateText();
        this.fireChange();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.rootComboBox == actionEvent.getSource()) {
            this.updatePackages();
            this.updateText();
        } else if (this.packageComboBox == actionEvent.getSource()) {
            this.updateText();
            this.fireChange();
        } else if (this.packageComboBox.getEditor() == actionEvent.getSource()) {
            this.updateText();
            this.fireChange();
        } else if (this.clientToWebAppRadio == actionEvent.getSource() || this.clientToWebServiceRadio == actionEvent.getSource()) {
            this.clientTypeSelection = actionEvent.getActionCommand();
        }
    }

    private void initComponents() {
        this.clientTypeButtonGroup = new ButtonGroup();
        this.jLabel7 = new JLabel();
        this.jLabel1 = new JLabel();
        this.enterpriseProjectsComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.documentNameTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.rootComboBox = new JComboBox();
        this.jLabel4 = new JLabel();
        this.packageComboBox = new JComboBox();
        this.jLabel5 = new JLabel();
        this.fileTextField = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jLabel6 = new JLabel();
        this.clientToWebAppRadio = new JRadioButton();
        this.clientToWebServiceRadio = new JRadioButton();
        this.serviceCombo = new JComboBox();
        this.jPanel2 = new JPanel();
        this.setPreferredSize(new Dimension(560, 350));
        this.setLayout(new GridBagLayout());
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/mobility/end2end/ui/wizard/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)resourceBundle.getString("LBL_Title"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel1.setLabelFor(this.enterpriseProjectsComboBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(WebApplicationPanel.class, (String)"LBL_Web_Application"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 1, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.enterpriseProjectsComboBox, gridBagConstraints);
        this.jLabel2.setLabelFor(this.documentNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(WebApplicationPanel.class, (String)"LBL_Servlet_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 1, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 65;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.add((Component)this.documentNameTextField, gridBagConstraints);
        this.jLabel3.setLabelFor(this.rootComboBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(WebApplicationPanel.class, (String)"LBL_Location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 1, 0, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.add((Component)this.rootComboBox, gridBagConstraints);
        this.jLabel4.setLabelFor(this.packageComboBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(WebApplicationPanel.class, (String)"LBL_Server_Package"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 1, 0, 0);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.packageComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.add((Component)this.packageComboBox, gridBagConstraints);
        this.jLabel5.setLabelFor(this.fileTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(WebApplicationPanel.class, (String)"LBL_Server_Created_File"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 1, 0, 0);
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.fileTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 65;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.add((Component)this.fileTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 189;
        gridBagConstraints.ipady = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 1, 0, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(WebApplicationPanel.class, (String)"LBL_ServiceTypeSelection"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 1, 0, 0);
        this.jPanel1.add((Component)this.jLabel6, gridBagConstraints);
        this.clientTypeButtonGroup.add(this.clientToWebAppRadio);
        this.clientToWebAppRadio.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.clientToWebAppRadio, (String)NbBundle.getMessage(WebApplicationPanel.class, (String)"LBL_ClassClientType"));
        this.clientToWebAppRadio.setActionCommand("class");
        this.clientToWebAppRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.clientToWebAppRadio.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 11, 0, 0);
        this.jPanel1.add((Component)this.clientToWebAppRadio, gridBagConstraints);
        this.clientTypeButtonGroup.add(this.clientToWebServiceRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.clientToWebServiceRadio, (String)NbBundle.getMessage(WebApplicationPanel.class, (String)"LBL_WebServiceClientType"));
        this.clientToWebServiceRadio.setActionCommand("wsdlClient");
        this.clientToWebServiceRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.clientToWebServiceRadio.setMargin(new Insets(0, 0, 0, 0));
        this.clientToWebServiceRadio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                WebApplicationPanel.this.clientToWebServiceRadioStateChanged(changeEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 11, 5, 6);
        this.jPanel1.add((Component)this.clientToWebServiceRadio, gridBagConstraints);
        this.serviceCombo.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel1.add((Component)this.serviceCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void clientToWebServiceRadioStateChanged(ChangeEvent changeEvent) {
        this.serviceCombo.setEnabled(this.clientToWebServiceRadio.isSelected());
    }

    protected void enterpriseProjectsListValueChanged(ActionEvent actionEvent) {
        String string;
        this.enterpriseProjectsComboBox.removeActionListener(this.webProjectsActionListener);
        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
        Object object = jComboBox.getSelectedItem();
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)jComboBox.getModel();
        if (object instanceof String) {
            string = (String)object;
            if (string.equals(openProject)) {
                Project project = this.enterpriseProject;
                this.enterpriseProject = Util.openProject();
                if (this.enterpriseProject != null) {
                    if (defaultComboBoxModel.getIndexOf(noProject) >= 0) {
                        defaultComboBoxModel.removeElement(noProject);
                    }
                    if (defaultComboBoxModel.getIndexOf(this.enterpriseProject) < 0) {
                        defaultComboBoxModel.insertElementAt(this.enterpriseProject, defaultComboBoxModel.getSize() - 1);
                    }
                    this.updateWebServices(this.enterpriseProject);
                    jComboBox.setSelectedItem(this.enterpriseProject);
                } else if (project != null) {
                    this.enterpriseProject = project;
                    jComboBox.setSelectedItem(this.enterpriseProject);
                }
            }
        } else {
            this.enterpriseProject = (Project)object;
            this.updateWebServices(this.enterpriseProject);
        }
        if (this.enterpriseProject != null) {
            string = ProjectUtils.getSources((Project)this.enterpriseProject);
            string.getSourceGroups("java");
            this.setServletPanelEnabled(true);
        }
        if (this.enterpriseProject != null) {
            this.initValues(CLIENT_NAME, this.enterpriseProject);
        }
        this.enterpriseProjectsComboBox.addActionListener(this.webProjectsActionListener);
    }

    public void initValues(String string, Project project) {
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        this.project = project;
        this.folders = sourceGroupArray;
        this.initValues(string, project.getProjectDirectory());
    }

    public void initValues(String string, FileObject fileObject) {
        assert (this.project != null) : "Project must be specified.";
        this.groupItems = new ModelItem[this.folders.length];
        for (int i = 0; i < this.folders.length; ++i) {
            this.groupItems[i] = new ModelItem(this.folders[i]);
        }
        assert (string != null);
        this.putClientProperty("NewFileWizard_Title", "Servlet");
        this.rootComboBox.setModel(new DefaultComboBoxModel<ModelItem>(this.groupItems));
        ModelItem modelItem = this.getPreselectedGroup(fileObject);
        this.rootComboBox.setSelectedItem(modelItem);
        this.updatePackages();
        ModelItem modelItem2 = this.getPreselectedPackage(modelItem, fileObject);
        if (modelItem2 != null) {
            if (this.isPackage) {
                String string2 = modelItem2.toString().length() == 0 ? DEFAULT_NEW_PACKAGE_NAME : modelItem2.toString() + "." + DEFAULT_NEW_PACKAGE_NAME;
                this.documentNameTextField.setText(string2);
                int n = string2.length();
                int n2 = DEFAULT_NEW_PACKAGE_NAME.length();
                this.documentNameTextField.setSelectionEnd(n - 1);
                this.documentNameTextField.setSelectionStart(n - n2);
            } else {
                this.packageComboBox.setSelectedItem(modelItem2);
            }
        }
        this.documentNameTextField.setText(string);
        this.documentNameTextField.selectAll();
        this.expectedExtension = ".java";
        this.updateText();
        this.fireChange();
    }

    private Project[] getEnterpriseProjects() {
        ArrayList<Project> arrayList = new ArrayList<Project>();
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            if (!Util.isWebProject(projectArray[i])) continue;
            arrayList.add(projectArray[i]);
        }
        Project[] projectArray2 = new Project[arrayList.size()];
        projectArray2 = arrayList.toArray(projectArray2);
        Arrays.sort(projectArray2, new ProjectByDisplayNameComparator());
        return projectArray2;
    }

    private void setServletPanelEnabled(boolean bl) {
        this.rootComboBox.setEnabled(bl);
        this.packageComboBox.setEnabled(bl);
        this.documentNameTextField.setEnabled(bl);
    }

    private ModelItem getPreselectedGroup(FileObject fileObject) {
        for (int i = 0; fileObject != null && i < this.groupItems.length; ++i) {
            if (!this.groupItems[i].group.getRootFolder().equals(fileObject) && !FileUtil.isParentOf((FileObject)this.groupItems[i].group.getRootFolder(), (FileObject)fileObject)) continue;
            return this.groupItems[i];
        }
        return this.groupItems[0];
    }

    private ModelItem getPreselectedPackage(ModelItem modelItem, FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        ModelItem[] modelItemArray = modelItem.getChildren();
        FileObject fileObject2 = modelItem.group.getRootFolder();
        String string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
        if (string == null) {
            return null;
        }
        string = string.replace('/', '.');
        for (int i = 0; i < modelItemArray.length; ++i) {
            if (!modelItemArray[i].toString().equals(string)) continue;
            return modelItemArray[i];
        }
        return null;
    }

    private void updatePackages() {
        this.packageComboBox.setModel(new DefaultComboBoxModel<ModelItem>(((ModelItem)this.rootComboBox.getSelectedItem()).getChildren()));
    }

    private void updateText() {
        ModelItem modelItem = (ModelItem)this.rootComboBox.getSelectedItem();
        FileObject fileObject = modelItem.group.getRootFolder();
        String string = this.getPackageFileName();
        String string2 = this.documentNameTextField.getText().trim();
        if (this.isPackage) {
            string2 = string2.replace('.', '/');
        } else if (string2.length() > 0) {
            string2 = string2 + this.expectedExtension;
        }
        String string3 = FileUtil.getFileDisplayName((FileObject)fileObject) + (string.startsWith("/") || string.startsWith(File.separator) ? "" : "/") + string + (string.endsWith("/") || string.endsWith(File.separator) || string.length() == 0 ? "" : "/") + string2;
        this.fileTextField.setText(string3.replace('/', File.separatorChar));
    }

    public String getPackageFileName() {
        if (this.isPackage) {
            return "";
        }
        String string = this.packageComboBox.getEditor().getItem().toString();
        return string.replace('.', '/');
    }

    public boolean isSelectedClientType() {
        return this.clientTypeButtonGroup.getSelection() != null;
    }

    public String getSelectedClientType() {
        return this.clientTypeSelection;
    }

    public String isValidWebProject() {
        String string = null;
        if (this.enterpriseProject == null) {
            string = NbBundle.getMessage(WebApplicationPanel.class, (String)"ERR_NoProject");
        } else if (!Util.isWebProject(this.enterpriseProject)) {
            string = NbBundle.getMessage(WebApplicationPanel.class, (String)"ERR_NoWebProject");
        }
        return string;
    }

    boolean isValidWsdl() {
        return this.getSelectedService() != null;
    }

    boolean isWsdlCompiled() {
        return true;
    }

    public String isValidServletLocation() {
        if ("".equals(this.getTargetName())) {
            return NbBundle.getMessage(WebApplicationPanel.class, (String)"ERR_File_NoTargetName");
        }
        if (!WebApplicationPanel.isValidTypeIdentifier(this.getTargetName())) {
            return NbBundle.getMessage(WebApplicationPanel.class, (String)"ERR_JavaTargetChooser_InvalidClass");
        }
        if (!WebApplicationPanel.isValidPackageName(this.getPackageName())) {
            return NbBundle.getMessage(WebApplicationPanel.class, (String)"ERR_JavaTargetChooser_InvalidPackage");
        }
        try {
            FileObject fileObject = this.getRootFolder();
            String string = WebApplicationPanel.canUseFileName(fileObject, this.getPackageFileName(), this.getTargetName(), "java");
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return NbBundle.getMessage(WebApplicationPanel.class, (String)"ERR_Project_Missing_Source_Folders");
        }
    }

    static boolean isValidPackageName(String string) {
        if (string.length() > 0 && string.charAt(0) == '.') {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("".equals(string2)) {
                return false;
            }
            if (Utilities.isJavaIdentifier((String)string2)) continue;
            return false;
        }
        return true;
    }

    static boolean isValidTypeIdentifier(String string) {
        return string != null && !"".equals(string) && Utilities.isJavaIdentifier((String)string);
    }

    public FileObject getRootFolder() {
        return ((ModelItem)this.rootComboBox.getSelectedItem()).group.getRootFolder();
    }

    public SourceGroup getSourceGroup() {
        if (this.rootComboBox.getSelectedItem() == null) {
            return null;
        }
        return ((ModelItem)this.rootComboBox.getSelectedItem()).group;
    }

    public String getProjectName() {
        if (this.enterpriseProjectsComboBox.getSelectedItem() instanceof String) {
            return this.enterpriseProjectsComboBox.getSelectedItem().toString();
        }
        ProjectInformation projectInformation = (ProjectInformation)((Project)this.enterpriseProjectsComboBox.getSelectedItem()).getLookup().lookup(ProjectInformation.class);
        return projectInformation.getName();
    }

    public Project getEnterpriseProject() {
        if (this.enterpriseProjectsComboBox.getSelectedItem() instanceof String) {
            return null;
        }
        return (Project)this.enterpriseProjectsComboBox.getSelectedItem();
    }

    public String getPackageName() {
        if (this.isPackage) {
            return "";
        }
        return this.packageComboBox.getEditor().getItem().toString();
    }

    public String getTargetName() {
        return this.documentNameTextField.getText().trim();
    }

    public static String canUseFileName(FileObject fileObject, String string, String string2, String string3) {
        CharSequence charSequence;
        if (string3 != null && string3.length() > 0) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(string2);
            ((StringBuffer)charSequence).append('.');
            ((StringBuffer)charSequence).append(string3);
            string2 = ((StringBuffer)charSequence).toString();
        }
        charSequence = string + "/" + string2;
        if (fileObject == null) {
            return NbBundle.getMessage(WebApplicationPanel.class, (String)"MSG_fs_or_folder_does_not_exist");
        }
        if (!fileObject.canWrite()) {
            return NbBundle.getMessage(WebApplicationPanel.class, (String)"MSG_fs_is_readonly");
        }
        if (WebApplicationPanel.existFileName(fileObject, (String)charSequence)) {
            return NbBundle.getMessage(WebApplicationPanel.class, (String)"MSG_file_already_exist", (Object)string2);
        }
        return null;
    }

    private static boolean existFileName(FileObject fileObject, String string) {
        boolean bl = false;
        File file = FileUtil.toFile((FileObject)fileObject);
        bl = file.exists() ? new File(file, string).exists() : fileObject.getFileObject(string) != null;
        return bl;
    }

    protected void updateWebServices(final Project project) {
        DefaultComboBoxModel<String> defaultComboBoxModel = null;
        if (project == null) {
            defaultComboBoxModel = new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(WebApplicationPanel.class, (String)"ERR_NoWebServiceCombo")});
        } else {
            JAXWSClientSupport jAXWSClientSupport = JAXWSClientSupport.getJaxWsClientSupport((FileObject)project.getProjectDirectory());
            List list = jAXWSClientSupport.getServiceClients();
            if (list.size() > 0) {
                JAXWSClientSupport jAXWSClientSupport2 = JAXWSClientSupport.getJaxWsClientSupport((FileObject)project.getProjectDirectory());
                JAXWSClientView jAXWSClientView = JAXWSClientView.getJAXWSClientView();
                Node node = jAXWSClientView.createJAXWSClientView(project);
                Node[] nodeArray = node.getChildren().getNodes();
                if (nodeArray.length == 0) {
                    defaultComboBoxModel = new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(WebApplicationPanel.class, (String)"MSG_ComputingWebServices")});
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            WebApplicationPanel.this.updateWebServices(project);
                        }
                    }, 500);
                } else {
                    ArrayList<Client> arrayList = new ArrayList<Client>();
                    for (int i = 0; i < nodeArray.length; ++i) {
                        Client client = (Client)nodeArray[i].getLookup().lookup(Client.class);
                        arrayList.add(client);
                    }
                    defaultComboBoxModel = new DefaultComboBoxModel<Client>(arrayList.toArray(new Client[arrayList.size()]));
                    this.fireChange();
                }
            } else {
                defaultComboBoxModel = new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(WebApplicationPanel.class, (String)"ERR_NoWebServiceInProject")});
            }
        }
        this.serviceCombo.setModel(defaultComboBoxModel);
    }

    Client getSelectedService() {
        Object object = this.serviceCombo.getSelectedItem();
        if (object instanceof Client) {
            return (Client)object;
        }
        return null;
    }

    boolean isWsdl() {
        return this.clientToWebServiceRadio.isSelected();
    }

    public static class WebApplicationPanelWizard
    implements WizardDescriptor.Panel,
    ChangeListener {
        public static final HelpCtx HELP_CTX = new HelpCtx("me.wcb_webappselection");
        WebApplicationPanel gui;
        private final ArrayList<ChangeListener> listeners = new ArrayList();
        private final SpecificationVersion JDK_14 = new SpecificationVersion("1.4");
        private TemplateWizard templateWizard;

        public void addChangeListener(ChangeListener changeListener) {
            this.listeners.add(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.listeners.remove(changeListener);
        }

        private void fireChange() {
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (ChangeListener changeListener : this.listeners) {
                changeListener.stateChanged(changeEvent);
            }
        }

        public boolean isValid() {
            String string = this.gui.isValidWebProject();
            if (string != null) {
                this.setLocalizedErrorMessage(string);
                return false;
            }
            string = this.gui.isValidServletLocation();
            if (string != null) {
                this.setLocalizedErrorMessage(string);
                return false;
            }
            if (!WebApplicationPanel.isValidTypeIdentifier(this.gui.getTargetName())) {
                this.setErrorMessage("ERR_JavaTargetChooser_InvalidClass");
                return false;
            }
            if (!WebApplicationPanel.isValidPackageName(this.gui.getPackageName())) {
                this.setErrorMessage("ERR_JavaTargetChooser_InvalidPackage");
                return false;
            }
            boolean bl = true;
            FileObject fileObject = this.gui.getRootFolder();
            String string2 = WebApplicationPanel.canUseFileName(fileObject, this.gui.getPackageFileName(), this.gui.getTargetName(), "java");
            if (this.gui.isShowing()) {
                this.setLocalizedErrorMessage(string2);
            }
            if (string2 != null) {
                bl = false;
            }
            String string3 = SourceLevelQuery.getSourceLevel((FileObject)fileObject);
            if (bl && this.gui.getPackageName().length() == 0 && string3 != null && this.JDK_14.compareTo((Object)new SpecificationVersion(string3)) <= 0) {
                this.setErrorMessage("ERR_JavaTargetChooser_DefaultPackage");
            } else if (bl) {
                this.setErrorMessage(null);
            }
            if (!this.gui.isSelectedClientType() && bl) {
                this.setErrorMessage("ERR_Unselected_Client_Type");
                bl = false;
            }
            if (this.gui.isWsdl() && !this.gui.isValidWsdl()) {
                this.setErrorMessage("ERR_NoWebService");
                bl = false;
            }
            if (this.gui.isWsdl() && !this.gui.isWsdlCompiled()) {
                this.setErrorMessage("ERR_WebServiceNotCompiled");
                bl = false;
            }
            return bl;
        }

        private void setErrorMessage(String string) {
            if (string == null) {
                this.setLocalizedErrorMessage(" ");
            } else {
                this.setLocalizedErrorMessage(NbBundle.getMessage(WebApplicationPanel.class, (String)string));
            }
        }

        private void setLocalizedErrorMessage(String string) {
            if (this.templateWizard != null) {
                this.templateWizard.putProperty("WizardPanel_errorMessage", (Object)string);
            }
        }

        public void readSettings(Object object) {
            this.templateWizard = (TemplateWizard)object;
            this.getComponent();
            this.isValid();
            this.templateWizard.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage(WebApplicationPanel.class, (String)"LBL_WebServiceClient"));
        }

        public void storeSettings(Object object) {
            this.templateWizard = (TemplateWizard)object;
            this.getComponent();
            Configuration configuration = (Configuration)this.templateWizard.getProperty("e2e-configuration");
            configuration.setServiceType(this.gui.getSelectedClientType());
            ServerConfiguration serverConfiguration = new ServerConfiguration();
            String string = this.gui.getPackageName();
            string = !"".equals(string) ? string + "." + this.gui.getTargetName() : this.gui.getTargetName();
            Project project = this.gui.getEnterpriseProject();
            this.templateWizard.putProperty("server-project", (Object)project);
            if (this.gui.getSourceGroup() == null) {
                return;
            }
            String string2 = this.gui.getSourceGroup().getName();
            ClassDescriptor classDescriptor = new ClassDescriptor(string, string2);
            serverConfiguration.setClassDescriptor(classDescriptor);
            serverConfiguration.setProjectName(this.gui.getProjectName());
            serverConfiguration.setProperties(new Properties());
            configuration.setServerConfiguration(serverConfiguration);
            List<AbstractService> list = configuration.getServices();
            AbstractService abstractService = null;
            if (list != null && list.size() > 0) {
                abstractService = list.get(0);
            }
            if (this.gui.isWsdl()) {
                configuration.setServiceType("wsdlClass");
                WSDLService wSDLService = null;
                if (abstractService instanceof WSDLService) {
                    wSDLService = (WSDLService)abstractService;
                }
                if (this.gui.getSelectedService() != null) {
                    Client client = this.gui.getSelectedService();
                    if (wSDLService == null || !this.gui.getSelectedService().getName().equals(wSDLService.getName())) {
                        wSDLService = new WSDLService();
                        wSDLService.setName(client.getName());
                        wSDLService.setFile(client.getLocalWsdlFile());
                        wSDLService.setUrl(client.getWsdlUrl());
                        ArrayList<AbstractService> arrayList = new ArrayList<AbstractService>();
                        arrayList.add(wSDLService);
                        configuration.setServices(arrayList);
                    }
                }
            } else {
                configuration.setServiceType("class");
                ArrayList<AbstractService> arrayList = new ArrayList<AbstractService>();
                ClassService classService = null;
                if (!(abstractService instanceof ClassService)) {
                    classService = new ClassService();
                    arrayList.add(classService);
                    configuration.setServices(arrayList);
                }
            }
        }

        public HelpCtx getHelp() {
            return HELP_CTX;
        }

        public Component getComponent() {
            if (this.gui == null) {
                this.gui = new WebApplicationPanel();
                this.gui.addChangeListener(this);
            }
            return this.gui;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (this.templateWizard != null) {
                this.templateWizard.setValid(this.isValid());
                this.fireChange();
            }
        }
    }

    public static class NodeCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public NodeCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof ModelItem) {
                ModelItem modelItem = (ModelItem)object;
                this.setText(modelItem.getDisplayName());
                this.setIcon(modelItem.getIcon());
            } else {
                this.setText(object == null ? "" : object.toString());
                this.setIcon(null);
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }

    private static class ModelItem {
        private static final String DEFAULT_PACKAGE_DISPLAY_NAME = NbBundle.getMessage(WebApplicationPanel.class, (String)"LBL_JavaTargetChooserPanelGUI_DefaultPackage");
        private Node node;
        SourceGroup group;
        private final Icon icon;
        private ModelItem[] children;

        public ModelItem(SourceGroup sourceGroup) {
            this.group = sourceGroup;
            this.icon = sourceGroup.getIcon(false);
        }

        public ModelItem(Node node) {
            this.node = node;
            this.icon = new ImageIcon(node.getIcon(1));
        }

        public String getDisplayName() {
            if (this.group != null) {
                return this.group.getDisplayName();
            }
            String string = this.node.getName();
            return string.length() == 0 ? DEFAULT_PACKAGE_DISPLAY_NAME : string;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public String toString() {
            if (this.group != null) {
                return this.getDisplayName();
            }
            return this.node.getName();
        }

        public ModelItem[] getChildren() {
            if (this.group == null) {
                return null;
            }
            if (this.children == null) {
                Node node = PackageView.createPackageView((SourceGroup)this.group);
                Node[] nodeArray = node.getChildren().getNodes(true);
                this.children = new ModelItem[nodeArray.length];
                for (int i = 0; i < nodeArray.length; ++i) {
                    this.children[i] = new ModelItem(nodeArray[i]);
                }
            }
            return this.children;
        }
    }

    private static class ServiceCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public ServiceCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof Client) {
                Client client = (Client)object;
                this.setText(client.getName());
                this.setIcon(null);
            } else if (object instanceof DataObject) {
                DataObject dataObject = (DataObject)object;
                this.setText(dataObject.getNodeDelegate().getDisplayName());
                this.setIcon(new ImageIcon(dataObject.getNodeDelegate().getIcon(1)));
            } else {
                this.setText(object == null ? "" : object.toString());
                this.setIcon(null);
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }

    private static class ProjectCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public ProjectCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof Project) {
                ProjectInformation projectInformation = ProjectUtils.getInformation((Project)((Project)object));
                this.setText(projectInformation.getDisplayName());
                this.setIcon(projectInformation.getIcon());
            } else {
                this.setText(object == null ? "" : object.toString());
                this.setIcon(null);
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }

    private class WebProjectsActionListener
    implements ActionListener {
        WebProjectsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            WebApplicationPanel.this.enterpriseProjectsListValueChanged(actionEvent);
        }
    }

    public static class ProjectByDisplayNameComparator
    implements Comparator<Project> {
        private static Collator COLLATOR = Collator.getInstance();

        @Override
        public int compare(Project project, Project project2) {
            return COLLATOR.compare(ProjectUtils.getInformation((Project)project).getDisplayName(), ProjectUtils.getInformation((Project)project2).getDisplayName());
        }
    }
}

