/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.tools;

import com.rabbitmq.client.impl.AMQCommand;
import com.rabbitmq.client.impl.AMQContentHeader;
import com.rabbitmq.client.impl.AMQImpl;
import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.utility.BlockingCell;
import com.rabbitmq.utility.Utility;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class Tracer
implements Runnable {
    private static final int DEFAULT_LISTEN_PORT = 5673;
    private static final String DEFAULT_CONNECT_HOST = "localhost";
    private static final int DEFAULT_CONNECT_PORT = 5672;
    private static final String PROP_PREFIX = "com.rabbitmq.tools.Tracer.";
    private final Properties props;
    private final Socket inSock;
    private final Socket outSock;
    private final String idLabel;
    private final DataInputStream iis;
    private final DataOutputStream ios;
    private final DataInputStream ois;
    private final DataOutputStream oos;
    private final Logger logger;
    private final BlockingCell<Exception> reportEnd;
    private final AtomicBoolean started;

    private static boolean getBoolProperty(String propertyName, Properties props) {
        return Boolean.parseBoolean(props.getProperty(PROP_PREFIX + propertyName));
    }

    private static void printBoolProperty(String propName, Properties props) {
        StringBuilder sb = new StringBuilder(100);
        System.out.println(sb.append(PROP_PREFIX).append(propName).append(" = ").append(Tracer.getBoolProperty(propName, props)).toString());
    }

    public static void main(String[] args) {
        int listenPort = args.length > 0 ? Integer.parseInt(args[0]) : 5673;
        String connectHost = args.length > 1 ? args[1] : DEFAULT_CONNECT_HOST;
        int connectPort = args.length > 2 ? Integer.parseInt(args[2]) : 5672;
        System.out.println("Usage: Tracer [<listenport> [<connecthost> [<connectport>]]]");
        System.out.println("   Serially traces connections on the <listenport>, logging\n   frames received and passing them to the connect host and port.");
        System.out.println("Invoked as: Tracer " + listenPort + " " + connectHost + " " + connectPort);
        Properties props = System.getProperties();
        Tracer.printBoolProperty("WITHHOLD_INBOUND_HEARTBEATS", props);
        Tracer.printBoolProperty("WITHHOLD_OUTBOUND_HEARTBEATS", props);
        Tracer.printBoolProperty("NO_ASSEMBLE_FRAMES", props);
        Tracer.printBoolProperty("NO_DECODE_FRAMES", props);
        Tracer.printBoolProperty("SUPPRESS_COMMAND_BODIES", props);
        AsyncLogger logger = new AsyncLogger(System.out);
        try {
            ServerSocket server = new ServerSocket(listenPort);
            int counter = 0;
            while (true) {
                Socket conn = server.accept();
                new Tracer(conn, "Tracer-" + counter++, connectHost, connectPort, logger).start();
            }
        }
        catch (Exception e) {
            logger.stop();
            e.printStackTrace();
            System.exit(1);
            return;
        }
    }

    private Tracer(Socket sock, String id, String host, int port, Logger logger, BlockingCell<Exception> reportEnd, Properties props) throws IOException {
        this.props = props;
        this.inSock = sock;
        this.outSock = new Socket(host, port);
        this.idLabel = ": <" + id + "> ";
        this.iis = new DataInputStream(this.inSock.getInputStream());
        this.ios = new DataOutputStream(this.inSock.getOutputStream());
        this.ois = new DataInputStream(this.outSock.getInputStream());
        this.oos = new DataOutputStream(this.outSock.getOutputStream());
        this.logger = logger;
        this.reportEnd = reportEnd;
        this.started = new AtomicBoolean(false);
    }

    private Tracer(Socket sock, String id, String host, int port, Logger logger) throws IOException {
        this(sock, id, host, port, logger, new BlockingCell<Exception>(), System.getProperties());
    }

    private Tracer(int listenPort, String id, String host, int port, Logger logger, BlockingCell<Exception> reportEnd, Properties props) throws IOException {
        this(new ServerSocket(listenPort).accept(), id, host, port, logger, reportEnd, props);
    }

    public Tracer(int listenPort, String id, String host, int port, Logger logger, Properties props) throws IOException {
        this(listenPort, id, host, port, logger, new BlockingCell<Exception>(), props);
    }

    public Tracer(String id) throws IOException {
        this(5673, id, DEFAULT_CONNECT_HOST, 5672, (Logger)new AsyncLogger(System.out), new BlockingCell<Exception>(), System.getProperties());
    }

    public Tracer(String id, Properties props) throws IOException {
        this(5673, id, DEFAULT_CONNECT_HOST, 5672, (Logger)new AsyncLogger(System.out), new BlockingCell<Exception>(), props);
    }

    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.logger.start();
            new Thread(this).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            byte[] handshake = new byte[8];
            this.iis.readFully(handshake);
            this.oos.write(handshake);
            BlockingCell<Exception> wio = new BlockingCell<Exception>();
            new Thread(new DirectionHandler(wio, true, this.iis, this.oos, this.props)).start();
            new Thread(new DirectionHandler(wio, false, this.ois, this.ios, this.props)).start();
            this.waitAndLogException(wio);
        }
        catch (Exception e) {
            this.reportAndLogNonNullException(e);
        }
        finally {
            try {
                this.inSock.close();
            }
            catch (Exception e) {
                this.logException(e);
            }
            try {
                this.outSock.close();
            }
            catch (Exception e) {
                this.logException(e);
            }
            this.reportEnd.setIfUnset(null);
            this.logger.stop();
        }
    }

    private void waitAndLogException(BlockingCell<Exception> bc) throws InterruptedException {
        this.reportAndLogNonNullException(bc.get());
    }

    private void reportAndLogNonNullException(Exception e) {
        if (e != null) {
            this.reportEnd.setIfUnset(e);
            this.logException(e);
        }
    }

    public void log(String message) {
        StringBuilder sb = new StringBuilder();
        this.logger.log(sb.append(System.currentTimeMillis()).append(this.idLabel).append(message).toString());
    }

    public void logException(Exception e) {
        this.log("uncaught " + Utility.makeStackTrace(e));
    }

    private static class SafeCounter {
        private final Object countMonitor = new Object();
        private int count = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean testZeroAndIncrement() {
            Object object = this.countMonitor;
            synchronized (object) {
                int val = this.count++;
                return val == 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean decrementAndTestZero() {
            Object object = this.countMonitor;
            synchronized (object) {
                if (this.count == 0) {
                    return false;
                }
                --this.count;
                return 0 == this.count;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            Object object = this.countMonitor;
            synchronized (object) {
                this.count = 0;
            }
        }
    }

    public static class AsyncLogger
    implements Logger {
        private static final int MIN_FLUSH_INTERVAL = 100;
        private static final int ONE_SECOND_INTERVAL = 1000;
        private static final int LOG_QUEUE_SIZE = 0x100000;
        private static final int BUFFER_SIZE = 0xA00000;
        private final Runnable loggerRunnable;
        private final SafeCounter countStarted;
        private volatile Thread loggerThread = null;
        private final BlockingQueue<Pr<String, LogCmd>> queue = new ArrayBlockingQueue<Pr<String, LogCmd>>(0x100000, true);

        public AsyncLogger(OutputStream os) {
            this(os, 1000);
        }

        public AsyncLogger(OutputStream os, int flushInterval) {
            if (flushInterval < 100) {
                throw new IllegalArgumentException("Flush interval (" + flushInterval + "ms) must be positive and at least " + 100 + "ms.");
            }
            this.countStarted = new SafeCounter();
            PrintStream printStream = new PrintStream(new BufferedOutputStream(os, 0xA00000), false);
            this.loggerRunnable = new AsyncLoggerRunnable(printStream, flushInterval, this.queue);
        }

        @Override
        public void log(String message) {
            if (message != null) {
                try {
                    this.queue.put(new Pr<String, LogCmd>(message, LogCmd.PRINT));
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException("Interrupted while logging.", ie);
                }
            }
        }

        @Override
        public boolean start() {
            if (this.countStarted.testZeroAndIncrement()) {
                this.loggerThread = new Thread(this.loggerRunnable);
                this.loggerThread.start();
                return true;
            }
            return false;
        }

        @Override
        public boolean stop() {
            if (this.countStarted.decrementAndTestZero()) {
                if (this.loggerThread != null) {
                    try {
                        this.queue.put(new Pr<Object, LogCmd>(null, LogCmd.STOP));
                    }
                    catch (InterruptedException ie) {
                        this.loggerThread.interrupt();
                        throw new RuntimeException("Interrupted while stopping.", ie);
                    }
                    this.loggerThread = null;
                }
                return true;
            }
            return false;
        }

        private class AsyncLoggerRunnable
        implements Runnable {
            private final int flushInterval;
            private final PrintStream ps;
            private final BlockingQueue<Pr<String, LogCmd>> queue;

            public AsyncLoggerRunnable(PrintStream ps, int flushInterval, BlockingQueue<Pr<String, LogCmd>> queue) {
                this.flushInterval = flushInterval;
                this.ps = ps;
                this.queue = queue;
            }

            @Override
            public void run() {
                try {
                    long timeOfNextFlush = System.currentTimeMillis() + (long)this.flushInterval;
                    boolean printedSinceLastFlush = false;
                    while (true) {
                        long timeToNextFlush;
                        if (0L >= (timeToNextFlush = timeOfNextFlush - System.currentTimeMillis())) {
                            if (printedSinceLastFlush) {
                                this.ps.flush();
                                printedSinceLastFlush = false;
                            }
                            timeOfNextFlush += (long)this.flushInterval;
                            continue;
                        }
                        Pr<String, LogCmd> item = this.queue.poll(timeToNextFlush, TimeUnit.MILLISECONDS);
                        if (item == null) continue;
                        if (item.left() != null) {
                            this.ps.println(item.left());
                            printedSinceLastFlush = true;
                        }
                        if (item.right() == LogCmd.STOP) break;
                    }
                    this.drainCurrentQueue();
                    this.ps.println("Stopped.");
                    this.ps.flush();
                }
                catch (InterruptedException ie) {
                    AsyncLogger.this.countStarted.reset();
                    this.drainCurrentQueue();
                    this.ps.println("Interrupted.");
                    this.ps.flush();
                }
            }

            private void drainCurrentQueue() {
                int currentSize = this.queue.size();
                while (currentSize-- > 0) {
                    Pr item = (Pr)this.queue.poll();
                    if (item == null || item.left() == null) continue;
                    this.ps.println((String)item.left());
                }
            }
        }

        private static enum LogCmd {
            STOP,
            PRINT;

        }

        private static class Pr<L, R> {
            private final L left;
            private final R right;

            public L left() {
                return this.left;
            }

            public R right() {
                return this.right;
            }

            public Pr(L left, R right) {
                this.left = left;
                this.right = right;
            }
        }
    }

    public static interface Logger {
        public boolean start();

        public boolean stop();

        public void log(String var1);
    }

    private class DirectionHandler
    implements Runnable {
        private final BlockingCell<Exception> waitCell;
        private final boolean silentMode;
        private final boolean noDecodeFrames;
        private final boolean noAssembleFrames;
        private final boolean suppressCommandBodies;
        private final boolean writeHeartBeats;
        private final String directionIndicator;
        private final DataInputStream inStream;
        private final DataOutputStream outStream;
        private final Map<Integer, AMQCommand> commands;

        public DirectionHandler(BlockingCell<Exception> waitCell, boolean inBound, DataInputStream inStream, DataOutputStream outStream, Properties props) {
            this.waitCell = waitCell;
            this.silentMode = Tracer.getBoolProperty("SILENT_MODE", props);
            this.noDecodeFrames = Tracer.getBoolProperty("NO_DECODE_FRAMES", props);
            this.noAssembleFrames = Tracer.getBoolProperty("NO_ASSEMBLE_FRAMES", props);
            this.suppressCommandBodies = Tracer.getBoolProperty("SUPPRESS_COMMAND_BODIES", props);
            this.writeHeartBeats = inBound && !Tracer.getBoolProperty("WITHHOLD_INBOUND_HEARTBEATS", props) || !inBound && !Tracer.getBoolProperty("WITHHOLD_OUTBOUND_HEARTBEATS", props);
            this.directionIndicator = inBound ? " -> " : " <- ";
            this.inStream = inStream;
            this.outStream = outStream;
            this.commands = new HashMap<Integer, AMQCommand>();
        }

        private Frame readFrame() throws IOException {
            return Frame.readFrom(this.inStream);
        }

        private void report(int channel, Object object) {
            StringBuilder sb = new StringBuilder("ch#").append(channel).append(this.directionIndicator).append(object);
            Tracer.this.log(sb.toString());
        }

        private void reportFrame(Frame frame) throws IOException {
            switch (frame.type) {
                case 1: {
                    this.report(frame.channel, AMQImpl.readMethodFrom(frame.getInputStream()));
                    break;
                }
                case 2: {
                    AMQContentHeader contentHeader = AMQImpl.readContentHeaderFrom(frame.getInputStream());
                    long remainingBodyBytes = contentHeader.getBodySize();
                    StringBuilder sb = new StringBuilder("Expected body size: ").append(remainingBodyBytes).append("; ").append(contentHeader);
                    this.report(frame.channel, sb);
                    break;
                }
                default: {
                    this.report(frame.channel, frame);
                }
            }
        }

        private void doFrame() throws IOException {
            Frame frame = this.readFrame();
            if (frame != null) {
                if (this.silentMode) {
                    frame.writeTo(this.outStream);
                    return;
                }
                if (frame.type == 8) {
                    if (this.writeHeartBeats) {
                        frame.writeTo(this.outStream);
                        this.report(frame.channel, frame);
                    } else {
                        this.report(frame.channel, "(withheld) " + frame.toString());
                    }
                } else {
                    frame.writeTo(this.outStream);
                    if (this.noDecodeFrames) {
                        this.report(frame.channel, frame);
                    } else if (this.noAssembleFrames) {
                        this.reportFrame(frame);
                    } else {
                        AMQCommand cmd = this.commands.get(frame.channel);
                        if (cmd == null) {
                            cmd = new AMQCommand();
                            this.commands.put(frame.channel, cmd);
                        }
                        if (cmd.handleFrame(frame)) {
                            this.report(frame.channel, cmd.toString(this.suppressCommandBodies));
                            this.commands.remove(frame.channel);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    while (true) {
                        this.doFrame();
                    }
                }
                catch (Exception e) {
                    this.waitCell.setIfUnset(e);
                    this.waitCell.setIfUnset(null);
                }
            }
            catch (Throwable throwable) {
                this.waitCell.setIfUnset(null);
                throw throwable;
            }
        }
    }
}

