/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals.c14n;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import nokogiri.internals.c14n.AttrCompare;
import nokogiri.internals.c14n.CanonicalFilter;
import nokogiri.internals.c14n.CanonicalizationException;
import nokogiri.internals.c14n.CanonicalizerSpi;
import nokogiri.internals.c14n.NameSpaceSymbTable;
import nokogiri.internals.c14n.NodeFilter;
import nokogiri.internals.c14n.UtfHelpper;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public abstract class CanonicalizerBase
extends CanonicalizerSpi {
    public static final String XML = "xml";
    public static final String XMLNS = "xmlns";
    protected static final AttrCompare COMPARE = new AttrCompare();
    protected static final Attr nullNode;
    private static final byte[] END_PI;
    private static final byte[] BEGIN_PI;
    private static final byte[] END_COMM;
    private static final byte[] BEGIN_COMM;
    private static final byte[] XA;
    private static final byte[] X9;
    private static final byte[] QUOT;
    private static final byte[] XD;
    private static final byte[] GT;
    private static final byte[] LT;
    private static final byte[] END_TAG;
    private static final byte[] AMP;
    private static final byte[] equalsStr;
    protected static final int NODE_BEFORE_DOCUMENT_ELEMENT = -1;
    protected static final int NODE_NOT_BEFORE_OR_AFTER_DOCUMENT_ELEMENT = 0;
    protected static final int NODE_AFTER_DOCUMENT_ELEMENT = 1;
    private List<NodeFilter> nodeFilter;
    private final boolean includeComments;
    private Set<Node> xpathNodeSet;
    private Node excludeNode;
    private OutputStream writer = new ByteArrayOutputStream();

    public CanonicalizerBase(boolean bl) {
        this.includeComments = bl;
    }

    @Override
    public byte[] engineCanonicalizeSubTree(Node node, CanonicalFilter canonicalFilter) throws CanonicalizationException {
        return this.engineCanonicalizeSubTree(node, (Node)null, canonicalFilter);
    }

    @Override
    public void setWriter(OutputStream outputStream) {
        this.writer = outputStream;
    }

    protected byte[] engineCanonicalizeSubTree(Node node, Node node2, CanonicalFilter canonicalFilter) throws CanonicalizationException {
        this.excludeNode = node2;
        try {
            NameSpaceSymbTable nameSpaceSymbTable = new NameSpaceSymbTable();
            int n = -1;
            if (node != null && 1 == node.getNodeType()) {
                this.getParentNameSpaces((Element)node, nameSpaceSymbTable);
                n = 0;
            }
            this.canonicalizeSubTree(node, nameSpaceSymbTable, node, n, canonicalFilter);
            this.writer.flush();
            if (this.writer instanceof ByteArrayOutputStream) {
                byte[] byArray = ((ByteArrayOutputStream)this.writer).toByteArray();
                if (this.reset) {
                    ((ByteArrayOutputStream)this.writer).reset();
                } else {
                    this.writer.close();
                }
                return byArray;
            }
            this.writer.close();
            return null;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CanonicalizationException("empty", unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new CanonicalizationException("empty", iOException);
        }
    }

    protected final void canonicalizeSubTree(Node node, NameSpaceSymbTable nameSpaceSymbTable, Node node2, int n, CanonicalFilter canonicalFilter) throws CanonicalizationException, IOException {
        if (this.isVisibleInt(node) == -1) {
            return;
        }
        Node node3 = null;
        Node node4 = null;
        OutputStream outputStream = this.writer;
        Node node5 = this.excludeNode;
        boolean bl = this.includeComments;
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        while (true) {
            switch (node.getNodeType()) {
                case 2: 
                case 6: 
                case 12: {
                    throw new CanonicalizationException("empty");
                }
                case 9: 
                case 11: {
                    nameSpaceSymbTable.outputNodePush();
                    node3 = node.getFirstChild();
                    break;
                }
                case 8: {
                    if (!bl) break;
                    this.outputCommentToWriter((Comment)node, outputStream, n);
                    break;
                }
                case 7: {
                    this.outputPItoWriter((ProcessingInstruction)node, outputStream, n);
                    break;
                }
                case 3: 
                case 4: {
                    CanonicalizerBase.outputTextToWriter(node.getNodeValue(), outputStream);
                    break;
                }
                case 1: {
                    n = 0;
                    if (node == node5 || canonicalFilter != null && !canonicalFilter.includeNodes(node, node4)) break;
                    Element element = (Element)node;
                    nameSpaceSymbTable.outputNodePush();
                    outputStream.write(60);
                    String string = element.getTagName();
                    UtfHelpper.writeByte(string, outputStream, hashMap);
                    Iterator<Attr> iterator = this.handleAttributesSubtree(element, nameSpaceSymbTable);
                    if (iterator != null) {
                        while (iterator.hasNext()) {
                            Attr attr = iterator.next();
                            CanonicalizerBase.outputAttrToWriter(attr.getNodeName(), attr.getNodeValue(), outputStream, hashMap);
                        }
                    }
                    outputStream.write(62);
                    node3 = node.getFirstChild();
                    if (node3 == null) {
                        outputStream.write(END_TAG);
                        UtfHelpper.writeStringToUtf8(string, outputStream);
                        outputStream.write(62);
                        nameSpaceSymbTable.outputNodePop();
                        if (node4 == null) break;
                        node3 = node.getNextSibling();
                        break;
                    }
                    node4 = element;
                    break;
                }
            }
            while (node3 == null && node4 != null) {
                outputStream.write(END_TAG);
                UtfHelpper.writeByte(((Element)node4).getTagName(), outputStream, hashMap);
                outputStream.write(62);
                nameSpaceSymbTable.outputNodePop();
                if (node4 == node2) {
                    return;
                }
                node3 = node4.getNextSibling();
                if ((node4 = node4.getParentNode()) != null && 1 == node4.getNodeType()) continue;
                n = 1;
                node4 = null;
            }
            if (node3 == null) {
                return;
            }
            node = node3;
            node3 = node.getNextSibling();
        }
    }

    protected int isVisibleDO(Node node, int n) {
        if (this.nodeFilter != null) {
            Iterator<NodeFilter> iterator = this.nodeFilter.iterator();
            while (iterator.hasNext()) {
                int n2 = iterator.next().isNodeIncludeDO(node, n);
                if (n2 == 1) continue;
                return n2;
            }
        }
        if (this.xpathNodeSet != null && !this.xpathNodeSet.contains(node)) {
            return 0;
        }
        return 1;
    }

    protected int isVisibleInt(Node node) {
        if (this.nodeFilter != null) {
            Iterator<NodeFilter> iterator = this.nodeFilter.iterator();
            while (iterator.hasNext()) {
                int n = iterator.next().isNodeInclude(node);
                if (n == 1) continue;
                return n;
            }
        }
        if (this.xpathNodeSet != null && !this.xpathNodeSet.contains(node)) {
            return 0;
        }
        return 1;
    }

    protected boolean isVisible(Node node) {
        if (this.nodeFilter != null) {
            Iterator<NodeFilter> iterator = this.nodeFilter.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().isNodeInclude(node) == 1) continue;
                return false;
            }
        }
        return this.xpathNodeSet == null || this.xpathNodeSet.contains(node);
    }

    protected void handleParent(Element element, NameSpaceSymbTable nameSpaceSymbTable) {
        Object object;
        String string;
        Object object2;
        if (!element.hasAttributes() && element.getNamespaceURI() == null) {
            return;
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            object2 = (Attr)namedNodeMap.item(i);
            string = object2.getLocalName();
            object = object2.getNodeValue();
            if (!"http://www.w3.org/2000/xmlns/".equals(object2.getNamespaceURI()) || XML.equals(string) && "http://www.w3.org/XML/1998/namespace".equals(object)) continue;
            nameSpaceSymbTable.addMapping(string, (String)object, (Attr)object2);
        }
        if (element.getNamespaceURI() != null) {
            String string2 = element.getPrefix();
            object2 = element.getNamespaceURI();
            if (string2 == null || string2.equals("")) {
                string2 = XMLNS;
                string = XMLNS;
            } else {
                string = "xmlns:" + string2;
            }
            object = element.getOwnerDocument().createAttributeNS("http://www.w3.org/2000/xmlns/", string);
            object.setValue((String)object2);
            nameSpaceSymbTable.addMapping(string2, (String)object2, (Attr)object);
        }
    }

    protected final void getParentNameSpaces(Element element, NameSpaceSymbTable nameSpaceSymbTable) {
        Node node;
        Node node2 = element.getParentNode();
        if (node2 == null || 1 != node2.getNodeType()) {
            return;
        }
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Node node3 = node2; node3 != null && 1 == node3.getNodeType(); node3 = node3.getParentNode()) {
            arrayList.add((Element)node3);
        }
        ListIterator listIterator = arrayList.listIterator(arrayList.size());
        while (listIterator.hasPrevious()) {
            node = (Element)listIterator.previous();
            this.handleParent((Element)node, nameSpaceSymbTable);
        }
        arrayList.clear();
        node = nameSpaceSymbTable.getMappingWithoutRendered(XMLNS);
        if (node != null && "".equals(node.getValue())) {
            nameSpaceSymbTable.addMappingAndRender(XMLNS, "", nullNode);
        }
    }

    abstract Iterator<Attr> handleAttributes(Element var1, NameSpaceSymbTable var2) throws CanonicalizationException;

    abstract Iterator<Attr> handleAttributesSubtree(Element var1, NameSpaceSymbTable var2) throws CanonicalizationException;

    protected static final void outputAttrToWriter(String string, String string2, OutputStream outputStream, Map<String, byte[]> map) throws IOException {
        outputStream.write(32);
        UtfHelpper.writeByte(string, outputStream, map);
        outputStream.write(equalsStr);
        int n = string2.length();
        int n2 = 0;
        block8: while (n2 < n) {
            byte[] byArray;
            char c = string2.charAt(n2++);
            switch (c) {
                case '&': {
                    byArray = AMP;
                    break;
                }
                case '<': {
                    byArray = LT;
                    break;
                }
                case '\"': {
                    byArray = QUOT;
                    break;
                }
                case '\t': {
                    byArray = X9;
                    break;
                }
                case '\n': {
                    byArray = XA;
                    break;
                }
                case '\r': {
                    byArray = XD;
                    break;
                }
                default: {
                    if (c < '\u0080') {
                        outputStream.write(c);
                        continue block8;
                    }
                    UtfHelpper.writeCharToUtf8(c, outputStream);
                    continue block8;
                }
            }
            outputStream.write(byArray);
        }
        outputStream.write(34);
    }

    protected void outputPItoWriter(ProcessingInstruction processingInstruction, OutputStream outputStream, int n) throws IOException {
        int n2;
        if (n == 1) {
            outputStream.write(10);
        }
        outputStream.write(BEGIN_PI);
        String string = processingInstruction.getTarget();
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            n2 = string.charAt(i);
            if (n2 == 13) {
                outputStream.write(XD);
                continue;
            }
            if (n2 < 128) {
                outputStream.write(n2);
                continue;
            }
            UtfHelpper.writeCharToUtf8((char)n2, outputStream);
        }
        String string2 = processingInstruction.getData();
        n3 = string2.length();
        if (n3 > 0) {
            outputStream.write(32);
            for (n2 = 0; n2 < n3; ++n2) {
                char c = string2.charAt(n2);
                if (c == '\r') {
                    outputStream.write(XD);
                    continue;
                }
                UtfHelpper.writeCharToUtf8(c, outputStream);
            }
        }
        outputStream.write(END_PI);
        if (n == -1) {
            outputStream.write(10);
        }
    }

    protected void outputCommentToWriter(Comment comment, OutputStream outputStream, int n) throws IOException {
        if (n == 1) {
            outputStream.write(10);
        }
        outputStream.write(BEGIN_COMM);
        String string = comment.getData();
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == '\r') {
                outputStream.write(XD);
                continue;
            }
            if (c < '\u0080') {
                outputStream.write(c);
                continue;
            }
            UtfHelpper.writeCharToUtf8(c, outputStream);
        }
        outputStream.write(END_COMM);
        if (n == -1) {
            outputStream.write(10);
        }
    }

    protected static final void outputTextToWriter(String string, OutputStream outputStream) throws IOException {
        int n = string.length();
        block6: for (int i = 0; i < n; ++i) {
            byte[] byArray;
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    byArray = AMP;
                    break;
                }
                case '<': {
                    byArray = LT;
                    break;
                }
                case '>': {
                    byArray = GT;
                    break;
                }
                case '\r': {
                    byArray = XD;
                    break;
                }
                default: {
                    if (c < '\u0080') {
                        outputStream.write(c);
                        continue block6;
                    }
                    UtfHelpper.writeCharToUtf8(c, outputStream);
                    continue block6;
                }
            }
            outputStream.write(byArray);
        }
    }

    static {
        END_PI = new byte[]{63, 62};
        BEGIN_PI = new byte[]{60, 63};
        END_COMM = new byte[]{45, 45, 62};
        BEGIN_COMM = new byte[]{60, 33, 45, 45};
        XA = new byte[]{38, 35, 120, 65, 59};
        X9 = new byte[]{38, 35, 120, 57, 59};
        QUOT = new byte[]{38, 113, 117, 111, 116, 59};
        XD = new byte[]{38, 35, 120, 68, 59};
        GT = new byte[]{38, 103, 116, 59};
        LT = new byte[]{38, 108, 116, 59};
        END_TAG = new byte[]{60, 47};
        AMP = new byte[]{38, 97, 109, 112, 59};
        equalsStr = new byte[]{61, 34};
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            nullNode = documentBuilder.newDocument().createAttributeNS("http://www.w3.org/2000/xmlns/", XMLNS);
            nullNode.setValue("");
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to create nullNode: " + exception);
        }
    }
}

