/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.helper;

import com.sun.star.lang.EventObject;
import com.sun.star.lib.uno.helper.InterfaceContainer;
import com.sun.star.uno.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MultiTypeInterfaceContainer {
    private final Map<Object, InterfaceContainer> map = new HashMap<Object, InterfaceContainer>();

    public synchronized Type[] getContainedTypes() {
        Type[] typeArray = null;
        int n = this.map.size();
        if (n > 0) {
            Type[] typeArray2 = new Type[n];
            Iterator<Object> iterator = this.map.keySet().iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                Object object = iterator.next();
                InterfaceContainer interfaceContainer = this.map.get(object);
                if (interfaceContainer == null || interfaceContainer.size() <= 0) continue;
                if (object == null) {
                    typeArray2[n2++] = new Type();
                    continue;
                }
                if (object instanceof Type) {
                    typeArray2[n2++] = (Type)object;
                    continue;
                }
                if (object instanceof Class) {
                    typeArray2[n2++] = new Type((Class)object);
                    continue;
                }
                typeArray2[n2++] = new Type(object.getClass());
            }
            if (n2 != n) {
                typeArray = new Type[n2];
                System.arraycopy(typeArray2, 0, typeArray, 0, n2);
            } else {
                typeArray = typeArray2;
            }
        }
        if (typeArray == null) {
            typeArray = new Type[]{};
        }
        return typeArray;
    }

    public synchronized InterfaceContainer getContainer(Object object) {
        InterfaceContainer interfaceContainer = null;
        for (Object object2 : this.map.keySet()) {
            if (object2 == null && object == null) {
                interfaceContainer = this.map.get(null);
                break;
            }
            if (object2 == null || !object2.equals(object)) continue;
            interfaceContainer = this.map.get(object2);
            break;
        }
        return interfaceContainer;
    }

    public synchronized int addInterface(Object object, Object object2) {
        InterfaceContainer interfaceContainer = this.map.get(object);
        if (interfaceContainer != null) {
            interfaceContainer.add(object2);
        } else {
            interfaceContainer = new InterfaceContainer();
            interfaceContainer.add(object2);
            this.map.put(object, interfaceContainer);
        }
        return interfaceContainer.size();
    }

    public synchronized int removeInterface(Object object, Object object2) {
        int n = 0;
        InterfaceContainer interfaceContainer = this.map.get(object);
        if (interfaceContainer != null) {
            interfaceContainer.remove(object2);
            n = interfaceContainer.size();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeAndClear(EventObject eventObject) {
        Iterator<InterfaceContainer> iterator = null;
        MultiTypeInterfaceContainer multiTypeInterfaceContainer = this;
        synchronized (multiTypeInterfaceContainer) {
            iterator = this.map.values().iterator();
        }
        while (iterator.hasNext()) {
            iterator.next().disposeAndClear(eventObject);
        }
    }

    public synchronized void clear() {
        Iterator<InterfaceContainer> iterator = this.map.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().clear();
        }
    }
}

