/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.ui;

import com.sun.star.awt.ActionEvent;
import com.sun.star.awt.Size;
import com.sun.star.awt.XActionListener;
import com.sun.star.awt.XButton;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XFixedText;
import com.sun.star.awt.XItemEventBroadcaster;
import com.sun.star.awt.XItemListener;
import com.sun.star.awt.XWindow;
import com.sun.star.lang.EventObject;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.HelpIds;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.IRenderer;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.common.PropertySetHelper;
import com.sun.star.wizards.ui.UnoDialog2;
import com.sun.star.wizards.ui.event.XActionListenerAdapter;
import java.util.ArrayList;
import javax.swing.ListModel;

public class ButtonList
implements XItemEventBroadcaster,
XActionListener {
    private XFixedText lblImageText;
    private XButton btnBack;
    private XButton btnNext;
    private XFixedText lblCounter;
    private XControl[] m_aButtons;
    private boolean benabled = true;
    private UnoDialog2 oUnoDialog;
    private Size gap = new Size(4, 4);
    private int cols = 4;
    private int rows = 3;
    private Size m_aButtonSize = new Size(20, 20);
    private Size pos;
    private boolean showButtons = true;
    private Short step;
    private static final boolean refreshOverNull = true;
    private static final int imageTextLines = 1;
    private boolean rowSelect = false;
    public int tabIndex;
    private String m_aControlName = "il";
    private int m_nCurrentSelection = -1;
    private int pageStart = 0;
    public int helpURL = 0;
    private IImageRenderer renderer;
    private ListModel listModel;
    private IRenderer counterRenderer = new SimpleCounterRenderer();
    private static final int LINE_HEIGHT = 8;
    private Integer m_aButtonHeight;
    private Integer m_aButtonWidth;
    private Short m_tabIndex;
    private transient ArrayList<XItemListener> m_aItemListenerList;

    public void setName(String string) {
        this.m_aControlName = string;
    }

    public void setButtonSize(Size size) {
        this.m_aButtonSize = size;
    }

    public void disposing(EventObject eventObject) {
    }

    public void create(UnoDialog2 unoDialog2) {
        this.oUnoDialog = unoDialog2;
        int n = 8;
        int n2 = this.pos.Width + 1;
        int n3 = this.pos.Height + (this.m_aButtonSize.Height + this.gap.Height) * this.rows + this.gap.Height;
        int n4 = this.cols * (this.m_aButtonSize.Width + this.gap.Width) + this.gap.Width - 2;
        this.lblImageText = unoDialog2.insertLabel(this.m_aControlName + "_imageText", new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, "Tabstop", PropertyNames.PROPERTY_WIDTH}, new Object[]{n, PropertyNames.EMPTY_STRING, "(1)", n2, n3, this.step, (short)0, Boolean.FALSE, n4});
        if (this.showButtons) {
            String[] stringArray = new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, "Tabstop", PropertyNames.PROPERTY_WIDTH};
            Integer n5 = 14;
            this.btnBack = unoDialog2.insertButton(this.m_aControlName + "_btnBack", new XActionListenerAdapter(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ButtonList.this.prevPage();
                }
            }, stringArray, new Object[]{n5, HelpIds.getHelpIdString(this.helpURL++), this.pos.Width, this.pos.Height + (this.m_aButtonSize.Height + this.gap.Height) * this.rows + this.gap.Height + n + 1, this.step, (short)(this.tabIndex + 1), Boolean.TRUE, n5});
            this.btnNext = unoDialog2.insertButton(this.m_aControlName + "_btnNext", new XActionListenerAdapter(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ButtonList.this.nextPage();
                }
            }, stringArray, new Object[]{n5, HelpIds.getHelpIdString(this.helpURL++), this.pos.Width + (this.m_aButtonSize.Width + this.gap.Width) * this.cols + this.gap.Width - n5 + 1, this.pos.Height + (this.m_aButtonSize.Height + this.gap.Height) * this.rows + this.gap.Height + n + 1, this.step, (short)(this.tabIndex + 2), Boolean.TRUE, n5});
            this.lblCounter = unoDialog2.insertLabel(this.m_aControlName + "_lblCounter", stringArray, new Object[]{8, PropertyNames.EMPTY_STRING, this.pos.Width + n5 + 1, this.pos.Height + (this.m_aButtonSize.Height + this.gap.Height) * this.rows + this.gap.Height + n + (n5 - 8) / 2, this.step, (short)0, Boolean.FALSE, this.cols * (this.m_aButtonSize.Width + this.gap.Width) + this.gap.Width - 2 * n5 - 1});
            Helper.setUnoPropertyValue(this.getModel(this.lblCounter), PropertyNames.PROPERTY_ALIGN, (short)1);
            Helper.setUnoPropertyValue(this.getModel(this.btnBack), PropertyNames.PROPERTY_LABEL, "<");
            Helper.setUnoPropertyValue(this.getModel(this.btnNext), PropertyNames.PROPERTY_LABEL, ">");
        }
        this.m_tabIndex = (short)this.tabIndex;
        this.m_aButtons = new XControl[this.rows * this.cols];
        this.m_aButtonHeight = this.m_aButtonSize.Height;
        this.m_aButtonWidth = this.m_aButtonSize.Width;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                XControl xControl;
                XButton xButton = this.createButton(unoDialog2, i, j);
                this.m_aButtons[i * this.cols + j] = xControl = (XControl)UnoRuntime.queryInterface(XControl.class, (Object)xButton);
            }
        }
        this.refreshImages();
    }

    private XButton createButton(UnoDialog2 unoDialog2, int n, int n2) {
        String string = this.m_aControlName + "_button" + (n * this.cols + n2);
        int n3 = this.getButtonPosX(n2);
        int n4 = this.getButtonPosY(n);
        XButton xButton = unoDialog2.insertImageButton(string, this, new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, "Tabstop", "Toggle", PropertyNames.PROPERTY_WIDTH}, new Object[]{this.m_aButtonHeight, HelpIds.getHelpIdString(this.helpURL++), n3, n4, this.step, this.m_tabIndex, Boolean.TRUE, Boolean.TRUE, this.m_aButtonWidth});
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xButton);
        xWindow.setEnable(true);
        xWindow.setVisible(true);
        return xButton;
    }

    private int getButtonPosX(int n) {
        return this.pos.Width + n * (this.m_aButtonSize.Width + this.gap.Width) + this.gap.Width;
    }

    private int getButtonPosY(int n) {
        return this.pos.Height + n * (this.m_aButtonSize.Height + this.gap.Height) + this.gap.Height;
    }

    private void refreshImages() {
        int n;
        if (this.showButtons) {
            this.refreshCounterText();
        }
        for (n = 0; n < this.m_aButtons.length; ++n) {
            this.setVisible(this.m_aButtons[n], false);
        }
        for (n = 0; n < this.m_aButtons.length; ++n) {
            Object[] objectArray;
            Object object = this.getObjectFor(n);
            if (object == null || (objectArray = this.renderer.getImageUrls(object)) == null) continue;
            if (objectArray.length == 1) {
                Helper.setUnoPropertyValue(this.m_aButtons[n].getModel(), PropertyNames.PROPERTY_IMAGEURL, objectArray[0]);
            } else if (objectArray.length == 2) {
                this.oUnoDialog.getPeerConfiguration().setImageUrl((Object)this.m_aButtons[n].getModel(), objectArray[0], objectArray[1]);
            }
            boolean bl = Boolean.TRUE;
            Helper.setUnoPropertyValue(this.m_aButtons[n].getModel(), "Tabstop", bl);
            this.setVisible(this.m_aButtons[n], true);
        }
    }

    private void refreshCounterText() {
        Helper.setUnoPropertyValue(this.getModel(this.lblCounter), PropertyNames.PROPERTY_LABEL, this.counterRenderer.render(new Counter(this.pageStart + 1, this.pageEnd(), this.listModel.getSize())));
    }

    private int pageEnd() {
        int n = this.pageStart + this.cols * this.rows;
        if (n > this.listModel.getSize() - 1) {
            return this.listModel.getSize();
        }
        return n;
    }

    private void setVisible(Object object, boolean bl) {
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)object);
        xWindow.setVisible(bl);
    }

    private Object getObjectFor(int n) {
        int n2 = this.getIndexFor(n);
        if (this.listModel.getSize() <= n2) {
            return null;
        }
        return this.listModel.getElementAt(n2);
    }

    private int getIndexFor(int n) {
        return this.pageStart + n;
    }

    public synchronized void addItemListener(XItemListener xItemListener) {
        if (this.m_aItemListenerList == null) {
            this.m_aItemListenerList = new ArrayList();
        }
        this.m_aItemListenerList.add(xItemListener);
    }

    public synchronized void removeItemListener(XItemListener xItemListener) {
        if (this.m_aItemListenerList != null) {
            this.m_aItemListenerList.remove(xItemListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireItemSelected() {
        ArrayList arrayList;
        ButtonList buttonList = this;
        synchronized (buttonList) {
            if (this.m_aItemListenerList == null) {
                return;
            }
            arrayList = (ArrayList)this.m_aItemListenerList.clone();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            ((XItemListener)arrayList.get(i)).itemStateChanged(null);
        }
    }

    private ListModel getListModel() {
        return this.listModel;
    }

    public int getSelected() {
        return this.m_nCurrentSelection;
    }

    public void setCols(int n) {
        this.cols = n;
    }

    public void setGap(Size size) {
        this.gap = size;
    }

    public void setListModel(ListModel listModel) {
        this.listModel = listModel;
    }

    public void setStep(Short s) {
        this.step = s;
    }

    private void setPageStart(int n) {
        if (n == this.pageStart) {
            return;
        }
        this.pageStart = n;
        this.enableButtons();
        this.refreshImages();
    }

    public void setPos(Size size) {
        this.pos = size;
    }

    public void setRenderer(IImageRenderer iImageRenderer) {
        this.renderer = iImageRenderer;
    }

    public void setRows(int n) {
        this.rows = n;
    }

    public void setSelected(int n) {
        if (this.rowSelect && n >= 0) {
            n = n / this.cols * this.cols;
        }
        if (this.m_nCurrentSelection == n) {
            return;
        }
        this.m_nCurrentSelection = n;
        this.refreshImageText();
        this.refreshSelection();
        this.fireItemSelected();
    }

    private void refreshImageText() {
        Object var1_1 = this.m_nCurrentSelection >= 0 ? this.getListModel().getElementAt(this.m_nCurrentSelection) : null;
        String string = PropertyNames.SPACE + this.renderer.render(var1_1);
        Helper.setUnoPropertyValue(this.getModel(this.lblImageText), PropertyNames.PROPERTY_LABEL, string);
    }

    public void setShowButtons(boolean bl) {
        this.showButtons = bl;
    }

    private void nextPage() {
        if (this.pageStart < this.getListModel().getSize() - this.rows * this.cols) {
            this.setPageStart(this.pageStart + this.rows * this.cols);
        }
    }

    private void prevPage() {
        if (this.pageStart == 0) {
            return;
        }
        int n = this.pageStart - this.rows * this.cols;
        if (n < 0) {
            n = 0;
        }
        this.setPageStart(n);
    }

    private void enableButtons() {
        this.enable(this.btnNext, this.pageStart + this.rows * this.cols < this.listModel.getSize());
        this.enable(this.btnBack, this.pageStart > 0);
    }

    private void enable(Object object, Boolean bl) {
        Helper.setUnoPropertyValue(this.getModel(object), PropertyNames.PROPERTY_ENABLED, bl);
    }

    private Object getModel(Object object) {
        return ((XControl)UnoRuntime.queryInterface(XControl.class, (Object)object)).getModel();
    }

    public boolean isenabled() {
        return this.benabled;
    }

    public void setenabled(boolean bl) {
        for (int i = 0; i < this.m_aButtons.length; ++i) {
            UnoDialog2.setEnabled((Object)this.m_aButtons[i], bl);
        }
        UnoDialog2.setEnabled((Object)this.lblImageText, bl);
        if (this.showButtons) {
            UnoDialog2.setEnabled((Object)this.btnBack, bl);
            UnoDialog2.setEnabled((Object)this.btnNext, bl);
            UnoDialog2.setEnabled((Object)this.lblCounter, bl);
        }
        this.benabled = bl;
    }

    private void refreshSelection() {
        for (int i = 0; i < this.m_aButtons.length; ++i) {
            if (this.m_aButtons[i] == null) continue;
            XControlModel xControlModel = (XControlModel)UnoDialog2.getModel(this.m_aButtons[i]);
            PropertySetHelper propertySetHelper = new PropertySetHelper(xControlModel);
            if (i == this.m_nCurrentSelection) {
                propertySetHelper.setPropertyValueDontThrow(PropertyNames.PROPERTY_STATE, (short)1);
                continue;
            }
            propertySetHelper.setPropertyValueDontThrow(PropertyNames.PROPERTY_STATE, (short)0);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        String string2;
        int n;
        int n2;
        XControlModel xControlModel = (XControlModel)UnoDialog2.getModel(actionEvent.Source);
        PropertySetHelper propertySetHelper = new PropertySetHelper(xControlModel);
        int n3 = propertySetHelper.getPropertyValueAsInteger(PropertyNames.PROPERTY_STATE, -1);
        if (n3 == 0) {
            propertySetHelper.setPropertyValueDontThrow(PropertyNames.PROPERTY_STATE, (short)1);
        }
        if ((n2 = this.getIndexFor(n = Integer.parseInt(string2 = (string = propertySetHelper.getPropertyValueAsString(PropertyNames.PROPERTY_NAME, PropertyNames.EMPTY_STRING)).substring(7 + this.m_aControlName.length())))) < this.listModel.getSize()) {
            this.setSelected(n2);
        }
    }

    private static class Counter {
        private int start;
        private int end;
        private int max;

        private Counter(int n, int n2, int n3) {
            this.start = n;
            this.end = n2;
            this.max = n3;
        }
    }

    private static class SimpleCounterRenderer
    implements IRenderer {
        private SimpleCounterRenderer() {
        }

        public String render(Object object) {
            return PropertyNames.EMPTY_STRING + ((Counter)object).start + ".." + ((Counter)object).end + "/" + ((Counter)object).max;
        }
    }

    public static interface IImageRenderer
    extends IRenderer {
        public Object[] getImageUrls(Object var1);
    }
}

