/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.NotificationManager;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;

public class Notification {
    public static final int DEFAULT_CONTENT_WIDTH = 350;
    public static final int TIME_SHORT = Main.pref.getInteger("notification-time-short-ms", 3000);
    public static final int TIME_DEFAULT = Main.pref.getInteger("notification-time-default-ms", 5000);
    public static final int TIME_LONG = Main.pref.getInteger("notification-time-long-ms", 10000);
    public static final int TIME_VERY_LONG = Main.pref.getInteger("notification-time-very_long-ms", 20000);
    private Component content;
    private int duration = NotificationManager.defaultNotificationTime;
    private Icon icon;
    private String helpTopic;

    public Notification() {
    }

    public Notification(String string) {
        this();
        this.setContent(string);
    }

    public Notification setContent(Component component) {
        this.content = component;
        return this;
    }

    public Notification setContent(String string) {
        JMultilineLabel jMultilineLabel = new JMultilineLabel(string);
        jMultilineLabel.setMaxWidth(350);
        jMultilineLabel.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jMultilineLabel.setForeground(Color.BLACK);
        this.content = jMultilineLabel;
        return this;
    }

    public Notification setDuration(int n) {
        this.duration = n;
        return this;
    }

    public Notification setIcon(Icon icon) {
        this.icon = icon;
        return this;
    }

    public Notification setIcon(int n) {
        switch (n) {
            case 0: {
                return this.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
            }
            case 1: {
                return this.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
            }
            case 2: {
                return this.setIcon(UIManager.getIcon("OptionPane.warningIcon"));
            }
            case 3: {
                return this.setIcon(UIManager.getIcon("OptionPane.questionIcon"));
            }
            case -1: {
                return this.setIcon(null);
            }
        }
        throw new IllegalArgumentException("Unknown message type!");
    }

    public Notification setHelpTopic(String string) {
        this.helpTopic = string;
        return this;
    }

    public Component getContent() {
        return this.content;
    }

    public int getDuration() {
        return this.duration;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getHelpTopic() {
        return this.helpTopic;
    }

    public void show() {
        NotificationManager.getInstance().showNotification(this);
    }
}

