/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.classic;

import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;

public class MultiFieldQueryParser
extends QueryParser {
    protected String[] fields;
    protected Map<String, Float> boosts;

    public MultiFieldQueryParser(String[] fields, Analyzer analyzer, Map<String, Float> boosts) {
        this(fields, analyzer);
        this.boosts = boosts;
    }

    public MultiFieldQueryParser(String[] fields, Analyzer analyzer) {
        super(null, analyzer);
        this.fields = fields;
    }

    @Override
    protected Query getFieldQuery(String field, String queryText, int slop) throws ParseException {
        if (field == null) {
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (int i = 0; i < this.fields.length; ++i) {
                Float boost;
                Query q = super.getFieldQuery(this.fields[i], queryText, true);
                if (q == null) continue;
                if (this.boosts != null && (boost = this.boosts.get(this.fields[i])) != null) {
                    q = new BoostQuery(q, boost.floatValue());
                }
                q = this.applySlop(q, slop);
                clauses.add(new BooleanClause(q, BooleanClause.Occur.SHOULD));
            }
            if (clauses.size() == 0) {
                return null;
            }
            return this.getBooleanQuery(clauses, true);
        }
        Query q = super.getFieldQuery(field, queryText, true);
        q = this.applySlop(q, slop);
        return q;
    }

    private Query applySlop(Query q, int slop) {
        if (q instanceof PhraseQuery) {
            PhraseQuery.Builder builder = new PhraseQuery.Builder();
            builder.setSlop(slop);
            PhraseQuery pq = (PhraseQuery)q;
            Term[] terms = pq.getTerms();
            int[] positions = pq.getPositions();
            for (int i = 0; i < terms.length; ++i) {
                builder.add(terms[i], positions[i]);
            }
            q = builder.build();
        } else if (q instanceof MultiPhraseQuery) {
            ((MultiPhraseQuery)q).setSlop(slop);
        }
        return q;
    }

    @Override
    protected Query getFieldQuery(String field, String queryText, boolean quoted) throws ParseException {
        if (field == null) {
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (int i = 0; i < this.fields.length; ++i) {
                Float boost;
                Query q = super.getFieldQuery(this.fields[i], queryText, quoted);
                if (q == null) continue;
                if (this.boosts != null && (boost = this.boosts.get(this.fields[i])) != null) {
                    q = new BoostQuery(q, boost.floatValue());
                }
                clauses.add(new BooleanClause(q, BooleanClause.Occur.SHOULD));
            }
            if (clauses.size() == 0) {
                return null;
            }
            return this.getBooleanQuery(clauses, true);
        }
        Query q = super.getFieldQuery(field, queryText, quoted);
        return q;
    }

    @Override
    protected Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
        if (field == null) {
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (int i = 0; i < this.fields.length; ++i) {
                clauses.add(new BooleanClause(this.getFuzzyQuery(this.fields[i], termStr, minSimilarity), BooleanClause.Occur.SHOULD));
            }
            return this.getBooleanQuery(clauses, true);
        }
        return super.getFuzzyQuery(field, termStr, minSimilarity);
    }

    @Override
    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        if (field == null) {
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (int i = 0; i < this.fields.length; ++i) {
                clauses.add(new BooleanClause(this.getPrefixQuery(this.fields[i], termStr), BooleanClause.Occur.SHOULD));
            }
            return this.getBooleanQuery(clauses, true);
        }
        return super.getPrefixQuery(field, termStr);
    }

    @Override
    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        if (field == null) {
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (int i = 0; i < this.fields.length; ++i) {
                clauses.add(new BooleanClause(this.getWildcardQuery(this.fields[i], termStr), BooleanClause.Occur.SHOULD));
            }
            return this.getBooleanQuery(clauses, true);
        }
        return super.getWildcardQuery(field, termStr);
    }

    @Override
    protected Query getRangeQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) throws ParseException {
        if (field == null) {
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (int i = 0; i < this.fields.length; ++i) {
                clauses.add(new BooleanClause(this.getRangeQuery(this.fields[i], part1, part2, startInclusive, endInclusive), BooleanClause.Occur.SHOULD));
            }
            return this.getBooleanQuery(clauses, true);
        }
        return super.getRangeQuery(field, part1, part2, startInclusive, endInclusive);
    }

    @Override
    protected Query getRegexpQuery(String field, String termStr) throws ParseException {
        if (field == null) {
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (int i = 0; i < this.fields.length; ++i) {
                clauses.add(new BooleanClause(this.getRegexpQuery(this.fields[i], termStr), BooleanClause.Occur.SHOULD));
            }
            return this.getBooleanQuery(clauses, true);
        }
        return super.getRegexpQuery(field, termStr);
    }

    public static Query parse(String[] queries, String[] fields, Analyzer analyzer) throws ParseException {
        if (queries.length != fields.length) {
            throw new IllegalArgumentException("queries.length != fields.length");
        }
        BooleanQuery.Builder bQuery = new BooleanQuery.Builder();
        for (int i = 0; i < fields.length; ++i) {
            QueryParser qp = new QueryParser(fields[i], analyzer);
            Query q = qp.parse(queries[i]);
            if (q == null || q instanceof BooleanQuery && ((BooleanQuery)q).clauses().size() <= 0) continue;
            bQuery.add(q, BooleanClause.Occur.SHOULD);
        }
        return bQuery.build();
    }

    public static Query parse(String query, String[] fields, BooleanClause.Occur[] flags, Analyzer analyzer) throws ParseException {
        if (fields.length != flags.length) {
            throw new IllegalArgumentException("fields.length != flags.length");
        }
        BooleanQuery.Builder bQuery = new BooleanQuery.Builder();
        for (int i = 0; i < fields.length; ++i) {
            QueryParser qp = new QueryParser(fields[i], analyzer);
            Query q = qp.parse(query);
            if (q == null || q instanceof BooleanQuery && ((BooleanQuery)q).clauses().size() <= 0) continue;
            bQuery.add(q, flags[i]);
        }
        return bQuery.build();
    }

    public static Query parse(String[] queries, String[] fields, BooleanClause.Occur[] flags, Analyzer analyzer) throws ParseException {
        if (queries.length != fields.length || queries.length != flags.length) {
            throw new IllegalArgumentException("queries, fields, and flags array have have different length");
        }
        BooleanQuery.Builder bQuery = new BooleanQuery.Builder();
        for (int i = 0; i < fields.length; ++i) {
            QueryParser qp = new QueryParser(fields[i], analyzer);
            Query q = qp.parse(queries[i]);
            if (q == null || q instanceof BooleanQuery && ((BooleanQuery)q).clauses().size() <= 0) continue;
            bQuery.add(q, flags[i]);
        }
        return bQuery.build();
    }
}

