/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.actions.ConfigureWindowWorkingSetsDialog;
import org.eclipse.ui.internal.registry.WorkingSetRegistry;

public class SelectWorkingSetsAction
implements IWorkbenchWindowActionDelegate,
IWorkbenchWindowPulldownDelegate2 {
    private Menu menubarMenu;
    private Menu toolbarMenu;
    private IWorkbenchWindow window;

    public void dispose() {
        if (this.menubarMenu != null) {
            this.menubarMenu.dispose();
            this.menubarMenu = null;
        }
        if (this.toolbarMenu != null) {
            this.toolbarMenu.dispose();
            this.toolbarMenu = null;
        }
    }

    private void fillMenu(Menu menu) {
        IWorkingSet[][] typedSets = this.splitSets();
        int i = 0;
        while (i < typedSets.length) {
            IWorkingSet[] sets = typedSets[i];
            int j = 0;
            while (j < sets.length) {
                IWorkingSet set = sets[j];
                ActionContributionItem item = new ActionContributionItem((IAction)new ToggleWorkingSetAction(set));
                item.fill(menu, -1);
                ++j;
            }
            Separator separator = new Separator();
            separator.fill(menu, -1);
            ++i;
        }
        ActionContributionItem item = new ActionContributionItem((IAction)new ManageWorkingSetsAction());
        item.fill(menu, -1);
    }

    private IWorkingSet[] getEnabledSets() {
        return this.window.getActivePage().getWorkingSets();
    }

    public Menu getMenu(Control parent) {
        if (this.toolbarMenu != null) {
            this.toolbarMenu.dispose();
        }
        this.toolbarMenu = new Menu(parent);
        this.initMenu(this.toolbarMenu);
        return this.toolbarMenu;
    }

    public Menu getMenu(Menu parent) {
        if (this.menubarMenu != null) {
            this.menubarMenu.dispose();
        }
        this.menubarMenu = new Menu(parent);
        this.initMenu(this.menubarMenu);
        return this.menubarMenu;
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    private void initMenu(Menu menu) {
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu m = (Menu)e.widget;
                MenuItem[] items = m.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                SelectWorkingSetsAction.this.fillMenu(m);
            }
        });
    }

    private boolean isWorkingSetEnabled(IWorkingSet set) {
        IWorkingSet[] enabledSets = this.getEnabledSets();
        int i = 0;
        while (i < enabledSets.length) {
            if (enabledSets[i].equals(set)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void run(IAction action) {
        ConfigureWindowWorkingSetsDialog dialog = new ConfigureWindowWorkingSetsDialog(this.window);
        dialog.open();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private IWorkingSet[][] splitSets() {
        IWorkingSet[] allSets = this.window.getWorkbench().getWorkingSetManager().getWorkingSets();
        HashMap<String, ArrayList<IWorkingSet>> map = new HashMap<String, ArrayList<IWorkingSet>>();
        WorkingSetRegistry registry = WorkbenchPlugin.getDefault().getWorkingSetRegistry();
        int i = 0;
        while (i < allSets.length) {
            String setType = allSets[i].getId();
            if (!WorkbenchActivityHelper.filterItem(registry.getWorkingSetDescriptor(setType))) {
                ArrayList<IWorkingSet> setsOfType = (ArrayList<IWorkingSet>)map.get(setType);
                if (setsOfType == null) {
                    setsOfType = new ArrayList<IWorkingSet>();
                    map.put(setType, setsOfType);
                }
                setsOfType.add(allSets[i]);
            }
            ++i;
        }
        IWorkingSet[][] typedSets = new IWorkingSet[map.keySet().size()][];
        int i2 = 0;
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            List setsOfType = (List)map.get(iter.next());
            typedSets[i2] = new IWorkingSet[setsOfType.size()];
            setsOfType.toArray(typedSets[i2++]);
        }
        return typedSets;
    }

    private class ManageWorkingSetsAction
    extends Action {
        ManageWorkingSetsAction() {
            super(WorkbenchMessages.Edit);
        }

        public void run() {
            SelectWorkingSetsAction.this.run((IAction)this);
        }
    }

    private class ToggleWorkingSetAction
    extends Action {
        private IWorkingSet set;

        ToggleWorkingSetAction(IWorkingSet set) {
            super(set.getLabel(), 2);
            this.setImageDescriptor(set.getImage());
            this.set = set;
            this.setChecked(SelectWorkingSetsAction.this.isWorkingSetEnabled(set));
        }

        public void run() {
            HashSet<IWorkingSet> newList = new HashSet<IWorkingSet>((Collection)Arrays.asList(SelectWorkingSetsAction.this.window.getActivePage().getWorkingSets()));
            if (this.isChecked()) {
                newList.add(this.set);
            } else {
                newList.remove(this.set);
            }
            SelectWorkingSetsAction.this.window.getActivePage().setWorkingSets(newList.toArray(new IWorkingSet[newList.size()]));
        }
    }
}

