/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.commentelement.impl;

import org.eclipse.wst.xml.core.internal.commentelement.CommentElementHandler;
import org.eclipse.wst.xml.core.internal.commentelement.util.CommentElementFactory;
import org.eclipse.wst.xml.core.internal.commentelement.util.TagScanner;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.ISourceGenerator;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

class BasicCommentElementHandler
implements CommentElementHandler {
    private String elementName;
    private boolean isEmpty;

    public BasicCommentElementHandler(String elementName, boolean isEmpty) {
        this.elementName = elementName;
        this.isEmpty = isEmpty;
    }

    public Element createElement(Document document, String data, boolean isJSPTag) {
        Element element = null;
        String str = data.trim();
        CommentElementFactory factory = new CommentElementFactory(document, isJSPTag, this);
        if (str.charAt(0) == '/') {
            TagScanner scanner = new TagScanner(str, 1);
            String name = scanner.nextName();
            if (name.equals(this.elementName)) {
                element = factory.create(name, 1808);
            }
        } else {
            TagScanner scanner = new TagScanner(str, 0);
            String name = scanner.nextName();
            if (name.equals(this.elementName)) {
                element = factory.create(name, this.isEmpty ? 4866 : 28011);
                String attrName = scanner.nextName();
                while (attrName != null) {
                    String attrValue = scanner.nextValue();
                    Attr attr = document.createAttribute(attrName);
                    if (attr != null) {
                        if (attrValue != null) {
                            ((IDOMAttr)attr).setValueSource(attrValue);
                        }
                        element.setAttributeNode(attr);
                    }
                    attrName = scanner.nextName();
                }
            }
        }
        return element;
    }

    public String generateEndTagContent(IDOMElement element) {
        if (this.isEmpty) {
            return null;
        }
        ISourceGenerator generator = element.getModel().getGenerator();
        StringBuffer buffer = new StringBuffer();
        buffer.append(" /");
        String tagName = generator.generateTagName(element);
        if (tagName != null) {
            buffer.append(tagName);
        }
        buffer.append(' ');
        return buffer.toString();
    }

    public String generateStartTagContent(IDOMElement element) {
        ISourceGenerator generator = element.getModel().getGenerator();
        StringBuffer buffer = new StringBuffer();
        buffer.append(' ');
        String tagName = generator.generateTagName(element);
        if (tagName != null) {
            buffer.append(tagName);
        }
        NamedNodeMap attributes = element.getAttributes();
        int length = attributes.getLength();
        int i = 0;
        while (i < length) {
            Attr attr = (Attr)attributes.item(i);
            if (attr != null) {
                String attrValue;
                buffer.append(' ');
                String attrName = generator.generateAttrName(attr);
                if (attrName != null) {
                    buffer.append(attrName);
                }
                if ((attrValue = generator.generateAttrValue(attr)) != null) {
                    buffer.append('=');
                    buffer.append(attrValue);
                }
            }
            ++i;
        }
        buffer.append(' ');
        return buffer.toString();
    }

    public boolean isCommentElement(IDOMElement element) {
        return element != null && element.getTagName().equals(this.elementName);
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }
}

