/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.ui.internal.editor;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatConfiguration;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatServer;
import org.eclipse.jst.server.tomcat.core.internal.WebModule;
import org.eclipse.jst.server.tomcat.ui.internal.Messages;
import org.eclipse.jst.server.tomcat.ui.internal.Trace;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.ui.ServerUICore;

public class WebModuleDialog
extends Dialog {
    protected IModule module4;
    protected WebModule module;
    protected boolean isEdit;
    protected boolean isProject;
    protected Text docBase;
    protected IServerAttributes server2;
    protected ITomcatServer server;
    protected ITomcatConfiguration config;
    protected Table projTable;
    static /* synthetic */ Class class$0;

    public WebModuleDialog(Shell parentShell, IServerAttributes server2, ITomcatServer server, ITomcatConfiguration config, WebModule module) {
        super(parentShell);
        this.module = module;
        this.server2 = server2;
        this.server = server;
        this.config = config;
        this.isEdit = true;
    }

    public WebModuleDialog(Shell parentShell, IServerAttributes server2, ITomcatServer server, ITomcatConfiguration config, boolean isProject) {
        this(parentShell, server2, server, config, new WebModule("/", "", null, true));
        this.isEdit = false;
        this.isProject = isProject;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.isEdit) {
            newShell.setText(Messages.configurationEditorWebModuleDialogTitleEdit);
        } else {
            newShell.setText(Messages.configurationEditorWebModuleDialogTitleAdd);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)composite, "org.eclipse.jst.server.tomcat.ui.tdwm0000");
        if (!this.isEdit && this.isProject) {
            Label l = new Label(composite, 0);
            l.setText(Messages.configurationEditorWebModuleDialogProjects);
            GridData data = new GridData(2);
            l.setLayoutData((Object)data);
            this.projTable = new Table(composite, 2820);
            data = new GridData();
            data.widthHint = 150;
            data.heightHint = 75;
            this.projTable.setLayoutData((Object)data);
            whs.setHelp((Control)this.projTable, "org.eclipse.jst.server.tomcat.ui.tdpr0002");
            ILabelProvider labelProvider = ServerUICore.getLabelProvider();
            IModule[] modules = ServerUtil.getModules((IModuleType[])this.server2.getServerType().getRuntimeType().getModuleTypes());
            if (modules != null) {
                int size = modules.length;
                int i = 0;
                while (i < size) {
                    IStatus status;
                    IModule module3 = modules[i];
                    if ("jst.web".equals(module3.getModuleType().getId()) && (status = this.server2.canModifyModules(new IModule[]{module3}, null, null)) != null && status.isOK()) {
                        TableItem item = new TableItem(this.projTable, 0);
                        item.setText(0, labelProvider.getText((Object)module3));
                        item.setImage(0, labelProvider.getImage((Object)module3));
                        item.setData((Object)module3);
                    }
                    ++i;
                }
            }
            labelProvider.dispose();
            new Label(composite, 0).setText(" ");
        }
        new Label(composite, 0).setText(Messages.configurationEditorWebModuleDialogDocumentBase);
        this.docBase = new Text(composite, 2048);
        GridData data = new GridData(256);
        this.docBase.setLayoutData((Object)data);
        this.docBase.setText(this.module.getDocumentBase());
        whs.setHelp((Control)this.docBase, "org.eclipse.jst.server.tomcat.ui.tdpr0006");
        if (this.isProject || this.module.getMemento() != null && this.module.getMemento().length() > 0) {
            this.docBase.setEditable(false);
        } else {
            this.docBase.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    WebModuleDialog.this.module = new WebModule(WebModuleDialog.this.module.getPath(), WebModuleDialog.this.docBase.getText(), WebModuleDialog.this.module.getMemento(), WebModuleDialog.this.module.isReloadable());
                    WebModuleDialog.this.validate();
                }
            });
        }
        if (this.isEdit || this.isProject) {
            new Label(composite, 0).setText(" ");
        } else {
            Button browse = new Button(composite, 0);
            browse.setText(Messages.browse);
            browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    try {
                        DirectoryDialog dialog = new DirectoryDialog(WebModuleDialog.this.getShell());
                        dialog.setMessage(Messages.configurationEditorWebModuleDialogSelectDirectory);
                        String selectedDirectory = dialog.open();
                        if (selectedDirectory != null) {
                            WebModuleDialog.this.docBase.setText(selectedDirectory);
                        }
                    }
                    catch (Exception e) {
                        Trace.trace(Trace.SEVERE, "Error browsing", e);
                    }
                }
            });
        }
        new Label(composite, 0).setText(Messages.configurationEditorWebModuleDialogPath);
        final Text path = new Text(composite, 2048);
        data = new GridData(256);
        data.widthHint = 150;
        path.setLayoutData((Object)data);
        path.setText(this.module.getPath());
        path.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebModuleDialog.this.module = new WebModule(path.getText(), WebModuleDialog.this.module.getDocumentBase(), WebModuleDialog.this.module.getMemento(), WebModuleDialog.this.module.isReloadable());
            }
        });
        whs.setHelp((Control)path, "org.eclipse.jst.server.tomcat.ui.tdpr0004");
        new Label(composite, 0).setText("");
        if (!this.isProject) {
            new Label(composite, 0).setText("");
            final Button reloadable = new Button(composite, 32);
            reloadable.setText(Messages.configurationEditorWebModuleDialogReloadEnabled);
            data = new GridData(256);
            reloadable.setLayoutData((Object)data);
            reloadable.setSelection(this.module.isReloadable());
            reloadable.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WebModuleDialog.this.module = new WebModule(WebModuleDialog.this.module.getPath(), WebModuleDialog.this.module.getDocumentBase(), WebModuleDialog.this.module.getMemento(), reloadable.getSelection());
                }
            });
            whs.setHelp((Control)reloadable, "org.eclipse.jst.server.tomcat.ui.tdpr0008");
        }
        if (!this.isEdit && this.isProject) {
            this.projTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    try {
                        IWebModule module2;
                        String contextRoot;
                        IModule module3 = (IModule)WebModuleDialog.this.projTable.getSelection()[0].getData();
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("org.eclipse.jst.server.core.IWebModule");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((contextRoot = (module2 = (IWebModule)module3.loadAdapter((Class)clazz, null)).getContextRoot()) != null && !contextRoot.startsWith("/") && contextRoot.length() > 0) {
                            contextRoot = "/" + contextRoot;
                        }
                        WebModuleDialog.this.module = new WebModule(contextRoot, module3.getName(), module3.getId(), WebModuleDialog.this.module.isReloadable());
                        WebModuleDialog.this.docBase.setText(module3.getName());
                        path.setText(contextRoot);
                        WebModuleDialog.this.module4 = module3;
                    }
                    catch (Exception exception) {}
                    WebModuleDialog.this.validate();
                }
            });
            new Label(composite, 0).setText("");
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.validate();
        return control;
    }

    protected void validate() {
        boolean ok = true;
        if (this.module.getDocumentBase() == null || this.module.getDocumentBase().length() < 1) {
            ok = false;
        }
        this.getButton(0).setEnabled(ok);
    }

    public WebModule getWebModule() {
        return this.module;
    }
}

