/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ProtocolStateMachine;
import org.eclipse.uml2.uml.RedefinableElement;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.internal.operations.NamespaceOperations;
import org.eclipse.uml2.uml.internal.operations.RedefinableElementOperations;
import org.eclipse.uml2.uml.internal.operations.StateMachineOperations;
import org.eclipse.uml2.uml.internal.operations.StateOperations;

public class RegionOperations
extends NamespaceOperations {
    protected RegionOperations() {
    }

    public static boolean validateInitialVertex(Region region, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static boolean validateDeepHistoryVertex(Region region, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static boolean validateShallowHistoryVertex(Region region, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static boolean validateOwned(Region region, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static Classifier redefinitionContext(Region region) {
        StateMachine sm = region.containingStateMachine();
        if (sm != null) {
            BehavioredClassifier context = sm.getContext();
            return context == null || !sm.getGenerals().isEmpty() ? sm : context;
        }
        return null;
    }

    public static boolean isRedefinitionContextValid(Region region, Region redefined) {
        if (redefined != null) {
            StateMachine stateMachine = region.getStateMachine();
            if (stateMachine != null) {
                return StateMachineOperations.getAllExtendedStateMachines(stateMachine).contains((Object)redefined.getStateMachine());
            }
            State state = region.getState();
            return state != null && StateOperations.getAllRedefinedStates(state).contains((Object)redefined.getState());
        }
        return false;
    }

    public static StateMachine containingStateMachine(Region region) {
        StateMachine stateMachine = region.getStateMachine();
        if (stateMachine == null) {
            State state = region.getState();
            return state == null ? null : state.containingStateMachine();
        }
        return stateMachine;
    }

    public static boolean belongsToPSM(Region region) {
        StateMachine stateMachine = region.getStateMachine();
        if (stateMachine != null) {
            return stateMachine instanceof ProtocolStateMachine;
        }
        State state = region.getState();
        if (state != null) {
            Region container = state.getContainer();
            return container != null && container.belongsToPSM();
        }
        return false;
    }

    public static boolean isConsistentWith(Region region, RedefinableElement redefinee) {
        if (redefinee != null && redefinee.isRedefinitionContextValid(region)) {
            Region redefineeRegion = (Region)redefinee;
            EList allSubvertices = RegionOperations.getAllSubvertices(region);
            Iterator redefineeSubvertices = redefineeRegion.getSubvertices().iterator();
            while (redefineeSubvertices.hasNext()) {
                State redefinedState;
                Vertex redefineeSubvertex = (Vertex)redefineeSubvertices.next();
                if (!(redefineeSubvertex instanceof State) || (redefinedState = ((State)redefineeSubvertex).getRedefinedState()) == null || allSubvertices.contains((Object)redefinedState)) continue;
                return false;
            }
            EList allTransitions = RegionOperations.getAllTransitions(region);
            Iterator redefineeTransitions = redefineeRegion.getTransitions().iterator();
            while (redefineeTransitions.hasNext()) {
                Transition redefinedTransition = ((Transition)redefineeTransitions.next()).getRedefinedTransition();
                if (redefinedTransition == null || allTransitions.contains((Object)redefinedTransition)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected static EList getAllExtendedRegions(Region region, EList allExtendedRegions) {
        Region extendedRegion = region.getExtendedRegion();
        if (extendedRegion != null && allExtendedRegions.add((Object)extendedRegion)) {
            RegionOperations.getAllExtendedRegions(extendedRegion, allExtendedRegions);
        }
        return allExtendedRegions;
    }

    protected static EList getAllExtendedRegions(Region region) {
        return RegionOperations.getAllExtendedRegions(region, (EList)new UniqueEList.FastCompare());
    }

    protected static EList getAllSubvertices(Region region) {
        UniqueEList.FastCompare allSubvertices = new UniqueEList.FastCompare((Collection)region.getSubvertices());
        Iterator allExtendedRegions = RegionOperations.getAllExtendedRegions(region).iterator();
        while (allExtendedRegions.hasNext()) {
            allSubvertices.addAll((Collection)((Region)allExtendedRegions.next()).getSubvertices());
        }
        return RedefinableElementOperations.excludeRedefinedElements((EList)allSubvertices);
    }

    protected static EList getAllTransitions(Region region) {
        UniqueEList.FastCompare allTransitions = new UniqueEList.FastCompare((Collection)region.getTransitions());
        Iterator allExtendedRegions = RegionOperations.getAllExtendedRegions(region).iterator();
        while (allExtendedRegions.hasNext()) {
            allTransitions.addAll((Collection)((Region)allExtendedRegions.next()).getTransitions());
        }
        return RedefinableElementOperations.excludeRedefinedElements((EList)allTransitions);
    }
}

