/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile;

import edu.umd.cs.findbugs.util.ClassName;
import java.io.Serializable;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDescriptor
implements Comparable<ClassDescriptor>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String className;

    public ClassDescriptor(String className) {
        if (className.indexOf(46) >= 0) {
            throw new IllegalArgumentException(new StringBuffer().append("Class name ").append(className).append(" not in VM format").toString());
        }
        if (!ClassName.isValidClassName(className)) {
            throw new IllegalArgumentException(new StringBuffer().append("Invalid class name ").append(className).toString());
        }
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public int compareTo(ClassDescriptor o) {
        return this.className.compareTo(o.className);
    }

    public String toResourceName() {
        return new StringBuffer().append(this.className).append(".class").toString();
    }

    public String toDottedClassName() {
        return ClassName.toDottedClassName(this.className);
    }

    public static ClassDescriptor fromResourceName(String resourceName) {
        if (!ClassDescriptor.isClassResource(resourceName)) {
            throw new IllegalArgumentException(new StringBuffer().append("Resource ").append(resourceName).append(" is not a class").toString());
        }
        return new ClassDescriptor(resourceName.substring(0, resourceName.length() - 6));
    }

    public static boolean isClassResource(String resourceName) {
        return resourceName.endsWith(".class");
    }

    public String toString() {
        return this.className;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ClassDescriptor other = (ClassDescriptor)obj;
        return this.className.equals(other.className);
    }

    public int hashCode() {
        return this.className.hashCode();
    }

    @Override
    public /* synthetic */ int compareTo(Object x0) {
        return this.compareTo((ClassDescriptor)x0);
    }
}

