/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.annotation;

import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardAnnotationMetadata;
import org.springframework.util.Assert;

public class AnnotatedGenericBeanDefinition
extends GenericBeanDefinition
implements AnnotatedBeanDefinition {
    private final AnnotationMetadata metadata;
    private MethodMetadata factoryMethodMetadata;

    public AnnotatedGenericBeanDefinition(Class<?> beanClass) {
        this.setBeanClass(beanClass);
        this.metadata = new StandardAnnotationMetadata(beanClass, true);
    }

    public AnnotatedGenericBeanDefinition(AnnotationMetadata metadata) {
        Assert.notNull((Object)metadata, (String)"AnnotationMetadata must not be null");
        if (metadata instanceof StandardAnnotationMetadata) {
            this.setBeanClass(((StandardAnnotationMetadata)metadata).getIntrospectedClass());
        } else {
            this.setBeanClassName(metadata.getClassName());
        }
        this.metadata = metadata;
    }

    public AnnotatedGenericBeanDefinition(AnnotationMetadata metadata, MethodMetadata factoryMethodMetadata) {
        this(metadata);
        Assert.notNull((Object)factoryMethodMetadata, (String)"MethodMetadata must not be null");
        this.setFactoryMethodName(factoryMethodMetadata.getMethodName());
        this.factoryMethodMetadata = factoryMethodMetadata;
    }

    @Override
    public final AnnotationMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public final MethodMetadata getFactoryMethodMetadata() {
        return this.factoryMethodMetadata;
    }
}

