##
# This file is part of WhatWeb and may be subject to
# redistribution and commercial restrictions. Please see the WhatWeb
# web site for more information on licensing and terms of use.
# http://www.morningstarsecurity.com/research/whatweb
##
Plugin.define "Utopia-News-Pro" do
author "Brendan Coles <bcoles@gmail.com>" # 2012-05-30
version "0.1"
description "Utopia News Pro - news management system - Homepage: http://www.utopiasoftware.net/newspro/"

# Google results as at 2012-05-30 #
# 77 for intitle:"Powered By Utopia News Pro" inurl:"news.php?action="

# Dorks #
dorks [
'intitle:"Powered By Utopia News Pro" inurl:"news.php?action="'
]



# Matches #
matches [

# Meta Generator
{ :text=>'<meta name="generator" content="Utopia News Pro - http://www.utopiasoftware.net/"/>' },

# Login Page # Version Detection
{ :version=>/<div align="center" class="fbox smallfont">\s*<!-- Copyright -->\s*Powered By: <a href="about\.php[^"^>]*">Utopia News Pro<\/a> ([^<]+)</ },

# Login Page # HTML Comment
{ :text=>'<!-- Beta: editnews2.php -->' },

# Footer
{ :text=>'<div class="sf">News generated by <a href="http://www.utopiasoftware.net">Utopia News Pro</a></div>' },

# HTML Comment
{ :text=>'<!-- PrintNews.Bit -->' },

]

end

