require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MACHINE_PMAP_H_)) {
    eval 'sub _MACHINE_PMAP_H_ () {1;}' unless defined(&_MACHINE_PMAP_H_);
    if(defined(&_KERNEL)) {
	require 'machine/cpufunc.ph';
	require 'machine/segments.ph';
    }
    require 'sys/mutex.ph';
    require 'uvm/uvm_object.ph';
    require 'machine/pte.ph';
    eval 'sub PDSLOT_PTE () {(( &KERNBASE/ &NBPD)-2);}' unless defined(&PDSLOT_PTE);
    eval 'sub PDSLOT_KERN () {( &KERNBASE/ &NBPD);}' unless defined(&PDSLOT_KERN);
    eval 'sub PDSLOT_APTE () {(1022);}' unless defined(&PDSLOT_APTE);
    unless(defined(&NKPTP)) {
	eval 'sub NKPTP () {8;}' unless defined(&NKPTP);
    }
    eval 'sub NKPTP_MIN () {4;}' unless defined(&NKPTP_MIN);
    eval 'sub PG_W () { &PG_AVAIL1;}' unless defined(&PG_W);
    eval 'sub PG_PVLIST () { &PG_AVAIL2;}' unless defined(&PG_PVLIST);
    eval 'sub PG_X () { &PG_AVAIL3;}' unless defined(&PG_X);
    eval 'sub PTP0_PA () {( &PAGE_SIZE * 3);}' unless defined(&PTP0_PA);
    if(defined(&_KERNEL)) {
	eval 'sub PMAP_PA_MASK () {~(( &paddr_t) &PAGE_MASK);}' unless defined(&PMAP_PA_MASK);
	eval 'sub PMAP_NOCACHE () {0x1;}' unless defined(&PMAP_NOCACHE);
	eval 'sub PMAP_WC () {0x2;}' unless defined(&PMAP_WC);
	eval 'sub PG_PMAP_MOD () { &PG_PMAP0;}' unless defined(&PG_PMAP_MOD);
	eval 'sub PG_PMAP_REF () { &PG_PMAP1;}' unless defined(&PG_PMAP_REF);
	eval 'sub PG_PMAP_WC () { &PG_PMAP2;}' unless defined(&PG_PMAP_WC);
	eval 'sub PVE_PER_PVPAGE () {(( &PAGE_SIZE - $sizeof{\'struct pv_page_info\'}) / $sizeof{\'struct pv_entry\'});}' unless defined(&PVE_PER_PVPAGE);
	eval 'sub PMAP_REMOVE_ALL () {0;}' unless defined(&PMAP_REMOVE_ALL);
	eval 'sub PMAP_REMOVE_SKIPWIRED () {1;}' unless defined(&PMAP_REMOVE_SKIPWIRED);
	eval 'sub pmap_kernel () {
	    eval q(( &kernel_pmap_store));
	}' unless defined(&pmap_kernel);
	eval 'sub pmap_wired_count {
	    my($pmap) = @_;
    	    eval q((($pmap)-> ($pm_stats->{wired_count})));
	}' unless defined(&pmap_wired_count);
	eval 'sub pmap_resident_count {
	    my($pmap) = @_;
    	    eval q((($pmap)-> ($pm_stats->{resident_count})));
	}' unless defined(&pmap_resident_count);
	eval 'sub pmap_update {
	    my($pm) = @_;
    	    eval q();
	}' unless defined(&pmap_update);
	eval 'sub pmap_clear_modify {
	    my($pg) = @_;
    	    eval q( &pmap_clear_attrs($pg,  &PG_M));
	}' unless defined(&pmap_clear_modify);
	eval 'sub pmap_clear_reference {
	    my($pg) = @_;
    	    eval q( &pmap_clear_attrs($pg,  &PG_U));
	}' unless defined(&pmap_clear_reference);
	eval 'sub pmap_copy {
	    my($DP,$SP,$D,$L,$S) = @_;
    	    eval q();
	}' unless defined(&pmap_copy);
	eval 'sub pmap_is_modified {
	    my($pg) = @_;
    	    eval q( &pmap_test_attrs($pg,  &PG_M));
	}' unless defined(&pmap_is_modified);
	eval 'sub pmap_is_referenced {
	    my($pg) = @_;
    	    eval q( &pmap_test_attrs($pg,  &PG_U));
	}' unless defined(&pmap_is_referenced);
	eval 'sub pmap_valid_entry {
	    my($E) = @_;
    	    eval q((($E) &  &PG_V));
	}' unless defined(&pmap_valid_entry);
	eval 'sub pmap_proc_iflush {
	    my($p,$va,$len) = @_;
    	    eval q();
	}' unless defined(&pmap_proc_iflush);
	eval 'sub pmap_unuse_final {
	    my($p) = @_;
    	    eval q();
	}' unless defined(&pmap_unuse_final);
	eval 'sub pmap_remove_holes {
	    my($vm) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&pmap_remove_holes);
	eval 'sub pmap_pte_set () {(* &pmap_pte_set_p);}' unless defined(&pmap_pte_set);
	eval 'sub pmap_pte_setbits () {(* &pmap_pte_setbits_p);}' unless defined(&pmap_pte_setbits);
	eval 'sub pmap_pte_bits () {(* &pmap_pte_bits_p);}' unless defined(&pmap_pte_bits);
	eval 'sub pmap_pte_paddr () {(* &pmap_pte_paddr_p);}' unless defined(&pmap_pte_paddr);
	eval 'sub pmap_clear_attrs () {(* &pmap_clear_attrs_p);}' unless defined(&pmap_clear_attrs);
	eval 'sub pmap_page_remove () {(* &pmap_page_remove_p);}' unless defined(&pmap_page_remove);
	eval 'sub pmap_do_remove () {(* &pmap_do_remove_p);}' unless defined(&pmap_do_remove);
	eval 'sub pmap_test_attrs () {(* &pmap_test_attrs_p);}' unless defined(&pmap_test_attrs);
	eval 'sub pmap_unwire () {(* &pmap_unwire_p);}' unless defined(&pmap_unwire);
	eval 'sub pmap_write_protect () {(* &pmap_write_protect_p);}' unless defined(&pmap_write_protect);
	eval 'sub pmap_pinit_pd () {(* &pmap_pinit_pd_p);}' unless defined(&pmap_pinit_pd);
	eval 'sub pmap_zero_phys () {(* &pmap_zero_phys_p);}' unless defined(&pmap_zero_phys);
	eval 'sub pmap_zero_page_uncached () {(* &pmap_zero_page_uncached_p);}' unless defined(&pmap_zero_page_uncached);
	eval 'sub pmap_copy_page () {(* &pmap_copy_page_p);}' unless defined(&pmap_copy_page);
	if(defined(&MULTIPROCESSOR)) {
	} else {
	    eval 'sub pmap_tlb_shootwait () {
	        eval q();
	    }' unless defined(&pmap_tlb_shootwait);
	}
	eval 'sub PMAP_GROWKERNEL () {1;}' unless defined(&PMAP_GROWKERNEL);
	eval 'sub PMAP_PAGEIDLEZERO {
	    my($pg) = @_;
    	    eval q( &pmap_zero_page_uncached( &VM_PAGE_TO_PHYS($pg)));
	}' unless defined(&PMAP_PAGEIDLEZERO);
	eval 'sub pmap_update_pg {
	    my($va) = @_;
    	    eval q( &invlpg(($va)));
	}' unless defined(&pmap_update_pg);
	eval 'sub pmap_update_2pg {
	    my($va, $vb) = @_;
    	    eval q({  &invlpg();  &invlpg(($vb)); });
	}' unless defined(&pmap_update_2pg);
	eval 'sub pmap_is_curpmap {
	    my($pmap) = @_;
    	    eval q({ ( &pmap_is_active($pmap,  &curcpu())); });
	}' unless defined(&pmap_is_curpmap);
    }
    eval 'sub VM_MDPAGE_INIT {
        my($pg) = @_;
	    eval q( &do {  &mtx_init(($pg)-> ($mdpage->{pv_mtx}),  &IPL_VM); ($pg)-> ($mdpage->{pv_list}) =  &NULL; }  &while (0));
    }' unless defined(&VM_MDPAGE_INIT);
}
1;
